/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business;

import ch.systemsx.cisd.lims.base.ExperimentIdentifier;
import ch.systemsx.cisd.lims.base.MoleculeCriteria;
import ch.systemsx.cisd.lims.base.PlateLocation;
import ch.systemsx.cisd.lims.base.QueryRestriction;
import ch.systemsx.cisd.lims.base.Sample;
import ch.systemsx.cisd.lims.base.SampleComponent;
import ch.systemsx.cisd.lims.base.SearchHitDescription;
import ch.systemsx.cisd.lims.base.SearchResult;
import ch.systemsx.cisd.lims.server.business.AbstractManager;
import ch.systemsx.cisd.lims.server.business.IExperimentManager;
import ch.systemsx.cisd.lims.server.business.IGenericManager;
import ch.systemsx.cisd.lims.server.business.ISampleManager;
import ch.systemsx.cisd.lims.server.business.Session;
import ch.systemsx.cisd.lims.server.business.StrategyFactoryProvider;
import ch.systemsx.cisd.lims.server.business.bo.IBusinessObjectFactory;
import ch.systemsx.cisd.lims.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.lims.server.dto.BaseExperimentDTO;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericManager
extends AbstractManager
implements IGenericManager {
    private static final String CODE = "[A-Z0-9_\\-]+";
    private static final Pattern MATERIAL_SPLIT_PATTERN = Pattern.compile(String.format("(%s) \\((%s)\\)", "[A-Z0-9_\\-]+", "[A-Z0-9_\\-]+"), 2);
    private static final int MATERIAL_CODE_IDX = 1;
    private static final int MATERIAL_TYPE_CODE_IDX = 2;
    private final ISampleManager sampleManager;
    private final IExperimentManager experimentManager;

    GenericManager(IDAOFactory daoFactory, StrategyFactoryProvider strategyProvider, IBusinessObjectFactory boFactory, ISampleManager sampleManager, IExperimentManager experimentManager) {
        super(daoFactory, strategyProvider, boFactory);
        this.sampleManager = sampleManager;
        this.experimentManager = experimentManager;
    }

    @Override
    public SearchResult search(Session session, String searchTerm) {
        Collection<SearchHitDescription> experiments = this.daoFactory.getExperimentDAO().searchForExperiments(searchTerm);
        LinkedList<SearchHitDescription> samples = new LinkedList<SearchHitDescription>(this.daoFactory.getSampleDAO().searchForSamples(searchTerm));
        Collection<SearchHitDescription> materials = this.daoFactory.getMaterialDAO().searchForMaterials(searchTerm);
        Collection<SearchHitDescription> plateLocationSamples = this.getPlateLocationSamples(session, materials);
        samples.addAll(plateLocationSamples);
        return new SearchResult(GenericManager.toArray(experiments), GenericManager.toArray(samples), GenericManager.toArray(materials));
    }

    private Collection<SearchHitDescription> getPlateLocationSamples(Session session, Collection<SearchHitDescription> materials) {
        LinkedList<SearchHitDescription> samples = new LinkedList<SearchHitDescription>();
        LinkedList<ExperimentIdentifier> allExperimentIds = new LinkedList<ExperimentIdentifier>();
        HashMap<String, SearchHitDescription> masterPlateMap = new HashMap<String, SearchHitDescription>();
        if (materials.size() > 0) {
            BaseExperimentDTO[] experimentDTOs;
            BaseExperimentDTO[] baseExperimentDTOArray = experimentDTOs = this.experimentManager.listExperiments(session, new QueryRestriction());
            int n = experimentDTOs.length;
            int n2 = 0;
            while (n2 < n) {
                BaseExperimentDTO experimentDTO = baseExperimentDTOArray[n2];
                allExperimentIds.add(new ExperimentIdentifier(experimentDTO.getProject().getCode(), experimentDTO.getCode()));
                ++n2;
            }
        }
        for (SearchHitDescription material : materials) {
            Matcher m = MATERIAL_SPLIT_PATTERN.matcher(material.getEntity());
            if (!m.matches()) continue;
            MoleculeCriteria criteria = new MoleculeCriteria();
            criteria.setTypeCode(m.group(2));
            criteria.setCode(m.group(1));
            for (ExperimentIdentifier experimentIdentifier : allExperimentIds) {
                PlateLocation[] plateLocations;
                PlateLocation[] plateLocationArray = plateLocations = this.sampleManager.getPlateLocations(session, experimentIdentifier, criteria, false);
                int n = plateLocations.length;
                int n3 = 0;
                while (n3 < n) {
                    PlateLocation location = plateLocationArray[n3];
                    String hitDescription = GenericManager.getPlateLocationHitDescription(location, criteria.getTypeCode(), criteria.getCode(), material.getHitDescription());
                    masterPlateMap.put(location.getMasterPlateCode(), GenericManager.describeMasterPlateLocation(location, hitDescription));
                    samples.addAll((Collection<SearchHitDescription>)Arrays.asList(GenericManager.describePlateLocations(location, experimentIdentifier, hitDescription)));
                    ++n3;
                }
            }
        }
        for (SearchHitDescription masterPlateHitDescription : masterPlateMap.values()) {
            samples.addFirst(masterPlateHitDescription);
        }
        return samples;
    }

    private static SearchHitDescription[] toArray(Collection<SearchHitDescription> results) {
        return results.toArray(new SearchHitDescription[results.size()]);
    }

    private static SearchHitDescription describeMasterPlateLocation(PlateLocation plateLocation, String hitDescription) {
        return new SearchHitDescription(String.format("%s (MASTER_PLATE)", plateLocation.getMasterPlateCode()), hitDescription);
    }

    private static SearchHitDescription[] describePlateLocations(PlateLocation plateLocation, ExperimentIdentifier experimentIdentifier, String hitDescription) {
        SearchHitDescription[] descriptions = new SearchHitDescription[plateLocation.getSamples().length];
        int i = 0;
        while (i < plateLocation.getSamples().length) {
            Sample sample = plateLocation.getSamples()[i];
            descriptions[i] = new SearchHitDescription(String.format("%s (%s)", sample.getCode(), sample.getSampleType().getCode()), String.valueOf(hitDescription) + ", Experiment " + experimentIdentifier.describe());
            ++i;
        }
        return descriptions;
    }

    private static String getPlateLocationHitDescription(PlateLocation plateLocation, String materialTypeCode, String materialCode, String materialSearchHitDescription) {
        String sampleComponentDescription = GenericManager.describeSampleComponents(plateLocation.getSampleComponents());
        String hitDescription = String.format("Material %s (%s) found in well(s) %s [%s]", materialCode, materialTypeCode, sampleComponentDescription, materialSearchHitDescription);
        return hitDescription;
    }

    private static String describeSampleComponents(SampleComponent[] sampleComponents) {
        StringBuilder builder = new StringBuilder();
        SampleComponent[] sampleComponentArray = sampleComponents;
        int n = sampleComponents.length;
        int n2 = 0;
        while (n2 < n) {
            SampleComponent component = sampleComponentArray[n2];
            builder.append(component.getCode()).append(", ");
            ++n2;
        }
        builder.setLength(builder.length() - 2);
        return builder.toString();
    }
}

