/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.utilities.PathPrefixPrepender;
import ch.systemsx.cisd.lims.server.business.IProcessingInstructionValidator;
import ch.systemsx.cisd.lims.server.dto.ProcessingInstructionDTO;
import java.io.File;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessingPathValidator
implements IProcessingInstructionValidator {
    private final Map<String, PathPrefixPrepender> pathPrefixPrependers;

    public ProcessingPathValidator(Map<String, PathPrefixPrepender> pathPrefixPrependers) {
        this.pathPrefixPrependers = pathPrefixPrependers;
    }

    @Override
    public void assertValid(ProcessingInstructionDTO processingInstruction) throws UserFailureException {
        String procedureTypeCode = processingInstruction.getProcedureTypeCode();
        PathPrefixPrepender pathPrefixPrepender = this.pathPrefixPrependers.get(procedureTypeCode);
        if (pathPrefixPrepender == null) {
            throw new ConfigurationFailureException("No path prefix prependers found for procedure type code '" + procedureTypeCode + "'.");
        }
        File folder = new File(pathPrefixPrepender.addPrefixTo(processingInstruction.getPath()));
        if (!folder.exists()) {
            this.throwUserFailureException(" '" + folder.getAbsolutePath() + "' does not exist.");
        }
        if (!folder.isDirectory()) {
            this.throwUserFailureException(" Referres to a file and not to a folder: " + folder.getAbsolutePath());
        }
        if (!folder.canRead()) {
            this.throwUserFailureException(" Read-access denied for folder: " + folder.getAbsolutePath());
        }
        if (!folder.canWrite()) {
            this.throwUserFailureException(" Read-only folder: " + folder.getAbsolutePath());
        }
    }

    private void throwUserFailureException(String message) {
        throw new UserFailureException("Invalid processing path:" + message);
    }
}

