/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business.bo;

import ch.systemsx.cisd.common.collections.IKeyExtractor;
import ch.systemsx.cisd.common.collections.TableMap;
import ch.systemsx.cisd.common.exceptions.InternalErr;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.lims.base.properties.EntityKind;
import ch.systemsx.cisd.lims.base.properties.EntityProperties;
import ch.systemsx.cisd.lims.base.properties.EntityPropertiesSchema;
import ch.systemsx.cisd.lims.base.properties.EntityPropertySchema;
import ch.systemsx.cisd.lims.base.properties.EntityPropertyValue;
import ch.systemsx.cisd.lims.base.properties.IEntityPropertiesSchema;
import ch.systemsx.cisd.lims.base.properties.PropertyType;
import ch.systemsx.cisd.lims.base.properties.SimpleEntityProperty;
import ch.systemsx.cisd.lims.server.business.bo.IEntityPropertiesConverter;
import ch.systemsx.cisd.lims.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.lims.server.dataaccess.IEntityPropertyTypeDAO;
import ch.systemsx.cisd.lims.server.dataaccess.IEntityTypeDAO;
import ch.systemsx.cisd.lims.server.dataaccess.IVocabularyDAO;
import ch.systemsx.cisd.lims.server.dto.EntityPropertyValueDTO;
import ch.systemsx.cisd.lims.server.dto.EntityTypeDTO;
import ch.systemsx.cisd.lims.server.dto.IEntityPropertiesHolderDTO;
import ch.systemsx.cisd.lims.server.dto.VocabularyTermDTO;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EntityPropertiesConverter
implements IEntityPropertiesConverter {
    private final EntityPropertyTypesCache entityPropertyTypesCache;

    EntityPropertiesConverter(EntityKind entityKind, IDAOFactory daoFactory) {
        this.entityPropertyTypesCache = new EntityPropertyTypesCache(daoFactory.getEntityPropertyTypeDAO(entityKind), daoFactory.getEntityTypeDAO(entityKind), daoFactory.getVocabularyDAO());
    }

    @Override
    public SimpleEntityProperty[] convertProperties(IEntityPropertiesHolderDTO entity) {
        EntityTypeDTO entityType = entity.getEntityType();
        EntityPropertyTypesDescriptor descriptor = this.entityPropertyTypesCache.getDescriptor(entityType.getCode(), entityType.getId());
        return this.convert(entity.getProperties(), descriptor);
    }

    private SimpleEntityProperty[] convert(EntityPropertyValueDTO[] properties, EntityPropertyTypesDescriptor descriptor) {
        EntityProperties entityProperties = new EntityProperties(descriptor.getPropertiesSchema());
        EntityPropertyValueDTO[] entityPropertyValueDTOArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            EntityPropertyValueDTO property = entityPropertyValueDTOArray[n2];
            String propertyName = descriptor.getPropertyName(property.getEntityPropertyTypeId());
            entityProperties.setProperty(propertyName, property.tryGetUntypedValue());
            ++n2;
        }
        return entityProperties.createSimple();
    }

    @Override
    public EntityPropertyValueDTO[] convertProperties(SimpleEntityProperty[] properties, String entityTypeCode, Long registratorID) {
        EntityPropertyTypesDescriptor descriptor = this.entityPropertyTypesCache.getDescriptor(entityTypeCode);
        return this.convert(properties, descriptor, registratorID);
    }

    @Override
    public EntityPropertyValueDTO convertProperty(SimpleEntityProperty property, String entityTypeCode, Long registratorID) {
        EntityPropertyTypesDescriptor descriptor = this.entityPropertyTypesCache.getDescriptor(entityTypeCode);
        return this.convert(property, descriptor, registratorID);
    }

    private EntityPropertyValueDTO[] convert(SimpleEntityProperty[] properties, EntityPropertyTypesDescriptor descriptor, Long registratorID) {
        EntityPropertyValueDTO[] result = new EntityPropertyValueDTO[properties.length];
        HashSet<String> presentProperties = new HashSet<String>();
        IEntityPropertiesSchema schema = descriptor.getPropertiesSchema();
        int i = 0;
        while (i < properties.length) {
            SimpleEntityProperty property = properties[i];
            presentProperties.add(property.getCode());
            result[i] = this.convert(property, descriptor, registratorID);
            ++i;
        }
        this.checkPropertiesMandatoryConstraint(schema, presentProperties);
        return result;
    }

    private EntityPropertyValueDTO convert(SimpleEntityProperty property, EntityPropertyTypesDescriptor descriptor, Long registratorID) {
        IEntityPropertiesSchema schema = descriptor.getPropertiesSchema();
        String untypedValue = EntityPropertyValue.createFromSimple(property).tryGetUntypedValue();
        String propertyName = property.getCode();
        schema.validateAndCreateValue(propertyName, untypedValue);
        long entityPropertyTypeId = descriptor.getEntityPropertyTypeId(propertyName);
        EntityPropertyValueDTO entityPropertyValue = new EntityPropertyValueDTO(registratorID, entityPropertyTypeId, descriptor.getPropertyTypeId(entityPropertyTypeId));
        PropertyType propertyType = schema.getPropertySchema(propertyName).getPropertyType();
        Long vocabularyTermId = this.tryGetAndCheckVocabularyTerm(untypedValue, descriptor, propertyType);
        entityPropertyValue.setUntypedValue(untypedValue, vocabularyTermId);
        return entityPropertyValue;
    }

    private Long tryGetAndCheckVocabularyTerm(String untypedValueOrNull, EntityPropertyTypesDescriptor descriptor, PropertyType propertyType) throws UserFailureException {
        if (untypedValueOrNull == null) {
            return null;
        }
        String vocabularyCode = propertyType.getVocabularyCode();
        if (vocabularyCode != null) {
            return descriptor.getTermId(vocabularyCode, untypedValueOrNull);
        }
        return null;
    }

    private void checkPropertiesMandatoryConstraint(IEntityPropertiesSchema schema, Set<String> presentProperties) {
        String[] stringArray = schema.getAllNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            EntityPropertySchema propertySchema = schema.getPropertySchema(name);
            if (propertySchema.getIsMandatory() && !presentProperties.contains(name)) {
                throw new UserFailureException("No entity property value for '" + name + "'.");
            }
            ++n2;
        }
    }

    private static VocabularyTermsMap fetchVocabularyTerms(IVocabularyDAO vocabularyDAO, String vocabularyCode) {
        VocabularyTermsMap termsSet = new VocabularyTermsMap(vocabularyCode);
        List<VocabularyTermDTO> vocabularyTerms = vocabularyDAO.listVocabularyTerms(vocabularyCode);
        for (VocabularyTermDTO term : vocabularyTerms) {
            termsSet.put(term.getCode(), term.getId());
        }
        return termsSet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EntityPropertyTypeById
    extends TableMap<Long, EntityPropertySchema> {
        EntityPropertyTypeById(Iterable<EntityPropertySchema> rows) {
            super(rows, new IKeyExtractor<Long, EntityPropertySchema>(){

                @Override
                public Long getKey(EntityPropertySchema e) {
                    return e.getId();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EntityPropertyTypeByName
    extends TableMap<String, EntityPropertySchema> {
        EntityPropertyTypeByName(Iterable<EntityPropertySchema> rows) {
            super(rows, new IKeyExtractor<String, EntityPropertySchema>(){

                @Override
                public String getKey(EntityPropertySchema e) {
                    return e.getCode();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EntityPropertyTypesCache {
        private final Map<String, EntityPropertyTypesDescriptor> cache = new LinkedHashMap<String, EntityPropertyTypesDescriptor>();
        private final IEntityPropertyTypeDAO entityPropertyTypeDAO;
        private final IEntityTypeDAO entityTypeDAO;
        private final IVocabularyDAO vocabularyDAO;

        public EntityPropertyTypesCache(IEntityPropertyTypeDAO entityPropertyTypeDAO, IEntityTypeDAO entityTypeDAO, IVocabularyDAO vocabularyDAO) {
            this.entityPropertyTypeDAO = entityPropertyTypeDAO;
            this.entityTypeDAO = entityTypeDAO;
            this.vocabularyDAO = vocabularyDAO;
        }

        public EntityPropertyTypesDescriptor getDescriptor(String entityTypeCode) {
            EntityPropertyTypesDescriptor descriptor = this.cache.get(entityTypeCode);
            if (descriptor == null) {
                long entityTypeId = this.getEntityTypeId(entityTypeCode);
                descriptor = this.fetchDescriptorAndSave(entityTypeCode, entityTypeId);
            }
            return descriptor;
        }

        private long getEntityTypeId(String entityTypeCode) {
            EntityTypeDTO entityType = this.entityTypeDAO.tryToFindEntityTypeByCode(entityTypeCode);
            if (entityType == null) {
                throw new UserFailureException("Entity type with the code " + entityTypeCode + " does not exist!");
            }
            return entityType.getId();
        }

        public EntityPropertyTypesDescriptor getDescriptor(String entityTypeCode, Long entityTypeId) {
            EntityPropertyTypesDescriptor descriptor = this.cache.get(entityTypeCode);
            if (descriptor == null) {
                descriptor = this.fetchDescriptorAndSave(entityTypeCode, entityTypeId);
            }
            return descriptor;
        }

        private EntityPropertyTypesDescriptor fetchDescriptorAndSave(String entityTypeCode, long entityTypeId) {
            EntityPropertyTypesDescriptor descriptor = this.fetchDescriptor(entityTypeId);
            this.cache.put(entityTypeCode, descriptor);
            return descriptor;
        }

        private EntityPropertyTypesDescriptor fetchDescriptor(long entityTypeId) {
            List<EntityPropertySchema> propertyTypes = this.entityPropertyTypeDAO.listEntityPropertyTypes(entityTypeId);
            UsedVocabularyTerms vocabularyMap = this.fetchUsedVocabularyTerms(propertyTypes);
            return this.createDescriptor(propertyTypes, vocabularyMap);
        }

        private EntityPropertyTypesDescriptor createDescriptor(List<EntityPropertySchema> propertyTypes, UsedVocabularyTerms vocabularyMap) {
            EntityPropertyTypeById propertyTypeById = new EntityPropertyTypeById(propertyTypes);
            EntityPropertyTypeByName propertyTypeByName = new EntityPropertyTypeByName(propertyTypes);
            IEntityPropertiesSchema schema = EntityPropertiesSchema.create(propertyTypes);
            return new EntityPropertyTypesDescriptor(schema, vocabularyMap, propertyTypeById, propertyTypeByName);
        }

        private UsedVocabularyTerms fetchUsedVocabularyTerms(List<EntityPropertySchema> propertyTypes) {
            UsedVocabularyTerms map = new UsedVocabularyTerms();
            for (EntityPropertySchema propertySchema : propertyTypes) {
                String vocabularyCode = propertySchema.getPropertyType().getVocabularyCode();
                if (vocabularyCode == null || map.containsVocabulary(vocabularyCode)) continue;
                VocabularyTermsMap terms = EntityPropertiesConverter.fetchVocabularyTerms(this.vocabularyDAO, vocabularyCode);
                map.putVocabulary(vocabularyCode, terms);
            }
            return map;
        }
    }

    private static class EntityPropertyTypesDescriptor {
        private final IEntityPropertiesSchema schema;
        private final UsedVocabularyTerms vocabularyMap;
        private final EntityPropertyTypeById propertyTypeById;
        private final EntityPropertyTypeByName propertyTypeByName;

        public EntityPropertyTypesDescriptor(IEntityPropertiesSchema schema, UsedVocabularyTerms vocabularyMap, EntityPropertyTypeById propertyTypeById, EntityPropertyTypeByName propertyTypeByName) {
            this.schema = schema;
            this.vocabularyMap = vocabularyMap;
            this.propertyTypeById = propertyTypeById;
            this.propertyTypeByName = propertyTypeByName;
        }

        public IEntityPropertiesSchema getPropertiesSchema() {
            return this.schema;
        }

        public Long getTermId(String vocabularyCode, String vocabularyTerm) {
            return this.vocabularyMap.getTermId(vocabularyCode, vocabularyTerm);
        }

        public long getEntityPropertyTypeId(String propertyName) {
            EntityPropertySchema propertyType = (EntityPropertySchema)this.propertyTypeByName.tryGet(propertyName);
            this.assertNotNull(propertyType);
            return propertyType.getId();
        }

        public String getPropertyName(long entityPropertyTypeId) {
            EntityPropertySchema propertyType = (EntityPropertySchema)this.propertyTypeById.tryGet(entityPropertyTypeId);
            this.assertNotNull(propertyType);
            return propertyType.getCode();
        }

        public long getPropertyTypeId(long entityPropertyTypeId) {
            EntityPropertySchema propertyType = (EntityPropertySchema)this.propertyTypeById.tryGet(entityPropertyTypeId);
            this.assertNotNull(propertyType);
            return propertyType.getPropertyTypeId();
        }

        private void assertNotNull(Object obj) {
            if (obj == null) {
                throw InternalErr.error();
            }
        }
    }

    private static class UsedVocabularyTerms {
        private final Map<String, VocabularyTermsMap> map = new HashMap<String, VocabularyTermsMap>();

        public void putVocabulary(String vocabularyCode, VocabularyTermsMap terms) {
            this.map.put(vocabularyCode, terms);
        }

        public boolean containsVocabulary(String vocabularyCode) {
            return this.map.containsKey(vocabularyCode);
        }

        public Long getTermId(String vocabularyCode, String vocabularyTerm) {
            VocabularyTermsMap terms = this.map.get(vocabularyCode);
            if (terms == null) {
                throw InternalErr.error("Vocabulary terms were not fetched for " + vocabularyCode);
            }
            return terms.getTermId(vocabularyTerm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VocabularyTermsMap
    extends HashMap<String, Long> {
        private final String vocabularyCode;

        public VocabularyTermsMap(String vocabularyCode) {
            this.vocabularyCode = vocabularyCode;
        }

        public Long getTermId(String vocabularyTerm) {
            if (vocabularyTerm == null) {
                throw new IllegalArgumentException("Unspecified vocabulary term for vocabulary set '" + this.vocabularyCode + "'.");
            }
            Long termId = (Long)super.get(vocabularyTerm.toUpperCase());
            if (termId == null) {
                throw UserFailureException.fromTemplate("Incorrect value '%s' for a controlled vocabulary set '%s'.", vocabularyTerm, this.vocabularyCode);
            }
            return termId;
        }
    }
}

