/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business.bo;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.utilities.BeanUtils;
import ch.systemsx.cisd.lims.base.ExperimentFileAttachment;
import ch.systemsx.cisd.lims.base.ExperimentIdentifier;
import ch.systemsx.cisd.lims.base.NewExperiment;
import ch.systemsx.cisd.lims.base.properties.EntityKind;
import ch.systemsx.cisd.lims.base.properties.SimpleEntityProperty;
import ch.systemsx.cisd.lims.server.business.BeanUtilsConverters;
import ch.systemsx.cisd.lims.server.business.IScreeningProcessStrategy;
import ch.systemsx.cisd.lims.server.business.ParameterChecker;
import ch.systemsx.cisd.lims.server.business.Session;
import ch.systemsx.cisd.lims.server.business.bo.AbstractBusinessObject;
import ch.systemsx.cisd.lims.server.business.bo.EntityPropertyFiller;
import ch.systemsx.cisd.lims.server.business.bo.IBusinessObjectFactory;
import ch.systemsx.cisd.lims.server.business.bo.IEntityPropertiesConverter;
import ch.systemsx.cisd.lims.server.business.bo.IExperimentBO;
import ch.systemsx.cisd.lims.server.business.bo.IProcessingInstructionTable;
import ch.systemsx.cisd.lims.server.business.bo.InvalidationFiller;
import ch.systemsx.cisd.lims.server.business.bo.MaterialTable;
import ch.systemsx.cisd.lims.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.lims.server.dataaccess.IEntityPropertyProviderDAO;
import ch.systemsx.cisd.lims.server.dataaccess.IExperimentAttachmentDAO;
import ch.systemsx.cisd.lims.server.dataaccess.IExperimentDAO;
import ch.systemsx.cisd.lims.server.dto.EntityPropertyValueDTO;
import ch.systemsx.cisd.lims.server.dto.ExperimentDTO;
import ch.systemsx.cisd.lims.server.dto.ExperimentFileAttachmentDTO;
import ch.systemsx.cisd.lims.server.dto.ExperimentTypeDTO;
import ch.systemsx.cisd.lims.server.dto.FilePropertyDTO;
import ch.systemsx.cisd.lims.server.dto.InvalidationDTO;
import ch.systemsx.cisd.lims.server.dto.ProcessingInstructionDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExperimentBO
extends AbstractBusinessObject
implements IExperimentBO {
    private static final char HIDDEN_EXPERIMENT_PROPERTY_PREFIX_CHARACTER = '$';
    private static final String HIDDEN_EXPERIMENT_PROPERTY_PREFIX = Character.toString('$');
    private static final String HIDDEN_EXPERIMENT_PROPERTY_PREFIX2 = String.valueOf(HIDDEN_EXPERIMENT_PROPERTY_PREFIX) + HIDDEN_EXPERIMENT_PROPERTY_PREFIX;
    private final IBusinessObjectFactory boFactory;
    private final IScreeningProcessStrategy processStrategy;
    private final IEntityPropertiesConverter entityPropertiesConverter;
    private ExperimentDTO experiment;
    private boolean dataChanged;
    private List<ExperimentFileAttachmentDTO> attachments = new ArrayList<ExperimentFileAttachmentDTO>();

    ExperimentBO(IDAOFactory daoFactory, IBusinessObjectFactory boFactory, IScreeningProcessStrategy processStrategy, IEntityPropertiesConverter entityPropertiesConverter, Session session) {
        super(daoFactory, session);
        this.boFactory = boFactory;
        this.processStrategy = processStrategy;
        this.entityPropertiesConverter = entityPropertiesConverter;
    }

    private ExperimentIdentifier createExperimentIdentifier() {
        return new ExperimentIdentifier(this.experiment.getProject().getCode(), this.experiment.getCode());
    }

    @Override
    public ExperimentDTO getExperiment() {
        return this.experiment;
    }

    @Override
    public void loadByProcedureID(long procedureID, boolean allowNothingFound) {
        try {
            this.experiment = this.getExperimentDAO().getExperimentByProcedureId(procedureID);
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            if (allowNothingFound) {
                this.experiment = null;
            }
            throw new UserFailureException("No experiment for procedure " + procedureID + " could be found in the database.");
        }
        this.dataChanged = false;
    }

    @Override
    public void loadByExperimentIdentifier(ExperimentIdentifier identifier, boolean allowNothingFound) {
        ParameterChecker.checkExperimentIdentifier(identifier);
        long groupId = this.session.getGroupId();
        String projectCode = identifier.getProjectCode();
        try {
            IExperimentDAO experimentDAO = this.getExperimentDAO();
            String experimentCode = identifier.getExperimentCode();
            Long experimentId = experimentDAO.getExperimentIdByCode(groupId, projectCode, experimentCode);
            this.experiment = experimentDAO.getExperimentWithRegistratorMaterialProject(experimentId);
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            if (allowNothingFound) {
                this.experiment = null;
            }
            throw UserFailureException.fromTemplate("No experiment with identifier '%s' could be found in the database.", identifier);
        }
        this.dataChanged = false;
    }

    @Override
    public void loadByExperimentIdentifierOrSampleCode(ExperimentIdentifier experimentIdentifier, String sampleCode) {
        this.experiment = this.processStrategy.getExperiment(experimentIdentifier, sampleCode);
    }

    @Override
    public void fill(NewExperiment newExperiment) {
        ParameterChecker.checkIfNotNull(newExperiment, "experiment");
        this.experiment = this.convertExperimentBasics(newExperiment);
        String experimentTypeCode = newExperiment.getExperimentTypeCode();
        ExperimentTypeDTO experimentType = this.getExperimentTypeDAO().tryFindExperimentTypeByCode(experimentTypeCode);
        if (experimentType == null) {
            throw UserFailureException.fromTemplate("No experiment type with code '%s' could be found in the database.", experimentTypeCode);
        }
        this.experiment.setExperimentType(experimentType);
        String studyObjectCode = newExperiment.getStudyObjectCode();
        String studyObjectTypeCode = newExperiment.getStudyObjectTypeCode();
        Long materialId = MaterialTable.getMaterialId(this.getMaterialDAO(), studyObjectCode, studyObjectTypeCode);
        this.experiment.setStudyObject(this.getMaterialDAO().getMaterialById(materialId));
        long groupId = this.session.getGroupId();
        String projectCode = newExperiment.getProjectCode();
        try {
            this.experiment.setProject(this.getProjectDAO().getProject(groupId, projectCode));
            this.dataChanged = true;
        }
        catch (EmptyResultDataAccessException ex) {
            throw UserFailureException.fromTemplate(ex, "No project with code '%s' could be found in the database.", projectCode);
        }
        this.dataChanged = true;
    }

    private ExperimentDTO convertExperimentBasics(NewExperiment newExperiment) {
        final long registratorId = this.findRegistratorID();
        ExperimentDTO convertedExperiment = new ExperimentDTO(registratorId);
        BeanUtils.fillBean(ExperimentDTO.class, convertedExperiment, newExperiment, new BeanUtils.Converter(){

            public EntityPropertyValueDTO[] convertToProperties(NewExperiment experiment2) {
                SimpleEntityProperty[] properties = experiment2.getProperties();
                String typeCode = experiment2.getEntityType().getCode();
                return ExperimentBO.this.entityPropertiesConverter.convertProperties(properties, typeCode, registratorId);
            }
        });
        return convertedExperiment;
    }

    @Override
    public void enrichWithProcessingInstructions() {
        if (this.experiment != null && this.experiment.getId() != null) {
            IProcessingInstructionTable processingInstructions = this.boFactory.createProcessingInstructionTable(this.session);
            processingInstructions.loadByExperimentID(this.experiment.getId());
            ArrayList<ProcessingInstructionDTO> instructionList = new ArrayList<ProcessingInstructionDTO>();
            for (ProcessingInstructionDTO instruction : processingInstructions) {
                instructionList.add(instruction);
            }
            this.experiment.setProcessingInstructions(instructionList.toArray(new ProcessingInstructionDTO[0]));
        }
    }

    @Override
    public void enrichWithAttachments() {
        assert (this.experiment != null) : "Undefined experiment.";
        Long id = this.experiment.getId();
        assert (id != null) : "Experiment '" + this.experiment.getCode() + "' has no ID.";
        List<FilePropertyDTO> list = this.fetchExperimentAttachments(id);
        this.experiment.setFileProperties(list.toArray(new FilePropertyDTO[list.size()]));
    }

    private List<FilePropertyDTO> fetchExperimentAttachments(long experimentId) {
        List<FilePropertyDTO> list = this.getExperimentAttachmentDAO().listExperimentAttachments(experimentId);
        Iterator<FilePropertyDTO> iter = list.iterator();
        while (iter.hasNext()) {
            FilePropertyDTO property = iter.next();
            boolean isHiddenFile = this.isHiddenFile(property.getFileName());
            if (isHiddenFile) {
                iter.remove();
            }
            this.unescapeFileName(property);
        }
        return list;
    }

    private boolean isHiddenFile(String fileName) {
        return fileName.startsWith(HIDDEN_EXPERIMENT_PROPERTY_PREFIX) && (fileName.length() == 1 || fileName.charAt(1) != '$');
    }

    @Override
    public ExperimentFileAttachmentDTO getExperimentFileAttachment(String fileName, int version) {
        ExperimentFileAttachmentDTO propertyDTO;
        String escapedFileName = this.escapeFileName(fileName);
        IExperimentAttachmentDAO propertyDAO = this.getExperimentAttachmentDAO();
        Long id = this.experiment.getId();
        if (version == 0) {
            propertyDTO = propertyDAO.tryFindExpAttachmentByExpIdAndFileName(id, escapedFileName);
            if (propertyDTO == null) {
                throw UserFailureException.fromTemplate("The experiment attachment '%s' does not exist for the experiment '%s'.", fileName, this.createExperimentIdentifier());
            }
        } else {
            propertyDTO = propertyDAO.tryFindExpAttachmentByExpIdAndFileNameAndVersion(id, escapedFileName, version);
            if (propertyDTO == null) {
                throw UserFailureException.fromTemplate("The experiment attachment '%s', v%d does not exist for the experiment '%s'.", fileName, version, this.createExperimentIdentifier());
            }
        }
        this.unescapeFileName(propertyDTO.getFileProperty());
        return propertyDTO;
    }

    @Override
    public void addAttachment(ExperimentFileAttachment experimentFileProperty) {
        ExperimentFileAttachmentDTO propertyDTO = new ExperimentFileAttachmentDTO(this.findRegistratorID());
        BeanUtils.Converter converter = BeanUtilsConverters.getFilePropertyByteConverter();
        BeanUtils.fillBean(ExperimentFileAttachmentDTO.class, propertyDTO, experimentFileProperty, converter);
        this.escapeFileName(propertyDTO.getFileProperty());
        this.attachments.add(propertyDTO);
    }

    private void escapeFileName(FilePropertyDTO fileProperty) {
        if (fileProperty != null) {
            fileProperty.setFileName(this.escapeFileName(fileProperty.getFileName()));
        }
    }

    private String escapeFileName(String fileName) {
        if (fileName != null && fileName.startsWith(HIDDEN_EXPERIMENT_PROPERTY_PREFIX)) {
            return String.valueOf(HIDDEN_EXPERIMENT_PROPERTY_PREFIX) + fileName;
        }
        return fileName;
    }

    private void unescapeFileName(FilePropertyDTO fileProperty) {
        String fileName;
        if (fileProperty != null && (fileName = fileProperty.getFileName()) != null && fileName.startsWith(HIDDEN_EXPERIMENT_PROPERTY_PREFIX2)) {
            fileProperty.setFileName(fileName.substring(1));
        }
    }

    @Override
    public void save() {
        if (this.dataChanged) {
            try {
                this.getExperimentDAO().createExperiment(this.experiment);
                this.getEntityPropertyTypeDAO(EntityKind.EXPERIMENT).createProperties(this.experiment);
            }
            catch (DataAccessException ex) {
                String projectCode = this.experiment.getProject().getCode();
                ExperimentIdentifier identifier = new ExperimentIdentifier(projectCode, this.experiment.getCode());
                ExperimentBO.throwException(ex, String.format("Experiment '%s'", identifier));
            }
            this.dataChanged = false;
        }
        if (!this.attachments.isEmpty()) {
            IExperimentAttachmentDAO experimentPropertyDAO = this.getExperimentAttachmentDAO();
            for (ExperimentFileAttachmentDTO property : this.attachments) {
                try {
                    long experimentID = this.experiment.getId();
                    experimentPropertyDAO.createExperimentAttachment(experimentID, property);
                }
                catch (DataAccessException e) {
                    String fileName = property.getFileProperty().getFileName();
                    ExperimentBO.throwException(e, String.format("Filename '%s' for experiment '%s'", fileName, this.createExperimentIdentifier()));
                }
            }
            this.attachments.clear();
        }
    }

    @Override
    public final void enrichWithMaterialProperties() {
        assert (this.experiment != null) : "Undefined experiment.";
        Long materialId = this.experiment.getStudyObjectID();
        if (materialId != null) {
            this.experiment.getStudyObject().setProperties(this.getMaterialDAO().listEntityProperties(materialId).toArray(EntityPropertyValueDTO.EMPTY_ARRAY));
        }
    }

    @Override
    public void invalidateExperiment(String invalidationReasonOrNull) {
        assert (this.experiment != null) : "Undefined experiment.";
        InvalidationDTO invalidation = new InvalidationDTO(this.findRegistratorID());
        invalidation.setReason(invalidationReasonOrNull);
        this.getInvalidationDAO().createInvalidation(invalidation);
        boolean result = this.getExperimentDAO().invalidateExperiment(this.experiment.getId(), invalidation.getId());
        if (!result) {
            throw new UserFailureException("Experiment '" + this.experiment.getCode() + "' is already invalid.");
        }
    }

    @Override
    public void enrichWithInvalidation() {
        if (this.experiment != null && this.experiment.getId() != null) {
            Set<ExperimentDTO> invalidationHolders = Collections.singleton(this.experiment);
            InvalidationFiller.fillInvalidationFor(invalidationHolders, this.getInvalidationDAO());
        }
    }

    @Override
    public final void enrichWithProperties() {
        if (this.experiment != null) {
            EntityPropertyFiller.fillPropertyFor(this.experiment, (IEntityPropertyProviderDAO)this.getExperimentDAO());
        }
    }
}

