/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business.bo;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.lims.base.NewSample;
import ch.systemsx.cisd.lims.base.SampleTypeCode;
import ch.systemsx.cisd.lims.base.properties.SimpleEntityProperty;
import ch.systemsx.cisd.lims.server.business.IScreeningProcessStrategy;
import ch.systemsx.cisd.lims.server.business.ParameterChecker;
import ch.systemsx.cisd.lims.server.business.Session;
import ch.systemsx.cisd.lims.server.business.bo.BasicSampleBO;
import ch.systemsx.cisd.lims.server.business.bo.EntityPropertyFiller;
import ch.systemsx.cisd.lims.server.business.bo.IEntityPropertiesConverter;
import ch.systemsx.cisd.lims.server.business.bo.ISampleBO;
import ch.systemsx.cisd.lims.server.business.bo.SampleCriteriaWithId;
import ch.systemsx.cisd.lims.server.business.bo.SampleHierarchyFiller;
import ch.systemsx.cisd.lims.server.business.bo.SampleLayout;
import ch.systemsx.cisd.lims.server.business.bo.SampleLayoutCriterias;
import ch.systemsx.cisd.lims.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.lims.server.dataaccess.IEntityPropertyProviderDAO;
import ch.systemsx.cisd.lims.server.dataaccess.IExternalDataDAO;
import ch.systemsx.cisd.lims.server.dataaccess.ISampleComponentDAO;
import ch.systemsx.cisd.lims.server.dto.EntityPropertyValueDTO;
import ch.systemsx.cisd.lims.server.dto.ExternalDataDTO;
import ch.systemsx.cisd.lims.server.dto.SampleDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SampleBO
extends BasicSampleBO
implements ISampleBO {
    private final IScreeningProcessStrategy processStrategy;
    private final IEntityPropertiesConverter propertiesConverter;

    SampleBO(IDAOFactory daoFactory, IEntityPropertiesConverter entityPropertiesConverter, IScreeningProcessStrategy processStrategy, Session session) {
        super(daoFactory, session);
        this.propertiesConverter = entityPropertiesConverter;
        this.processStrategy = processStrategy;
    }

    private final Long figureTopSampleId(SampleDTO generatedFrom) {
        return generatedFrom.getTopID() == null ? generatedFrom.getId() : generatedFrom.getTopID();
    }

    private final SampleDTO findSampleByCode(String sampleCode) {
        ParameterChecker.checkIfNotNull(sampleCode, "sampleCode");
        SampleDTO foundSample = this.getSampleDAO().tryFindSampleByCode(sampleCode);
        if (foundSample == null) {
            throw UserFailureException.fromTemplate("No sample with code '%s' could be found in the database.", sampleCode);
        }
        return foundSample;
    }

    @Override
    public final void setSample(SampleDTO mySample) {
        this.sample = mySample;
    }

    @Override
    public final void loadInputSample(long procedureID, String sampleTypeCode) {
        List<SampleDTO> inputSamples = this.getSampleDAO().listSamplesAsInputs(procedureID, sampleTypeCode);
        int numberOfSamplesFound = 0;
        for (SampleDTO sampleDTO : inputSamples) {
            if (!sampleTypeCode.equals(sampleDTO.getSampleType().getCode())) continue;
            this.sample = sampleDTO;
            ++numberOfSamplesFound;
        }
        if (numberOfSamplesFound == 0) {
            throw new UserFailureException("No input sample of type '" + sampleTypeCode + "' for procedure with id " + procedureID + " found.");
        }
        if (numberOfSamplesFound > 1) {
            throw new UserFailureException(String.valueOf(numberOfSamplesFound) + " input samples of type '" + sampleTypeCode + "' for procedure with id " + procedureID + " found.");
        }
    }

    @Override
    public final void loadOrCreateSampleForDataSet(String sampleCode, long procedureID) {
        this.sample = this.processStrategy.getOrCreateCellPlateForDataSet(sampleCode, procedureID);
    }

    @Override
    public final void createSampleInputLinkForProcedure(long procedureID) {
        this.getSampleDAO().createSampleInput(this.getSample().getId(), procedureID);
    }

    @Override
    public final List<String> calculateComponentsLayoutConsistency() {
        SampleLayoutCriterias layoutCriterias = this.calculateComponentsLayoutCriterias(false);
        SampleLayout layout = this.calculateComponentsLayout(layoutCriterias.getAllCriterias());
        Set<String> overlapped = layout.getOverlappedComponents();
        this.sample.setInconsistent(overlapped.size() > 0);
        return SampleBO.asList(overlapped);
    }

    @Override
    public final SampleLayoutCriterias calculateComponentsLayoutCriterias() {
        return this.calculateComponentsLayoutCriterias(true);
    }

    private final SampleLayoutCriterias calculateComponentsLayoutCriterias(boolean sampleCodesRequired) {
        SampleDTO mySample = this.sample;
        List<SampleCriteriaWithId> controlLayout = this.getControlLayoutCriterias(mySample, sampleCodesRequired);
        SampleCriteriaWithId mainLayout = this.getMainComponentLayoutCriteria(mySample, sampleCodesRequired);
        return new SampleLayoutCriterias(controlLayout, mainLayout);
    }

    private final SampleLayout calculateComponentsLayout(List<SampleCriteriaWithId> layoutCriterias) {
        SampleLayout layout = new SampleLayout(null);
        for (SampleCriteriaWithId layoutCriteria : layoutCriterias) {
            List<String> components = this.getSampleComponents(layoutCriteria.getSampleId());
            layout.addComponents(components);
        }
        return layout;
    }

    private final SampleCriteriaWithId getMainComponentLayoutCriteria(SampleDTO mySample, boolean sampleCodesRequired) {
        if (mySample.getTopID() != null) {
            if (mySample.getTop() != null) {
                return new SampleCriteriaWithId(mySample.getTop());
            }
            assert (!sampleCodesRequired) : "definition of loaded sample is not complete - top sample definition is missing";
            return new SampleCriteriaWithId(mySample.getTopID(), null, null);
        }
        return new SampleCriteriaWithId(mySample);
    }

    private final List<String> getSampleComponents(Long sampleId) {
        ISampleComponentDAO sampleComponentDAO = this.getSampleComponentDAO();
        return sampleComponentDAO.listSampleComponentCodes(sampleId);
    }

    private static final List<String> asList(Collection<String> collection) {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(collection);
        return list;
    }

    private final List<SampleCriteriaWithId> getControlLayoutCriterias(SampleDTO mySample, boolean sampleCodesRequired) {
        SampleCriteriaWithId layoutCriteriaOrNull = this.tryGetControlLayoutCriteria(mySample, sampleCodesRequired);
        List<SampleCriteriaWithId> layoutCriterias = this.asList(layoutCriteriaOrNull);
        SampleDTO simpleParentSample = mySample.getGeneratedFrom();
        if (simpleParentSample != null) {
            String parentCode = simpleParentSample.getCode();
            SampleDTO parentSample = this.getSampleDAO().tryFindSampleByCode(parentCode);
            assert (parentSample != null) : "Internal error: parent sample " + parentCode + " does not exist";
            List<SampleCriteriaWithId> wholeLayout = this.getControlLayoutCriterias(parentSample, sampleCodesRequired);
            wholeLayout.addAll(layoutCriterias);
            return wholeLayout;
        }
        return layoutCriterias;
    }

    private final List<SampleCriteriaWithId> asList(SampleCriteriaWithId layoutCriteriaOrNull) {
        ArrayList<SampleCriteriaWithId> layoutCriterias = new ArrayList<SampleCriteriaWithId>();
        if (layoutCriteriaOrNull != null) {
            layoutCriterias.add(layoutCriteriaOrNull);
        }
        return layoutCriterias;
    }

    private final SampleCriteriaWithId tryGetControlLayoutCriteria(SampleDTO mySample, boolean sampleCodesRequired) {
        Long controlLayoutIdOrNull = mySample.getControlLayoutId();
        if (controlLayoutIdOrNull != null) {
            String controlLayoutCode = mySample.getControlLayoutCode();
            if (sampleCodesRequired) assert (controlLayoutCode != null) : "definition of loaded sample is not complete - control layout code is missing";
            return new SampleCriteriaWithId(controlLayoutIdOrNull, controlLayoutCode, SampleTypeCode.CONTROL_LAYOUT.getCode());
        }
        return null;
    }

    @Override
    public void define(String code, String sampleTypeCode, SampleDTO generatedFrom, Long topSampleId, Long controlLayoutIdOrNull, Long procedureIdOrNull, SimpleEntityProperty[] simpleProperties) {
        Long registratorID = this.findRegistratorID();
        this.sample = new SampleDTO(registratorID);
        this.sample.setCode(code);
        this.sample.setSampleType(this.getSampleType(sampleTypeCode));
        this.sample.setGeneratedFrom(generatedFrom);
        this.sample.setTopID(topSampleId);
        this.sample.setProcedureID(procedureIdOrNull);
        this.sample.setControlLayoutId(controlLayoutIdOrNull);
        this.defineSampleProperties(simpleProperties);
        this.dataChanged = true;
    }

    private void defineSampleProperties(SimpleEntityProperty[] simpleProperties) {
        String sampleTypeCode = this.sample.getSampleType().getCode();
        Long registratorID = this.sample.getRegistratorID();
        EntityPropertyValueDTO[] properties = this.propertiesConverter.convertProperties(simpleProperties, sampleTypeCode, registratorID);
        this.sample.setProperties(properties);
    }

    @Override
    public final void define(NewSample newSample) {
        String code = newSample.getSampleCriteria();
        String sampleTypeCode = newSample.getSampleTypeCode();
        ParameterChecker.checkIfNotNull(sampleTypeCode, "sample type");
        SampleDTO generatedFrom = null;
        Long topSampleId = null;
        if (newSample.getGeneratedFrom() != null) {
            generatedFrom = this.findSampleByCode(newSample.getGeneratedFrom());
            topSampleId = this.figureTopSampleId(generatedFrom);
        }
        Long controlLayoutIdOrNull = this.tryFigureControlLayoutId(newSample);
        this.define(code, sampleTypeCode, generatedFrom, topSampleId, controlLayoutIdOrNull, null, newSample.getProperties());
    }

    private final Long tryFigureControlLayoutId(NewSample newSample) {
        String controlLayoutCode = newSample.getControlLayoutCode();
        if (controlLayoutCode != null) {
            SampleDTO controlLayout = this.findSampleByCode(controlLayoutCode);
            if (!controlLayout.getSampleType().isControlLayout()) {
                throw UserFailureException.fromTemplate("Given code '%s' does not represent a '%s'.", controlLayoutCode, SampleTypeCode.CONTROL_LAYOUT);
            }
            return controlLayout.getId();
        }
        return null;
    }

    @Override
    public void enrichWithProperties() {
        if (this.sample != null) {
            EntityPropertyFiller.fillPropertyFor(this.sample, (IEntityPropertyProviderDAO)this.getSampleDAO());
        }
    }

    @Override
    public void checkSampleConsistency() throws UserFailureException {
        SampleBO.checkSampleSource(this.getSample());
        this.checkLayoutConsistency();
    }

    static final void checkSampleSource(SampleDTO sampleDTO) throws UserFailureException {
        String sampleTypeCode = sampleDTO.getSampleType().getCode();
        SampleDTO parentSample = sampleDTO.getGeneratedFrom();
        if (parentSample == null) {
            if (SampleTypeCode.getSampleTypeCode(sampleTypeCode).isParentRequired()) {
                throw SampleBO.createSourceSampleMissingException(sampleDTO);
            }
            return;
        }
        String parentTypeCode = parentSample.getSampleType().getCode();
        String wrongSourceTemplate = "The source sample with code '%s' registered in the database needs to be of type '%s', but is of type '%s'.";
        if (sampleTypeCode.equals(SampleTypeCode.DILUTION_PLATE.getCode()) && !parentTypeCode.equals(SampleTypeCode.MASTER_PLATE.getCode())) {
            throw UserFailureException.fromTemplate(wrongSourceTemplate, parentSample.getCode(), SampleTypeCode.MASTER_PLATE.getCode(), parentTypeCode);
        }
        if (sampleTypeCode.equals(SampleTypeCode.CELL_PLATE.getCode()) && !parentTypeCode.equals(SampleTypeCode.DILUTION_PLATE.getCode())) {
            throw UserFailureException.fromTemplate(wrongSourceTemplate, parentSample.getCode(), SampleTypeCode.DILUTION_PLATE.getCode(), parentTypeCode);
        }
        if (sampleTypeCode.equals(SampleTypeCode.REINFECT_PLATE.getCode()) && !parentTypeCode.equals(SampleTypeCode.CELL_PLATE.getCode())) {
            throw UserFailureException.fromTemplate(wrongSourceTemplate, parentSample.getCode(), SampleTypeCode.CELL_PLATE.getCode(), parentTypeCode);
        }
        if (sampleTypeCode.equals(SampleTypeCode.MASTER_PLATE.getCode()) || sampleTypeCode.equals(SampleTypeCode.CONTROL_LAYOUT.getCode())) {
            throw UserFailureException.fromTemplate("The sample with code '%s', which is of type '%s' is assigned to a source sample of a wrong type '%s'", sampleDTO.getCode(), sampleTypeCode, parentTypeCode);
        }
    }

    private static UserFailureException createSourceSampleMissingException(SampleDTO sampleDTO) {
        return UserFailureException.fromTemplate("The sample with code '%s' does not have information about its source sample, although it is required.", sampleDTO.getCode());
    }

    private final void checkLayoutConsistency() {
        List<String> inconsistentComponentCodes = this.calculateComponentsLayoutConsistency();
        if (inconsistentComponentCodes.size() > 0) {
            throw SampleBO.createInconsistentSampleException(this.getSample(), inconsistentComponentCodes);
        }
    }

    private static final UserFailureException createInconsistentSampleException(SampleDTO sample, List<String> inconsistentComponentCodes) {
        return UserFailureException.fromTemplate("Control plate layout for plate '%s' is inconsistent  with parent plates layout. Incompatible components codes are '%s'.", sample.getCode(), inconsistentComponentCodes);
    }

    @Override
    public boolean hasDatasets() {
        assert (this.sample != null);
        IExternalDataDAO externalDataDAO = this.getExternalDataDAO();
        Long sampleId = this.sample.getId();
        long count = 0L;
        IExternalDataDAO.SourceType[] sourceTypeArray = IExternalDataDAO.SourceType.values();
        int n = sourceTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExternalDataDAO.SourceType dataSourceType = sourceTypeArray[n2];
            List<ExternalDataDTO> list = externalDataDAO.listExternalData(sampleId, dataSourceType);
            count += (long)list.size();
            ++n2;
        }
        return count > 0L;
    }

    @Override
    public final void enrichWithFullHierarchy() {
        assert (this.sample != null) : "Sample not loaded.";
        SampleHierarchyFiller.enrichWithFullHierarchy(this.sample, this.getSampleDAO());
        this.enrichParentAndTopWithInvalidation(this.sample);
    }
}

