/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business.bo;

import ch.systemsx.cisd.common.collections.TableMap;
import ch.systemsx.cisd.lims.server.dataaccess.ISampleDAO;
import ch.systemsx.cisd.lims.server.dto.SampleDTO;
import ch.systemsx.cisd.lims.server.util.KeyExtractorFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SampleHierarchyFiller {
    public static final void enrichWithFullHierarchy(SampleDTO sample, ISampleDAO sampleDAO) {
        SampleFinder finder = SampleHierarchyFiller.createSampleFinder(sampleDAO);
        SampleHierarchyFiller.enrichWithFullHierarchy(sample, finder);
    }

    private static SampleFinder createSampleFinder(final ISampleDAO sampleDAO) {
        return new SampleFinder(){

            public SampleDTO getSample(long sampleId) {
                SampleDTO sample = sampleDAO.tryFindSampleById(sampleId);
                if (!$assertionsDisabled && sample == null) {
                    throw new AssertionError((Object)String.format("No sample found for id %d.", sampleId));
                }
                return sample;
            }
        };
    }

    public static final void enrichWithFullHierarchy(Iterable<SampleDTO> samplesToEnrich, ISampleDAO sampleDAO) {
        SampleFinder finder = SampleHierarchyFiller.createCachedSampleFinder(sampleDAO);
        for (SampleDTO sample : samplesToEnrich) {
            SampleHierarchyFiller.enrichWithFullHierarchy(sample, finder);
        }
    }

    private static void enrichWithFullHierarchy(SampleDTO sample, SampleFinder finder) {
        SampleHierarchyFiller.enrichParentHierarchy(sample, finder);
        SampleHierarchyFiller.enrichWithTop(sample, finder);
    }

    private static SampleFinder createCachedSampleFinder(ISampleDAO sampleDAO) {
        List<SampleDTO> allSamples = sampleDAO.listAllSamples();
        final TableMap<Long, SampleDTO> allSamplesDict = new TableMap<Long, SampleDTO>(allSamples, KeyExtractorFactory.getSampleByIdKeyExtractor());
        return new SampleFinder(){

            public SampleDTO getSample(long sampleId) {
                SampleDTO parent = (SampleDTO)allSamplesDict.tryGet(sampleId);
                if (!$assertionsDisabled && parent == null) {
                    throw new AssertionError((Object)String.format("No sample found for id %d.", sampleId));
                }
                return parent;
            }
        };
    }

    private static void enrichWithTop(SampleDTO sample, SampleFinder finder) {
        Long topID = sample.getTopID();
        if (topID != null) {
            sample.setTop(finder.getSample(topID));
        }
    }

    private static void enrichParentHierarchy(SampleDTO sample, SampleFinder finder) {
        if (sample.getGeneratedFromID() != null) {
            Long parentId = sample.getGeneratedFromID();
            SampleDTO parent = finder.getSample(parentId);
            sample.setGeneratedFrom(parent);
            SampleHierarchyFiller.enrichParentHierarchy(parent, finder);
        }
    }

    private static interface SampleFinder {
        public SampleDTO getSample(long var1);
    }
}

