/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.dataaccess.db;

import ch.systemsx.cisd.common.db.ISequenceNameMapper;
import ch.systemsx.cisd.common.db.ISequencerHandler;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.lims.server.dataaccess.db.AbstractDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.CodeConverter;
import ch.systemsx.cisd.lims.server.dataaccess.db.DtoValidatorStore;
import ch.systemsx.cisd.lims.server.dto.EntityTypeDTO;
import ch.systemsx.cisd.lims.server.dto.Id;
import java.util.List;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractTypeDAO<T extends EntityTypeDTO>
extends AbstractDAO {
    private final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, ((Object)((Object)this)).getClass());
    private final ISequenceNameMapper sequenceNameMapper;

    public AbstractTypeDAO(DataSource dataSource, DtoValidatorStore dtoValidatorStore, ISequencerHandler sequencerHandler, ISequenceNameMapper sequenceNameMapper) {
        super(dataSource, dtoValidatorStore, sequencerHandler);
        this.sequenceNameMapper = sequenceNameMapper;
    }

    public final List<T> listTypes() throws DataAccessException {
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        List list = template.query("select * from " + this.getTableName(), this.getRowMapper(), new Object[0]);
        if (this.operationLog.isDebugEnabled()) {
            this.operationLog.debug(String.valueOf(list.size()) + " item(s) have been found.");
        }
        return list;
    }

    private final long createID() {
        String sequencer = this.sequenceNameMapper.getSequencerForTable(this.getTableName());
        return this.getNextValueOf(sequencer);
    }

    public void createType(T entityType) throws DataIntegrityViolationException {
        long id = this.createID();
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        template.update("insert into " + this.getTableName() + " (id, code, description) values (?, ?, ?)", new Object[]{id, CodeConverter.tryToDatabase(((EntityTypeDTO)entityType).getCode()), ((EntityTypeDTO)entityType).getDescription()});
        ((Id)entityType).setId(id);
    }

    protected final T tryFindTypeByCode(String code) throws DataAccessException {
        assert (code != null);
        String mangledCode = CodeConverter.tryToDatabase(code);
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        List list = template.query("select * from " + this.getTableName() + " where code = ?", this.getRowMapper(), new Object[]{mangledCode});
        int size = list.size();
        switch (size) {
            case 0: {
                return null;
            }
            case 1: {
                return (T)((EntityTypeDTO)list.get(0));
            }
        }
        throw new IncorrectResultSizeDataAccessException("More than one entity for code '" + mangledCode + "' found: " + size, 1, size);
    }

    protected final long getTypeIdByCode(String code) throws DataAccessException {
        assert (code != null) : "Given code can not be null.";
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        try {
            return template.queryForLong("select id from " + this.getTableName() + " where code = ?", new Object[]{CodeConverter.tryToDatabase(code)});
        }
        catch (EmptyResultDataAccessException ex) {
            throw UserFailureException.fromTemplate(ex, "No type with code '%s' found in the database.", code);
        }
    }

    protected abstract String getTableName();

    protected abstract ParameterizedRowMapper<T> getRowMapper();
}

