/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.dataaccess.db;

import ch.systemsx.cisd.common.db.DBRestrictionParser;
import ch.systemsx.cisd.common.db.ISequenceNameMapper;
import ch.systemsx.cisd.common.db.ISequencerHandler;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.dbmigration.DBMigrationEngine;
import ch.systemsx.cisd.dbmigration.DatabaseConfigurationContext;
import ch.systemsx.cisd.dbmigration.ISqlScriptProvider;
import ch.systemsx.cisd.lims.base.ObservableTypeCode;
import ch.systemsx.cisd.lims.base.properties.EntityKind;
import ch.systemsx.cisd.lims.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.lims.server.dataaccess.IEntityPropertyTypeDAO;
import ch.systemsx.cisd.lims.server.dataaccess.IEntityTypeDAO;
import ch.systemsx.cisd.lims.server.dataaccess.IExperimentAttachmentDAO;
import ch.systemsx.cisd.lims.server.dataaccess.IExperimentDAO;
import ch.systemsx.cisd.lims.server.dataaccess.IExperimentTypeDAO;
import ch.systemsx.cisd.lims.server.dataaccess.IExternalDataDAO;
import ch.systemsx.cisd.lims.server.dataaccess.IFileFormatTypeDAO;
import ch.systemsx.cisd.lims.server.dataaccess.IGroupDAO;
import ch.systemsx.cisd.lims.server.dataaccess.IInvalidationDAO;
import ch.systemsx.cisd.lims.server.dataaccess.ILocatorTypeDAO;
import ch.systemsx.cisd.lims.server.dataaccess.IMaterialBatchDAO;
import ch.systemsx.cisd.lims.server.dataaccess.IMaterialDAO;
import ch.systemsx.cisd.lims.server.dataaccess.IObservableTypeDAO;
import ch.systemsx.cisd.lims.server.dataaccess.IPersonDAO;
import ch.systemsx.cisd.lims.server.dataaccess.IProcedureDAO;
import ch.systemsx.cisd.lims.server.dataaccess.IProcedureTypeDAO;
import ch.systemsx.cisd.lims.server.dataaccess.IProjectDAO;
import ch.systemsx.cisd.lims.server.dataaccess.IPropertyTypeDAO;
import ch.systemsx.cisd.lims.server.dataaccess.ISampleComponentDAO;
import ch.systemsx.cisd.lims.server.dataaccess.ISampleDAO;
import ch.systemsx.cisd.lims.server.dataaccess.ISampleTypeDAO;
import ch.systemsx.cisd.lims.server.dataaccess.IVocabularyDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.DBRestrictionChecker;
import ch.systemsx.cisd.lims.server.dataaccess.db.DtoValidatorStore;
import ch.systemsx.cisd.lims.server.dataaccess.db.EntityPropertyTypeDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.EntityTypeDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.ExperimentAttachmentDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.ExperimentDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.ExperimentTypeDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.ExternalDataDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.FileFormatTypeDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.GroupDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.InvalidationDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.LocatorTypeDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.MaterialBatchDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.MaterialDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.ObservableTypeDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.PersonDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.ProcedureDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.ProcedureTypeDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.ProjectDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.PropertyTypeDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.SampleComponentDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.SampleDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.SampleTypeDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.VocabularyDAO;
import ch.systemsx.cisd.lims.server.dto.GroupDTO;
import ch.systemsx.cisd.lims.server.dto.ObservableTypeDTO;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.support.lob.LobHandler;

public class DAOFactory
implements IDAOFactory {
    public static final String DATABASE_VERSION = "018";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DAOFactory.class);
    private static final String GROUP_CODE_UNDEFINED_ERROR = "Error: Group code undefined.";
    private final Map<EntityKind, IEntityTypeDAO> entityTypeDAOs = new HashMap<EntityKind, IEntityTypeDAO>();
    private final Map<EntityKind, IEntityPropertyTypeDAO> entityPropertyTypeDAOs = new HashMap<EntityKind, IEntityPropertyTypeDAO>();
    private final IExperimentDAO experimentDAO;
    private final IExperimentAttachmentDAO experimentAttachmentDAO;
    private final IExperimentTypeDAO experimentTypeDAO;
    private final IExternalDataDAO externalDataDAO;
    private final IFileFormatTypeDAO fileFormatTypeDAO;
    private final ILocatorTypeDAO locatorTypeDAO;
    private final IMaterialBatchDAO materialBatchDAO;
    private final IMaterialDAO materialDAO;
    private final IObservableTypeDAO observableTypeDAO;
    private final IGroupDAO groupDAO;
    private final IPersonDAO personDAO;
    private final IProcedureDAO procedureDAO;
    private final IProcedureTypeDAO procedureTypeDAO;
    private final IProjectDAO projectDAO;
    private final ISampleComponentDAO sampleComponentDAO;
    private final ISampleDAO sampleDAO;
    private final ISampleTypeDAO sampleTypeDAO;
    private final IPropertyTypeDAO propertyTypeDAO;
    private final IInvalidationDAO invalidationDAO;
    private final IVocabularyDAO vocabularyDAO;

    public DAOFactory(DatabaseConfigurationContext context) {
        EntityKind[] entityKinds;
        ISqlScriptProvider sqlScriptProvider = DBMigrationEngine.createOrMigrateDatabaseAndGetScriptProvider(context, DATABASE_VERSION);
        DataSource dataSource = context.getDataSource();
        ISequencerHandler sequencerHandler = context.getSequencerHandler();
        ISequenceNameMapper sequenceNameMapper = context.getSequenceNameMapper();
        LobHandler lobHandler = context.getLobHandler();
        DtoValidatorStore dtoValidatorStore = DAOFactory.createDTOValidatorStore(sqlScriptProvider);
        EntityKind[] entityKindArray = entityKinds = EntityKind.values();
        int n = entityKinds.length;
        int n2 = 0;
        while (n2 < n) {
            EntityKind entityKind = entityKindArray[n2];
            EntityTypeDAO dao = new EntityTypeDAO(entityKind, dataSource, dtoValidatorStore, sequenceNameMapper, sequencerHandler);
            this.entityTypeDAOs.put(entityKind, dao);
            this.entityPropertyTypeDAOs.put(entityKind, new EntityPropertyTypeDAO(entityKind, dataSource, dtoValidatorStore, sequencerHandler, sequenceNameMapper));
            ++n2;
        }
        this.experimentAttachmentDAO = new ExperimentAttachmentDAO(dataSource, lobHandler, dtoValidatorStore, sequencerHandler, sequenceNameMapper);
        this.experimentTypeDAO = new ExperimentTypeDAO(dataSource, dtoValidatorStore, sequencerHandler, sequenceNameMapper);
        this.personDAO = new PersonDAO(dataSource, dtoValidatorStore, sequencerHandler);
        this.materialDAO = new MaterialDAO(dataSource, dtoValidatorStore, sequencerHandler);
        this.experimentDAO = new ExperimentDAO(dataSource, dtoValidatorStore, sequencerHandler);
        this.materialBatchDAO = new MaterialBatchDAO(dataSource, dtoValidatorStore, sequencerHandler);
        this.sampleDAO = new SampleDAO(dataSource, dtoValidatorStore, sequencerHandler);
        this.sampleTypeDAO = new SampleTypeDAO(dataSource, dtoValidatorStore, sequencerHandler, sequenceNameMapper);
        this.fileFormatTypeDAO = new FileFormatTypeDAO(dataSource, dtoValidatorStore, sequencerHandler, sequenceNameMapper);
        this.observableTypeDAO = new ObservableTypeDAO(dataSource, dtoValidatorStore, sequencerHandler, sequenceNameMapper);
        ObservableTypeDTO unknownObservableType = DAOFactory.getUnknownObservableType(this.observableTypeDAO);
        this.procedureDAO = new ProcedureDAO(dataSource, dtoValidatorStore, sequencerHandler, sequenceNameMapper);
        this.procedureTypeDAO = new ProcedureTypeDAO(dataSource, dtoValidatorStore, sequencerHandler, sequenceNameMapper);
        this.externalDataDAO = new ExternalDataDAO(dataSource, dtoValidatorStore, sequencerHandler, sequenceNameMapper, unknownObservableType.getId());
        this.locatorTypeDAO = new LocatorTypeDAO(dataSource, dtoValidatorStore, sequencerHandler, sequenceNameMapper);
        this.sampleComponentDAO = new SampleComponentDAO(dataSource, dtoValidatorStore, sequencerHandler);
        this.projectDAO = new ProjectDAO(dataSource, dtoValidatorStore, sequencerHandler, sequenceNameMapper);
        this.groupDAO = new GroupDAO(dataSource, dtoValidatorStore, sequencerHandler);
        this.createGroup(context.getGroupCode());
        this.propertyTypeDAO = new PropertyTypeDAO(dataSource, dtoValidatorStore, sequencerHandler, sequenceNameMapper);
        this.invalidationDAO = new InvalidationDAO(dataSource, dtoValidatorStore, sequencerHandler);
        this.vocabularyDAO = new VocabularyDAO(dataSource, dtoValidatorStore, sequencerHandler);
        if (operationLog.isInfoEnabled()) {
            operationLog.info("DAO Factory for database '" + context.getDatabaseName() + "' version " + DATABASE_VERSION + " successfully created.");
        }
    }

    private void createGroup(String groupCode) {
        assert (groupCode != null) : "Error: Group code undefined.";
        GroupDTO groupDTO = new GroupDTO();
        groupDTO.setCode(groupCode);
        try {
            long groupId = this.groupDAO.getGroupIdByCode(groupCode);
            groupDTO = this.groupDAO.getGroupById(groupId);
        }
        catch (DataAccessException dataAccessException) {
            this.groupDAO.createGroup(groupDTO);
        }
    }

    private static final ObservableTypeDTO getUnknownObservableType(IObservableTypeDAO observableTypeDAO) {
        String codeUnknown = ObservableTypeCode.UNKNOWN.getCode();
        ObservableTypeDTO unknownObservableType = observableTypeDAO.tryFindObservableTypeByCode(codeUnknown);
        assert (unknownObservableType != null) : "Error in database: no entry for '" + codeUnknown + "' in table '" + "observable_types" + "'";
        return unknownObservableType;
    }

    private static final DtoValidatorStore createDTOValidatorStore(ISqlScriptProvider sqlScriptProvider) {
        assert (sqlScriptProvider != null) : "Given SQL script provider can not be null";
        String ddlScript = sqlScriptProvider.tryGetSchemaScript(DATABASE_VERSION).getCode();
        DBRestrictionParser restrictionParser = new DBRestrictionParser(ddlScript);
        return new DtoValidatorStore(new DBRestrictionChecker(restrictionParser.getDBRestrictions()));
    }

    public IEntityTypeDAO getEntityTypeDAO(EntityKind entityKind) {
        return this.entityTypeDAOs.get((Object)entityKind);
    }

    public IExperimentDAO getExperimentDAO() {
        return this.experimentDAO;
    }

    public final IExperimentAttachmentDAO getExperimentAttachmentDAO() {
        return this.experimentAttachmentDAO;
    }

    public final IExternalDataDAO getExternalDataDAO() {
        return this.externalDataDAO;
    }

    public final IFileFormatTypeDAO getFileFormatTypeDAO() {
        return this.fileFormatTypeDAO;
    }

    public final ILocatorTypeDAO getLocatorTypeDAO() {
        return this.locatorTypeDAO;
    }

    public final IMaterialBatchDAO getMaterialBatchDAO() {
        return this.materialBatchDAO;
    }

    public final IMaterialDAO getMaterialDAO() {
        return this.materialDAO;
    }

    public final IObservableTypeDAO getObservableTypeDAO() {
        return this.observableTypeDAO;
    }

    public final IGroupDAO getGroupDAO() {
        return this.groupDAO;
    }

    public final IPersonDAO getPersonDAO() {
        return this.personDAO;
    }

    public final IProcedureDAO getProcedureDAO() {
        return this.procedureDAO;
    }

    public final IProcedureTypeDAO getProcedureTypeDAO() {
        return this.procedureTypeDAO;
    }

    public final IProjectDAO getProjectDAO() {
        return this.projectDAO;
    }

    public final ISampleComponentDAO getSampleComponentDAO() {
        return this.sampleComponentDAO;
    }

    public final ISampleDAO getSampleDAO() {
        return this.sampleDAO;
    }

    public final ISampleTypeDAO getSampleTypeDAO() {
        return this.sampleTypeDAO;
    }

    public IExperimentTypeDAO getExperimentTypeDAO() {
        return this.experimentTypeDAO;
    }

    public final IEntityPropertyTypeDAO getEntityPropertyTypeDAO(EntityKind entityKind) {
        return this.entityPropertyTypeDAOs.get((Object)entityKind);
    }

    public final IPropertyTypeDAO getPropertyTypeDAO() {
        return this.propertyTypeDAO;
    }

    public final IInvalidationDAO getInvalidationDAO() {
        return this.invalidationDAO;
    }

    public final IVocabularyDAO getVocabularyDAO() {
        return this.vocabularyDAO;
    }
}

