/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.dataaccess.db;

import ch.systemsx.cisd.common.db.ISequenceNameMapper;
import ch.systemsx.cisd.common.db.ISequencerHandler;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.lims.server.dataaccess.IExperimentTypeDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.AbstractTypeDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.CodeConverter;
import ch.systemsx.cisd.lims.server.dataaccess.db.DtoValidatorStore;
import ch.systemsx.cisd.lims.server.dto.ExperimentTypeDTO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ExperimentTypeDAO
extends AbstractTypeDAO<ExperimentTypeDTO>
implements IExperimentTypeDAO {
    private static final String EXPERIMENT_TYPE_ID_SEQUENCE = "EXPERIMENT_TYPE_ID_SEQ";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, ExperimentTypeDAO.class);
    private static final ParameterizedRowMapper<ExperimentTypeDTO> EXPERIMENT_TYPE_ROW_MAPPER = new ParameterizedRowMapper<ExperimentTypeDTO>(){

        public ExperimentTypeDTO mapRow(ResultSet rs, int rowNum) throws SQLException {
            ExperimentTypeDTO result = new ExperimentTypeDTO();
            result.setId(rs.getLong("id"));
            result.setCode(CodeConverter.tryToBusinessLayer(rs.getString("code")));
            result.setDescription(rs.getString("description"));
            return result;
        }
    };

    public ExperimentTypeDAO(DataSource dataSource, DtoValidatorStore dtoValidatorStore, ISequencerHandler sequencerHandler, ISequenceNameMapper sequenceNameMapper) {
        super(dataSource, dtoValidatorStore, sequencerHandler, sequenceNameMapper);
    }

    private final long createID() {
        return this.getNextValueOf(EXPERIMENT_TYPE_ID_SEQUENCE);
    }

    @Override
    protected final ParameterizedRowMapper<ExperimentTypeDTO> getRowMapper() {
        return EXPERIMENT_TYPE_ROW_MAPPER;
    }

    @Override
    protected final String getTableName() {
        return "experiment_types";
    }

    @Override
    public final long getExperimentTypeIdByCode(String code) throws DataAccessException {
        return this.getTypeIdByCode(code);
    }

    @Override
    public final ExperimentTypeDTO tryFindExperimentTypeByCode(String code) throws DataAccessException {
        return (ExperimentTypeDTO)this.tryFindTypeByCode(code);
    }

    @Override
    public String getExperimentTypeCodeForExperiment(long experimentId) throws DataAccessException {
        return (String)this.getSimpleJdbcTemplate().queryForObject("select exty.code from experiment_types exty, experiments e where exty.id = e.exty_id and e.id = ?", String.class, new Object[]{experimentId});
    }

    @Override
    public final List<ExperimentTypeDTO> listExperimentTypes() throws DataAccessException {
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        List list = template.query("select * from experiment_types", EXPERIMENT_TYPE_ROW_MAPPER, new Object[0]);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug("listExperimentTypes(): " + list.size() + " type(s) have been found.");
        }
        return list;
    }

    @Override
    public void createExperimentType(ExperimentTypeDTO experimentType) throws DataAccessException {
        long id = this.createID();
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        template.update("insert into experiment_types (id, code, description) values (?, ?, ?)", new Object[]{id, CodeConverter.tryToDatabase(experimentType.getCode()), experimentType.getDescription()});
        experimentType.setId(id);
    }
}

