/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.dataaccess.db;

import ch.systemsx.cisd.common.db.ISequencerHandler;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.lims.server.dataaccess.IPersonDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.AbstractDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.DtoValidatorStore;
import ch.systemsx.cisd.lims.server.dto.PersonDTO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PersonDAO
extends AbstractDAO
implements IPersonDAO {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, PersonDAO.class);
    protected static final String PERSON_FIELDS = " p.id as pid, p.user_id, p.first_name, p.last_name, p.email ";

    PersonDAO(DataSource dataSource, DtoValidatorStore dtoValidatorStore, ISequencerHandler sequencerHandler) {
        super(dataSource, dtoValidatorStore, sequencerHandler);
    }

    static final PersonDTO fillPersonFromResultSet(ResultSet rs) throws SQLException {
        return PersonDAO.fillPersonFromResultSet(rs, "pid", "user_id", "first_name", "last_name", "email");
    }

    static final PersonDTO fillPersonFromResultSet(ResultSet rs, String pidCol, String userIDCol, String firstNameCol, String lastNameCol, String emailCol) throws SQLException {
        PersonDTO person = new PersonDTO();
        person.setId(rs.getLong(pidCol));
        person.setUserId(rs.getString(userIDCol));
        person.setFirstName(rs.getString(firstNameCol));
        person.setLastName(rs.getString(lastNameCol));
        person.setEmail(rs.getString(emailCol));
        return person;
    }

    private final long createID() {
        return this.getNextValueOf("PERSON_ID_SEQ");
    }

    @Override
    public final void createPerson(PersonDTO person) throws DataAccessException {
        assert (person != null) : "Given person can not be null.";
        person.setEmail(StringUtils.trim(person.getEmail()));
        this.validateDTO(person);
        long id = this.createID();
        String userId = person.getUserId();
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        template.update("insert into persons (id, user_id, first_name, last_name, email) values (?,?,?,?,?)", new Object[]{id, userId, person.getFirstName(), person.getLastName(), person.getEmail()});
        if (operationLog.isInfoEnabled()) {
            operationLog.info("ADD{" + userId + "}: person: [id: '" + id + "', user_id: '" + userId + "'].");
        }
        person.setId(id);
    }

    @Override
    public final PersonDTO getPerson(long id) throws DataAccessException {
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        List result = template.query("select  p.id as pid, p.user_id, p.first_name, p.last_name, p.email  from persons as p where id = ?", (ParameterizedRowMapper)new PersonRowMapper(), new Object[]{id});
        if (result.size() == 0) {
            if (operationLog.isDebugEnabled()) {
                operationLog.debug("getExperiment(" + id + "): NULL'.");
            }
            throw new EmptyResultDataAccessException("No experiment found with id " + id, 1);
        }
        int size = result.size();
        if (size > 1) {
            throw new IncorrectResultSizeDataAccessException("More than one experiment for id " + id + " found: " + size, 1, size);
        }
        PersonDTO person = (PersonDTO)result.get(0);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug("getPerson(" + id + "): '" + person.getUserId() + "'.");
        }
        return person;
    }

    @Override
    public final Long tryFindPersonIdByUserID(String userID) throws DataAccessException {
        return this.tryFindId("select id from persons where user_id = ?", userID);
    }

    @Override
    public final List<PersonDTO> listPersons() throws DataAccessException {
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        List list = template.query("select id as pid,user_id,first_name,last_name,email from persons", (ParameterizedRowMapper)new PersonRowMapper(), new Object[0]);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug("listPersons(): " + list.size() + " person(s) have been found.");
        }
        return list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PersonRowMapper
    implements ParameterizedRowMapper<PersonDTO> {
        private PersonRowMapper() {
        }

        public final PersonDTO mapRow(ResultSet rs, int rowNum) throws SQLException {
            PersonDTO person = PersonDAO.fillPersonFromResultSet(rs);
            return person;
        }
    }
}

