/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.dataaccess.db;

import ch.systemsx.cisd.common.db.ISequenceNameMapper;
import ch.systemsx.cisd.common.db.ISequencerHandler;
import ch.systemsx.cisd.lims.server.dataaccess.ISampleTypeDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.AbstractTypeDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.CodeConverter;
import ch.systemsx.cisd.lims.server.dataaccess.db.DtoValidatorStore;
import ch.systemsx.cisd.lims.server.dto.SampleTypeDTO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SampleTypeDAO
extends AbstractTypeDAO<SampleTypeDTO>
implements ISampleTypeDAO {
    private static final String SAMPLE_TYPE_ID_SEQUENCE = "SAMPLE_TYPE_ID_SEQ";
    private static final ParameterizedRowMapper<SampleTypeDTO> SAMPLE_TYPE_ROW_MAPPER = new ParameterizedRowMapper<SampleTypeDTO>(){

        public SampleTypeDTO mapRow(ResultSet rs, int rowNum) throws SQLException {
            SampleTypeDTO result = new SampleTypeDTO();
            result.setId(rs.getLong("id"));
            result.setCode(CodeConverter.tryToBusinessLayer(rs.getString("code")));
            result.setDescription(rs.getString("description"));
            return result;
        }
    };

    SampleTypeDAO(DataSource dataSource, DtoValidatorStore dtoValidatorStore, ISequencerHandler sequencerHandler, ISequenceNameMapper sequenceNameMapper) {
        super(dataSource, dtoValidatorStore, sequencerHandler, sequenceNameMapper);
    }

    private final long createID() {
        return this.getNextValueOf(SAMPLE_TYPE_ID_SEQUENCE);
    }

    @Override
    public final List<SampleTypeDTO> listSampleTypes() throws DataAccessException {
        return this.listTypes();
    }

    @Override
    public final SampleTypeDTO tryFindSampleTypeByCode(String code) throws DataAccessException {
        return (SampleTypeDTO)this.tryFindTypeByCode(code);
    }

    @Override
    protected final ParameterizedRowMapper<SampleTypeDTO> getRowMapper() {
        return SAMPLE_TYPE_ROW_MAPPER;
    }

    @Override
    protected final String getTableName() {
        return "sample_types";
    }

    @Override
    public void createSampleType(SampleTypeDTO sampleType) throws DataAccessException {
        long id = this.createID();
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        template.update("insert into sample_types (id, code, description) values (?, ?, ?)", new Object[]{id, CodeConverter.tryToDatabase(sampleType.getCode()), sampleType.getDescription()});
        sampleType.setId(id);
    }
}

