/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.dto;

import ch.systemsx.cisd.lims.server.dto.AbstractEntity;
import ch.systemsx.cisd.lims.server.dto.EntityTypeDTO;
import ch.systemsx.cisd.lims.server.dto.ExternalDataDTO;
import ch.systemsx.cisd.lims.server.dto.IInvalidationHolder;
import ch.systemsx.cisd.lims.server.dto.IProcedureHolder;
import ch.systemsx.cisd.lims.server.dto.InvalidationDTO;
import ch.systemsx.cisd.lims.server.dto.ProcedureDTO;
import ch.systemsx.cisd.lims.server.dto.SampleTypeDTO;
import java.util.Date;

public final class SampleDTO
extends AbstractEntity
implements IInvalidationHolder,
IProcedureHolder {
    public static final SampleDTO[] EMPTY_ARRAY = new SampleDTO[0];
    private SampleTypeDTO sampleType;
    private Long controlLayoutIdOrNull;
    private String controlLayoutCodeOrNull;
    private Long topIdOrNull;
    private SampleDTO topOrNull;
    private Long generatedFromIdOrNull;
    private SampleDTO generatedFromOrNull;
    private Date registrationDate;
    private InvalidationDTO invalidationOrNull;
    private Long invalidationIdOrNull;
    private Boolean inconsistentOrNull;
    private Long procedureID;
    private ProcedureDTO procedure;
    private ExternalDataDTO[] measurementData = ExternalDataDTO.EMPTY_ARRAY;
    private ExternalDataDTO[] derivedData = ExternalDataDTO.EMPTY_ARRAY;

    public SampleDTO(Long registratorID) {
        super(registratorID);
    }

    public final Long getProcedureID() {
        return this.procedureID;
    }

    public final void setProcedureID(Long procedureID) {
        assert (this.procedure == null) : "Procedure already set.";
        this.procedureID = procedureID;
    }

    public final ProcedureDTO getProcedure() {
        return this.procedure;
    }

    public final void setProcedure(ProcedureDTO procedure) {
        this.procedureID = SampleDTO.getAndCheckID(procedure, this.procedureID);
        this.procedure = procedure;
    }

    public EntityTypeDTO getEntityType() {
        return this.getSampleType();
    }

    public final SampleTypeDTO getSampleType() {
        return this.sampleType;
    }

    public final void setSampleType(SampleTypeDTO sampleType) {
        this.sampleType = sampleType;
    }

    public final ExternalDataDTO[] getMeasurementData() {
        return this.measurementData;
    }

    public final void setMeasurementData(ExternalDataDTO[] externalData) {
        this.measurementData = externalData;
    }

    public final ExternalDataDTO[] getDerivedData() {
        return this.derivedData;
    }

    public final void setDerivedData(ExternalDataDTO[] derivedData) {
        this.derivedData = derivedData;
    }

    public final Long getGeneratedFromID() {
        return this.generatedFromIdOrNull;
    }

    public final void setGeneratedFromID(Long generatedFromID) {
        assert (this.generatedFromOrNull == null) : "generatedFrom already set.";
        this.generatedFromIdOrNull = generatedFromID;
    }

    public final SampleDTO getGeneratedFrom() {
        return this.generatedFromOrNull;
    }

    public final void setGeneratedFrom(SampleDTO generatedFrom) {
        this.generatedFromIdOrNull = SampleDTO.getAndCheckID(generatedFrom, this.generatedFromIdOrNull);
        this.generatedFromOrNull = generatedFrom;
    }

    public final Long getTopID() {
        return this.topIdOrNull;
    }

    public final void setTopID(Long topID) {
        assert (this.topOrNull == null) : "Top is already set.";
        this.topIdOrNull = topID;
    }

    public final SampleDTO getTop() {
        return this.topOrNull;
    }

    public final void setTop(SampleDTO top) {
        this.topIdOrNull = SampleDTO.getAndCheckID(top, this.topIdOrNull);
        this.topOrNull = top;
    }

    public final Boolean getInconsistent() {
        return this.inconsistentOrNull;
    }

    public final void setInconsistent(Boolean inconsistent) {
        this.inconsistentOrNull = inconsistent;
    }

    public final Date getRegistrationDate() {
        return this.registrationDate;
    }

    public final void setRegistrationDate(Date registrationDate) {
        this.registrationDate = registrationDate;
    }

    public final void setInvalidationId(Long invalidationId) {
        this.invalidationIdOrNull = invalidationId;
    }

    public final Long getControlLayoutId() {
        return this.controlLayoutIdOrNull;
    }

    public final String getControlLayoutCode() {
        return this.controlLayoutCodeOrNull;
    }

    public final void setControlLayout(Long controlLayoutIdOrNull, String controlLayoutCodeOrNull) {
        assert (controlLayoutCodeOrNull != null && controlLayoutIdOrNull != null || controlLayoutCodeOrNull == null && controlLayoutIdOrNull == null);
        this.controlLayoutIdOrNull = controlLayoutIdOrNull;
        this.controlLayoutCodeOrNull = controlLayoutCodeOrNull;
    }

    public final void setControlLayoutId(Long controlLayoutIdOrNull) {
        this.controlLayoutIdOrNull = controlLayoutIdOrNull;
    }

    public final InvalidationDTO getInvalidation() {
        return this.invalidationOrNull;
    }

    public final void setInvalidation(InvalidationDTO invalidation) {
        SampleDTO.getAndCheckID(invalidation, this.invalidationIdOrNull);
        this.invalidationOrNull = invalidation;
    }

    public final Long getInvalidationId() {
        return this.invalidationIdOrNull;
    }
}

