/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.workflow.imsb;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.lims.base.ExperimentIdentifier;
import ch.systemsx.cisd.lims.base.SampleTypeCode;
import ch.systemsx.cisd.lims.base.properties.SimpleEntityProperty;
import ch.systemsx.cisd.lims.server.business.AbstractScreeningProcessStrategy;
import ch.systemsx.cisd.lims.server.business.ParameterChecker;
import ch.systemsx.cisd.lims.server.business.Session;
import ch.systemsx.cisd.lims.server.business.bo.IBasicSampleBO;
import ch.systemsx.cisd.lims.server.business.bo.IBusinessObjectFactory;
import ch.systemsx.cisd.lims.server.business.bo.IExperimentBO;
import ch.systemsx.cisd.lims.server.business.bo.ISampleBO;
import ch.systemsx.cisd.lims.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.lims.server.dataaccess.ISampleDAO;
import ch.systemsx.cisd.lims.server.dto.ExperimentDTO;
import ch.systemsx.cisd.lims.server.dto.ProcedureDTO;
import ch.systemsx.cisd.lims.server.dto.SampleDTO;
import ch.systemsx.cisd.lims.server.workflow.imsb.BarcodeGenerator;
import ch.systemsx.cisd.lims.server.workflow.imsb.IPlateBarcodeGenerator;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.dao.DataIntegrityViolationException;

final class ScreeningProcessStrategy
extends AbstractScreeningProcessStrategy {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, ScreeningProcessStrategy.class);
    private final IPlateBarcodeGenerator barcodeGenerator;

    ScreeningProcessStrategy(IDAOFactory daoFactory, IBusinessObjectFactory boFactory, Session session) {
        this(BarcodeGenerator.getInstance(), daoFactory, boFactory, session);
    }

    ScreeningProcessStrategy(IPlateBarcodeGenerator barcodeGenerator, IDAOFactory daoFactory, IBusinessObjectFactory boFactory, Session session) {
        super(daoFactory, boFactory, session);
        this.barcodeGenerator = barcodeGenerator;
    }

    private final SampleDTO createCellPlate(String sampleCode, long procedureId, SampleDTO masterPlate, SampleDTO dilutionPlate) {
        ScreeningProcessStrategy.checkGeneratorPlateValid(sampleCode, masterPlate);
        ScreeningProcessStrategy.checkGeneratorPlateValid(sampleCode, dilutionPlate);
        long controlLayoutId = this.getControlLayout(procedureId).getId();
        return this.createSampleDTO(sampleCode, SampleTypeCode.CELL_PLATE, dilutionPlate, masterPlate, controlLayoutId, procedureId);
    }

    private SampleDTO getControlLayout(long procedureID) {
        ISampleBO inputSampleBO = this.boFactory.createSampleBO(this.session);
        inputSampleBO.loadInputSample(procedureID, SampleTypeCode.CONTROL_LAYOUT.getCode());
        return inputSampleBO.getSample();
    }

    private final SampleDTO createDilutionPlate(String sampleCode, SampleDTO masterPlate) {
        ScreeningProcessStrategy.checkGeneratorPlateValid(sampleCode, masterPlate);
        return this.createSampleDTO(sampleCode, SampleTypeCode.DILUTION_PLATE, masterPlate, masterPlate, null, null);
    }

    private final SampleDTO createSampleDTO(String sampleCode, SampleTypeCode sampleTypeCode, SampleDTO generatedFromPlate, SampleDTO topPlate, Long controlLayoutIdOrNull, Long procedureId) {
        ISampleBO sampleBO = this.boFactory.createSampleBO(this.session);
        SimpleEntityProperty[] emptyProperties = new SimpleEntityProperty[]{};
        sampleBO.define(sampleCode, sampleTypeCode.getCode(), generatedFromPlate, topPlate.getId(), controlLayoutIdOrNull, procedureId, emptyProperties);
        sampleBO.save();
        return sampleBO.getSample();
    }

    private final SampleDTO getOrCreateDilutionPlateForDataSet(String sampleCode, SampleDTO masterPlate) throws DataIntegrityViolationException {
        String dilutionPlateBarcode = this.barcodeGenerator.getDilutionPlateBarcode(sampleCode);
        SampleDTO dilutionPlate = this.daoFactory.getSampleDAO().tryFindSampleByCode(dilutionPlateBarcode);
        if (dilutionPlate == null) {
            dilutionPlate = this.createDilutionPlate(dilutionPlateBarcode, masterPlate);
        }
        if (!SampleTypeCode.DILUTION_PLATE.getCode().equals(dilutionPlate.getSampleType().getCode())) {
            String message = String.format("Registration of data set failed. Dilution plate '%s' is of wrong type '%s'.", dilutionPlateBarcode, dilutionPlate.getSampleType());
            operationLog.error(message);
            throw new DataIntegrityViolationException(message);
        }
        if (!masterPlate.getId().equals(dilutionPlate.getTopID())) {
            String message = String.format("Registration of data set failed. Dilution plate '%s' is derived from wrong master plate '%s'.", dilutionPlateBarcode, dilutionPlate.getTopID());
            operationLog.error(message);
            throw new DataIntegrityViolationException(message);
        }
        return dilutionPlate;
    }

    private final SampleDTO getMasterPlateForDataSet(String sampleCode) throws DataIntegrityViolationException {
        String masterPlateBarcode = this.barcodeGenerator.getMasterPlateBarcode(sampleCode);
        SampleDTO masterPlate = this.daoFactory.getSampleDAO().tryFindSampleByCode(masterPlateBarcode);
        if (masterPlate == null) {
            String message = String.format("Registration of data set failed. Master plate '%s' for cell plate '%s' is not registered in the database.", masterPlateBarcode, sampleCode);
            operationLog.error(message);
            throw new UserFailureException(message);
        }
        if (!SampleTypeCode.MASTER_PLATE.getCode().equals(masterPlate.getSampleType().getCode())) {
            String message = String.format("Registration of data set failed. Master plate '%s' is of wrong type '%s'.", masterPlateBarcode, masterPlate.getSampleType());
            operationLog.error(message);
            throw new DataIntegrityViolationException(message);
        }
        return masterPlate;
    }

    private final void createSampleInputLinkForProcedure(String controlLayoutCode, Long procedureId) {
        ISampleDAO sampleDAO = this.daoFactory.getSampleDAO();
        Long sampleId = sampleDAO.tryFindSampleIdByCode(controlLayoutCode);
        if (sampleId == null) {
            throw new UserFailureException("Control layout for code '" + controlLayoutCode + "' hasn't been registered.");
        }
        sampleDAO.createSampleInput(sampleId, procedureId);
    }

    private static void checkGeneratorPlateValid(String sampleCode, SampleDTO plate) {
        if (plate.getInvalidation() != null) {
            String plateType = plate.getSampleType().getDescription();
            throw UserFailureException.fromTemplate("Cannot register plate '%s': %s '%s' is invalid.", sampleCode, plateType, plate.getCode());
        }
    }

    private final SampleDTO tryGetSample(String sampleCode) {
        IBasicSampleBO sampleBO = this.boFactory.createBasicSampleBO(this.session);
        if (sampleBO.containsSampleCode(sampleCode)) {
            sampleBO.loadBySampleCode(sampleCode);
            return sampleBO.getSample();
        }
        return null;
    }

    public final void registerPlatesOnExperimentRegistration(String[] cellPlates, String controlLayoutCodeOrNull, Long procedureId) {
        if (cellPlates.length > 0) {
            throw UserFailureException.fromTemplate("This workflow does not support cell plate registration on experiment registration.", new Object[0]);
        }
        if (controlLayoutCodeOrNull == null) {
            throw UserFailureException.fromTemplate("The control layout must be specified on experiment registration in this workflow!", new Object[0]);
        }
        this.createSampleInputLinkForProcedure(controlLayoutCodeOrNull, procedureId);
    }

    public SampleDTO tryToGetTopSampleRegisteredFor(String sampleCode) throws UserFailureException {
        String masterPlateCode = this.barcodeGenerator.getMasterPlateBarcode(sampleCode);
        if (masterPlateCode == null) {
            return null;
        }
        SampleDTO sample = this.daoFactory.getSampleDAO().tryFindSampleByCode(masterPlateCode);
        if (sample == null) {
            return null;
        }
        return this.enrichWithProperties(sample);
    }

    public final SampleDTO getOrCreateCellPlateForDataSet(String sampleCode, Long procedureID) throws DataIntegrityViolationException {
        assert (procedureID != null);
        assert (sampleCode != null);
        SampleDTO cellPlate = this.tryGetSample(sampleCode);
        if (cellPlate == null) {
            SampleDTO masterPlate = this.getMasterPlateForDataSet(sampleCode);
            SampleDTO dilutionPlate = this.getOrCreateDilutionPlateForDataSet(sampleCode, masterPlate);
            return this.createCellPlate(sampleCode, procedureID, masterPlate, dilutionPlate);
        }
        if (cellPlate.getInvalidation() != null) {
            throw UserFailureException.fromTemplate("Plate '%s' is invalid.", sampleCode);
        }
        return cellPlate;
    }

    public final ExperimentDTO getExperiment(ExperimentIdentifier experimentIdentifier, String sampleCode) throws UserFailureException {
        Long procedureID;
        assert (sampleCode != null) : "Unspecified sample code.";
        ParameterChecker.checkExperimentIdentifier(experimentIdentifier);
        IExperimentBO experimentBO = this.boFactory.createExperimentBO(this.session);
        experimentBO.loadByExperimentIdentifier(experimentIdentifier, false);
        ExperimentDTO experimentDTO = experimentBO.getExperiment();
        SampleDTO sample = this.tryGetSample(sampleCode);
        List<ProcedureDTO> procedures = this.daoFactory.getProcedureDAO().listProcedures(experimentDTO.getId());
        if (sample != null && sample.getProcedureID() != null && !ScreeningProcessStrategy.containsProcedure(procedures, procedureID = sample.getProcedureID())) {
            ExperimentDTO other = this.daoFactory.getExperimentDAO().getExperimentByProcedureId(procedureID);
            throw UserFailureException.fromTemplate("Given sample code '%s' already registered for experiment '%s'.", sampleCode, new ExperimentIdentifier(other.getProject().getCode(), other.getCode()));
        }
        return experimentDTO;
    }
}

