/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.webclient.client.application;

import ch.systemsx.cisd.lims.webclient.client.ILIMSService;
import ch.systemsx.cisd.lims.webclient.client.ILIMSServiceAsync;
import ch.systemsx.cisd.lims.webclient.client.application.AsyncCallbackAdapter;
import ch.systemsx.cisd.lims.webclient.client.application.EntityRequestListener;
import ch.systemsx.cisd.lims.webclient.client.application.IMessageResources;
import ch.systemsx.cisd.lims.webclient.client.application.PageController;
import ch.systemsx.cisd.lims.webclient.client.application.context.EntityRequestEventDispatcher;
import ch.systemsx.cisd.lims.webclient.client.application.context.IPageController;
import ch.systemsx.cisd.lims.webclient.client.application.context.ViewContext;
import ch.systemsx.cisd.lims.webclient.client.application.context.ViewModel;
import ch.systemsx.cisd.lims.webclient.client.dto.SessionContext;
import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.gwtext.client.widgets.QuickTips;
import com.gwtext.client.widgets.form.Field;

public final class Client
implements EntryPoint {
    private ViewContext viewContext;

    private static final ILIMSServiceAsync createLIMSService() {
        ILIMSServiceAsync service = (ILIMSServiceAsync)GWT.create(ILIMSService.class);
        ServiceDefTarget endpoint = (ServiceDefTarget)service;
        endpoint.setServiceEntryPoint("/openbis/openbis");
        return service;
    }

    private final void destroyContext() {
        this.viewContext.getEntityRequestEventDispatcher().removeAllEntityRequestListeners();
        this.viewContext = null;
    }

    private static final ViewContext createViewContext() {
        ILIMSServiceAsync limsService = Client.createLIMSService();
        IMessageResources messageResources = (IMessageResources)GWT.create(IMessageResources.class);
        PageController pageController = new PageController();
        EntityRequestEventDispatcher entityRequestEventDispatcher = new EntityRequestEventDispatcher();
        entityRequestEventDispatcher.addEntityRequestListener(new EntityRequestListener(messageResources));
        ViewContext viewContext = new ViewContext(messageResources, limsService, pageController, entityRequestEventDispatcher, new ViewModel());
        pageController.setViewContext(viewContext);
        return viewContext;
    }

    public final void onModuleLoad() {
        Field.setMsgTarget((String)"side");
        QuickTips.init();
        if (this.viewContext != null) {
            this.destroyContext();
        }
        this.viewContext = Client.createViewContext();
        this.viewContext.getLimService().tryGetCurrentSessionContext(new AsyncCallbackAdapter(){

            public final void onSuccess(Object result) {
                SessionContext sessionContext = (SessionContext)result;
                IPageController pageController = Client.this.viewContext.getPageController();
                if (sessionContext != null) {
                    Client.this.viewContext.getViewModel().setSessionContext(sessionContext);
                    pageController.createMainPage();
                } else {
                    pageController.createLoginPage();
                }
            }
        });
    }
}

