/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.webclient.client.application;

import ch.systemsx.cisd.lims.webclient.client.application.Constants;
import ch.systemsx.cisd.lims.webclient.client.application.IMessageResources;
import ch.systemsx.cisd.lims.webclient.client.application.renderer.PersonRenderer;
import ch.systemsx.cisd.lims.webclient.client.application.ui.AbstractPropertyValueRenderer;
import ch.systemsx.cisd.lims.webclient.client.application.utils.DOMUtils;
import ch.systemsx.cisd.lims.webclient.client.application.utils.PersonUtils;
import ch.systemsx.cisd.lims.webclient.client.application.utils.StringUtils;
import ch.systemsx.cisd.lims.webclient.client.dto.Invalidation;
import ch.systemsx.cisd.lims.webclient.client.dto.Material;
import ch.systemsx.cisd.lims.webclient.client.dto.Person;
import ch.systemsx.cisd.lims.webclient.client.dto.Project;
import ch.systemsx.cisd.lims.webclient.client.dto.Sample;
import java.util.Date;

public final class PropertyValueRenderers {
    private PropertyValueRenderers() {
    }

    public static final class InvalidationPropertyValueRenderer
    extends AbstractPropertyValueRenderer {
        public InvalidationPropertyValueRenderer(IMessageResources messageResources) {
            super(messageResources);
        }

        private final String rendererPerson(Person person) {
            String text = String.valueOf(this.messageResources.getSampleInvalidatorLabel()) + ": ";
            if (person != null) {
                text = String.valueOf(text) + PersonRenderer.createPersonAnchor(PersonUtils.toString(person));
            }
            return text;
        }

        private final String renderReason(String reason) {
            return String.valueOf(this.messageResources.getSampleInvalidationReasonLabel()) + ": " + StringUtils.emptyIfNull(reason);
        }

        private final String renderDate(Date date) {
            String text = String.valueOf(this.messageResources.getSampleInvalidationDateLabel()) + ": ";
            if (date != null) {
                text = String.valueOf(text) + Constants.defaultDateTimeFormat.format(date);
            }
            return text;
        }

        public final String renderNotNull(Object object) {
            Invalidation invalidation = (Invalidation)object;
            String text = String.valueOf(this.renderDate(invalidation.getRegistrationDate())) + DOMUtils.BR;
            text = String.valueOf(text) + this.renderReason(invalidation.getReason()) + DOMUtils.BR;
            text = String.valueOf(text) + this.rendererPerson(invalidation.getRegistrator());
            return text;
        }
    }

    public static final class MaterialPropertyValueRenderer
    extends AbstractPropertyValueRenderer {
        public MaterialPropertyValueRenderer(IMessageResources messageResources) {
            super(messageResources);
        }

        public final String renderNotNull(Object object) {
            Material material = (Material)object;
            return String.valueOf(material.getCode()) + " [" + this.messageResources.getMaterialTypeLabel() + ": '" + material.getMaterialType().getCode() + "']";
        }
    }

    public static final class PersonPropertyValueRenderer
    extends AbstractPropertyValueRenderer {
        public PersonPropertyValueRenderer(IMessageResources messageResources) {
            super(messageResources);
        }

        public final String renderNotNull(Object object) {
            Person person = (Person)object;
            return PersonRenderer.createPersonAnchor(PersonUtils.toString(person));
        }
    }

    public static final class ProjectPropertyValueRenderer
    extends AbstractPropertyValueRenderer {
        public ProjectPropertyValueRenderer(IMessageResources messageResources) {
            super(messageResources);
        }

        public final String renderNotNull(Object object) {
            Project project = (Project)object;
            return project + " [" + this.messageResources.getGroupCodeLabel() + ": '" + project.getGroup().getCode() + "']";
        }
    }

    public static final class SamplePropertyValueRenderer
    extends AbstractPropertyValueRenderer {
        public SamplePropertyValueRenderer(IMessageResources messageResources) {
            super(messageResources);
        }

        protected String renderNotNull(Object value) {
            Sample sample = (Sample)value;
            String code = sample.getCode();
            return sample.getInvalidation() != null ? DOMUtils.createDelElement(code) : code;
        }
    }
}

