/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.webclient.client.application;

import ch.systemsx.cisd.lims.webclient.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.lims.webclient.client.application.AsyncCallbackAdapter;
import ch.systemsx.cisd.lims.webclient.client.application.IMessageResources;
import ch.systemsx.cisd.lims.webclient.client.application.MainPage;
import ch.systemsx.cisd.lims.webclient.client.application.SearchResultPanel;
import ch.systemsx.cisd.lims.webclient.client.application.context.ViewContext;
import ch.systemsx.cisd.lims.webclient.client.application.ui.AbstractLayoutDialog;
import ch.systemsx.cisd.lims.webclient.client.application.utils.DOMUtils;
import ch.systemsx.cisd.lims.webclient.client.application.utils.StringUtils;
import ch.systemsx.cisd.lims.webclient.client.dto.BuildInfo;
import ch.systemsx.cisd.lims.webclient.client.dto.SearchResult;
import ch.systemsx.cisd.lims.webclient.client.dto.User;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.core.EventObject;
import com.gwtext.client.core.Ext;
import com.gwtext.client.util.Format;
import com.gwtext.client.widgets.Button;
import com.gwtext.client.widgets.ButtonConfig;
import com.gwtext.client.widgets.MessageBox;
import com.gwtext.client.widgets.Toolbar;
import com.gwtext.client.widgets.ToolbarButton;
import com.gwtext.client.widgets.ToolbarItem;
import com.gwtext.client.widgets.ToolbarMenuButton;
import com.gwtext.client.widgets.ToolbarTextItem;
import com.gwtext.client.widgets.event.ButtonListener;
import com.gwtext.client.widgets.event.ButtonListenerAdapter;
import com.gwtext.client.widgets.form.Field;
import com.gwtext.client.widgets.form.TextField;
import com.gwtext.client.widgets.form.event.FieldListener;
import com.gwtext.client.widgets.layout.ContentPanel;
import com.gwtext.client.widgets.menu.BaseItem;
import com.gwtext.client.widgets.menu.Item;
import com.gwtext.client.widgets.menu.ItemConfig;
import com.gwtext.client.widgets.menu.Menu;
import com.gwtext.client.widgets.menu.event.BaseItemListener;
import com.gwtext.client.widgets.menu.event.BaseItemListenerAdapter;

public class ToolbarPanel
extends ContentPanel {
    private final Toolbar toolbar;
    private final ViewContext viewContext;
    private TextField searchField;
    private final MainPage mainPage;
    private ToolbarButton searchButton;

    public ToolbarPanel(ViewContext viewContext, MainPage mainPage) {
        super(Ext.generateId());
        this.viewContext = viewContext;
        this.mainPage = mainPage;
        this.searchField = this.createSearchField();
        this.searchButton = this.createSearchButton();
        this.toolbar = new Toolbar(Ext.generateId());
        this.toolbar.addItem((ToolbarItem)this.createUsernameItem());
        this.toolbar.addButton(this.createLogoutButton());
        this.toolbar.addButton(this.createHelpMenu());
        this.toolbar.addFill();
        this.toolbar.addField((Field)this.searchField);
        this.toolbar.addButton(this.searchButton);
        this.add((Widget)this.toolbar);
    }

    private TextField createSearchField() {
        TextField textField = new TextField();
        textField.addFieldListener(new FieldListener(){

            public void onBlur(Field field) {
            }

            public void onChange(Field field, Object newVal, Object oldVal) {
            }

            public void onFocus(Field field) {
            }

            public void onInvalid(Field field, String msg) {
            }

            public void onSpecialKey(Field field, EventObject e) {
                if (e.getKey() == EventObject.ENTER) {
                    ToolbarPanel.this.submitSearchQuery();
                }
            }

            public void onValid(Field field) {
            }
        });
        return textField;
    }

    private final ToolbarMenuButton createHelpMenu() {
        Menu menu = new Menu(Ext.generateId());
        final IMessageResources messageResources = this.viewContext.getMessageResources();
        Item item = new Item(String.valueOf(messageResources.getHelpMenuAboutLabel()) + "...", new ItemConfig());
        item.addBaseItemListener((BaseItemListener)new BaseItemListenerAdapter(){

            public final void onClick(BaseItem baseItem, EventObject e) {
                AboutDialog aboutDialog = new AboutDialog(messageResources);
                ToolbarPanel.this.viewContext.getLimService().getBuildInfo(new AboutDialogCallback(aboutDialog));
            }
        });
        menu.addItem((BaseItem)item);
        ToolbarMenuButton menuButton = new ToolbarMenuButton(Ext.generateId(), messageResources.getHelpMenuLabel(), menu);
        return menuButton;
    }

    private final ToolbarTextItem createUsernameItem() {
        User user = this.viewContext.getViewModel().getUser();
        StringBuffer buffer = new StringBuffer();
        buffer.append("<b>").append(this.viewContext.getMessageResources().getLoginUsernameLabel());
        buffer.append("</b>: ").append(user.getUserName());
        buffer.append(" (").append(user.getGroupCode()).append(")");
        return new ToolbarTextItem(buffer.toString());
    }

    protected void logoutSuccessful() {
    }

    private final ToolbarButton createLogoutButton() {
        IMessageResources messageResources = this.viewContext.getMessageResources();
        ToolbarButton logoutButton = new ToolbarButton(messageResources.getLogoutLinkLabel(), new ButtonConfig(messageResources){
            {
                this.setTooltip(iMessageResources.getLogoutLinkTooltip());
            }
        });
        logoutButton.addButtonListener((ButtonListener)new LogoutButtonListener());
        return logoutButton;
    }

    private final ToolbarButton createSearchButton() {
        IMessageResources messageResources = this.viewContext.getMessageResources();
        ToolbarButton button = new ToolbarButton(messageResources.getSearchButtonTitle(), new ButtonConfig(messageResources){
            {
                this.setTooltip(iMessageResources.getSearchButtonTooltip());
            }
        });
        button.addButtonListener((ButtonListener)new SearchButtonListener());
        return button;
    }

    private void submitSearchQuery() {
        final String query = this.searchField.getValueAsString();
        if (StringUtils.isBlank(query)) {
            MessageBox.alert((String)"Search", (String)"Empty queries are not allowed. Try to be more specific.");
        } else {
            this.viewContext.getLimService().search(query, new AbstractAsyncCallback(this.viewContext){

                public void onSuccess(Object result) {
                    ToolbarPanel.this.mainPage.displayResult(new SearchResultPanel(ToolbarPanel.this.viewContext, (SearchResult)result, Format.htmlEncode((String)query)), null);
                }
            });
        }
    }

    private static final class AboutDialog
    extends AbstractLayoutDialog {
        private final ContentPanel contentPanel = new ContentPanel();

        AboutDialog(IMessageResources messageResources) {
            super(messageResources, messageResources.getHelpMenuAboutLabel(), 500, 300, true, true);
            this.addContentPanel();
        }

        protected final Widget createContentWidget() {
            return this.contentPanel;
        }

        final void setContent(String content) {
            this.contentPanel.setContent(content);
        }
    }

    private final class AboutDialogCallback
    extends AbstractAsyncCallback {
        private final AboutDialog aboutDialog;

        AboutDialogCallback(AboutDialog aboutDialog) {
            super(ToolbarPanel.this.viewContext);
            this.aboutDialog = aboutDialog;
        }

        private final String createContent(BuildInfo buildInfo) {
            StringBuffer buffer = new StringBuffer();
            IMessageResources messageResources = ToolbarPanel.this.viewContext.getMessageResources();
            buffer.append(messageResources.getCISDLogoTitle());
            buffer.append(DOMUtils.BR);
            buffer.append(messageResources.getAboutDialogVersionLabel()).append(": ").append(buildInfo.getFullVersion());
            buffer.append(DOMUtils.BR);
            buffer.append(messageResources.getAboutDialogDbVersionLabel()).append(": ").append(buildInfo.getDbVersion());
            buffer.append(DOMUtils.BR);
            buffer.append("Copyright 2007 ETH Zuerich, CISD");
            return buffer.toString();
        }

        public final void onSuccess(Object result) {
            BuildInfo buildInfo = (BuildInfo)result;
            this.aboutDialog.setContent(this.createContent(buildInfo));
            this.aboutDialog.show();
        }
    }

    private final class LogoutButtonListener
    extends ButtonListenerAdapter {
        LogoutButtonListener() {
        }

        public final void onClick(Button button, EventObject e) {
            ToolbarPanel.this.viewContext.getLimService().logout(AsyncCallbackAdapter.EMPTY_ASYNC_CALLBACK);
            ToolbarPanel.this.logoutSuccessful();
        }
    }

    private final class SearchButtonListener
    extends ButtonListenerAdapter {
        SearchButtonListener() {
        }

        public final void onClick(Button button, EventObject e) {
            ToolbarPanel.this.submitSearchQuery();
        }
    }
}

