/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.webclient.client.application.ui;

import ch.systemsx.cisd.lims.webclient.client.application.IMessageResources;
import ch.systemsx.cisd.lims.webclient.client.application.ui.DatePropertyValueRenderer;
import ch.systemsx.cisd.lims.webclient.client.application.ui.IPropertyValueRenderer;
import ch.systemsx.cisd.lims.webclient.client.application.ui.ObjectArrayPropertyValueRenderer;
import ch.systemsx.cisd.lims.webclient.client.application.ui.ObjectPropertyValueRenderer;
import ch.systemsx.cisd.lims.webclient.client.application.utils.OrderedMap;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.SourcesTableEvents;
import com.google.gwt.user.client.ui.TableListener;
import java.util.HashMap;
import java.util.Map;

public final class PropertyGrid
extends Grid {
    private static final String ARRAY_START = "[L";
    private static final String ARRAY_END = ";";
    private static final String DATE_CLASS_NAME = "java.util.Date";
    private final IMessageResources messageResources;
    private final IPropertyValueRenderer defaultPropertyValueRenderer;
    private final Map propertyValueRenderers = new HashMap();
    private final Map listeners = new HashMap();
    private OrderedMap properties;

    public PropertyGrid(IMessageResources messageResources, int rows) {
        super(rows, 2);
        this.messageResources = messageResources;
        this.setStyleName("lims-property-grid");
        this.getColumnFormatter().addStyleName(0, "header");
        this.defaultPropertyValueRenderer = new ObjectPropertyValueRenderer(messageResources);
        this.registerDefaultPropertyValueRenderers();
    }

    private final void registerDefaultPropertyValueRenderers() {
        this.propertyValueRenderers.put(DATE_CLASS_NAME, new DatePropertyValueRenderer(this.messageResources));
    }

    private final IPropertyValueRenderer getPropertyValueRenderer(String typeName) {
        if (typeName == null) {
            return this.defaultPropertyValueRenderer;
        }
        IPropertyValueRenderer renderer = (IPropertyValueRenderer)this.propertyValueRenderers.get(typeName);
        if (renderer == null) {
            renderer = typeName.startsWith(ARRAY_START) ? new ObjectArrayPropertyValueRenderer(this.messageResources, this.getPropertyValueRenderer(PropertyGrid.getTypeNameFromArray(typeName))) : this.defaultPropertyValueRenderer;
        }
        return renderer;
    }

    public final void registerPropertyValueRenderer(String className, IPropertyValueRenderer propertyValueRenderer) {
        this.propertyValueRenderers.put(className, propertyValueRenderer);
    }

    public final void unregisterPropertyValueRenderer(String className) {
        this.propertyValueRenderers.remove(className);
    }

    public final void addGridCellListener(String key, GridCellListener listener) {
        assert (this.properties != null) : "Unspecified properties.";
        this.addGridCellListener(this.properties.indexOfKey(key), listener);
    }

    public final void addGridCellListener(int row, GridCellListener listener) {
        assert (row > 0) : "Given row can not be < 0.";
        assert (listener != null) : "Undefined GridCellListener.";
        this.listeners.put(new Integer(row), listener);
    }

    public final void setProperties(OrderedMap properties) {
        this.properties = properties;
        this.fillTable();
    }

    private final void fillTable() {
        assert (this.properties != null) : "Unspecified properties.";
        int row = 0;
        while (row < this.properties.size()) {
            Object key = this.properties.getKey(row);
            this.setHTML(row, 0, key.toString());
            Object value = this.properties.getValue(row);
            String typeName = GWT.getTypeName((Object)value);
            this.setHTML(row, 1, this.getPropertyValueRenderer(typeName).render(value));
            ++row;
        }
        this.addTableListener(new PropertyGridListener());
    }

    private static final String getTypeNameFromArray(String typeName) {
        return typeName.substring(ARRAY_START.length(), typeName.indexOf(ARRAY_END));
    }

    public static interface GridCellListener {
        public void onCellClicked();
    }

    private final class PropertyGridListener
    implements TableListener {
        private PropertyGridListener() {
        }

        public final void onCellClicked(SourcesTableEvents sender, int row, int cell) {
            GridCellListener listener;
            if (cell == 1 && (listener = (GridCellListener)PropertyGrid.this.listeners.get(new Integer(row))) != null) {
                listener.onCellClicked();
            }
        }
    }
}

