/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.webclient.client.application.utils;

import ch.systemsx.cisd.lims.webclient.client.application.utils.StringUtils;
import ch.systemsx.cisd.lims.webclient.client.dto.Person;

public final class PersonUtils {
    private static final char EMAIL_END = '>';
    private static final char EMAIL_START = '<';
    private static final char LOGIN_END = ']';
    private static final char LOGIN_START = '[';

    private PersonUtils() {
    }

    public static final String parseName(String toString) {
        if (toString == null) {
            return null;
        }
        int start = toString.indexOf(60);
        if (start < 0) {
            return toString;
        }
        return toString.substring(0, start).trim();
    }

    public static final String parseEmail(String toString) {
        if (toString == null) {
            return null;
        }
        int start = toString.indexOf(60);
        int end = toString.indexOf(62);
        if (start < 0 || end < 0) {
            return null;
        }
        return toString.substring(start + 1, end);
    }

    public static final String toString(Person person) {
        assert (person != null) : "Given person can not be null.";
        StringBuffer builder = new StringBuffer();
        String lastName = person.getLastName();
        String firstName = person.getFirstName();
        if (!StringUtils.isBlank(lastName)) {
            builder.append(lastName);
        }
        if (!StringUtils.isBlank(firstName)) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(firstName);
        }
        if (builder.length() != 0) {
            builder.append(' ');
        }
        builder.append('[');
        builder.append(person.getUserId());
        builder.append(']');
        String email = person.getEmail();
        if (!StringUtils.isBlank(email) && builder.length() > 0) {
            builder.append(" ").append('<');
            builder.append(email);
            builder.append('>');
        }
        return builder.toString();
    }
}

