/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.webclient.server;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.lims.webclient.client.ILIMSService;
import ch.systemsx.cisd.lims.webclient.client.UserFailureException;
import ch.systemsx.cisd.lims.webclient.client.dto.BaseExperiment;
import ch.systemsx.cisd.lims.webclient.client.dto.BuildInfo;
import ch.systemsx.cisd.lims.webclient.client.dto.Column;
import ch.systemsx.cisd.lims.webclient.client.dto.Experiment;
import ch.systemsx.cisd.lims.webclient.client.dto.ExperimentFileAttachment;
import ch.systemsx.cisd.lims.webclient.client.dto.ExperimentIdentifier;
import ch.systemsx.cisd.lims.webclient.client.dto.PlateWells;
import ch.systemsx.cisd.lims.webclient.client.dto.Project;
import ch.systemsx.cisd.lims.webclient.client.dto.Sample;
import ch.systemsx.cisd.lims.webclient.client.dto.SampleGeneration;
import ch.systemsx.cisd.lims.webclient.client.dto.SearchResult;
import ch.systemsx.cisd.lims.webclient.client.dto.SessionContext;
import ch.systemsx.cisd.lims.webclient.server.GWTSpringController;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.log4j.Logger;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public final class LIMSServiceServlet
extends GWTSpringController
implements ILIMSService {
    private static final Logger notificationLog = LogFactory.getLogger(LogCategory.NOTIFY, LIMSServiceServlet.class);
    private static final long serialVersionUID = 1L;
    private ILIMSService limsServiceDelegate;

    private final void initService(ServletContext servletContext) {
        WebApplicationContext context = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
        this.limsServiceDelegate = (ILIMSService)context.getBean("web-openbis-service");
    }

    public final Experiment getExperimentInfo(ExperimentIdentifier experimentIdentifier) throws UserFailureException {
        return this.limsServiceDelegate.getExperimentInfo(experimentIdentifier);
    }

    public ExperimentFileAttachment getExperimentFileAttachment(ExperimentIdentifier experimentIdentifier, String filename, int version) throws UserFailureException {
        return this.limsServiceDelegate.getExperimentFileAttachment(experimentIdentifier, filename, version);
    }

    public final PlateWells getPlateWells(String sampleCode, boolean enrichMaterials) throws UserFailureException {
        return this.limsServiceDelegate.getPlateWells(sampleCode, enrichMaterials);
    }

    public Column[] getMasterPlate(String sampleCode) throws UserFailureException {
        return this.limsServiceDelegate.getMasterPlate(sampleCode);
    }

    public final SampleGeneration getSampleInfo(String sampleCode) throws UserFailureException {
        return this.limsServiceDelegate.getSampleInfo(sampleCode);
    }

    public final SessionContext tryGetCurrentSessionContext() {
        return this.limsServiceDelegate.tryGetCurrentSessionContext();
    }

    public final BaseExperiment[] listExperiments(String projectCode) throws UserFailureException {
        return this.limsServiceDelegate.listExperiments(projectCode);
    }

    public final Project[] listProjects() throws UserFailureException {
        return this.limsServiceDelegate.listProjects();
    }

    public final Sample[] listSamples(String sampleTypeCode) throws UserFailureException {
        return this.limsServiceDelegate.listSamples(sampleTypeCode);
    }

    public final SessionContext login(String user, String password) throws UserFailureException {
        return this.limsServiceDelegate.login(user, password);
    }

    public final void logout() {
        this.limsServiceDelegate.logout();
    }

    public final BuildInfo getBuildInfo() {
        return this.limsServiceDelegate.getBuildInfo();
    }

    public final void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            this.initService(config.getServletContext());
        }
        catch (Exception ex) {
            notificationLog.fatal("Failure during LIMS service servlet initialization.", ex);
            throw new ServletException((Throwable)ex);
        }
    }

    public SearchResult search(String searchString) throws UserFailureException {
        return this.limsServiceDelegate.search(searchString);
    }
}

