/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.webclient.server;

import ch.systemsx.cisd.common.exceptions.InvalidSessionException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.lims.base.server.IRequestContextProvider;
import ch.systemsx.cisd.lims.base.server.RequestContextProviderAdapter;
import ch.systemsx.cisd.lims.server.business.ISessionManager;
import ch.systemsx.cisd.lims.server.business.LoginLogManager;
import ch.systemsx.cisd.lims.server.business.Session;
import ch.systemsx.cisd.lims.server.dto.GroupDTO;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public final class ServletBasedSessionManager
implements ISessionManager {
    static final String LIMS_PARENT_SESSION_MANAGER = "limsParentSessionManager";
    static final String LIMS_SESSION_ID = "limsSessionID";
    private final int sessionExpirationPeriodSeconds;
    private final LoginLogManager loginLogManager;
    private final IRequestContextProvider httpObjectProvider;
    private final ISessionManager parentManager;

    public ServletBasedSessionManager(IRequestContextProvider requestContextProvider, ISessionManager parentManager, int sessionExpirationPeriodMinutes) {
        this.parentManager = parentManager;
        this.sessionExpirationPeriodSeconds = sessionExpirationPeriodMinutes * 60;
        this.httpObjectProvider = requestContextProvider;
        this.loginLogManager = new LoginLogManager(this.getClass(), new RequestContextProviderAdapter(requestContextProvider));
    }

    private final HttpSession getHttpSession(boolean create) {
        return this.httpObjectProvider.getHttpServletRequest().getSession(create);
    }

    public final String getRemoteHost() {
        return this.httpObjectProvider.getHttpServletRequest().getRemoteHost();
    }

    public final void closeSession(String sessionToken) {
        HttpSession httpSession = this.getHttpSession(false);
        String sessionID = null;
        if (httpSession != null) {
            sessionID = (String)httpSession.getAttribute(LIMS_SESSION_ID);
            httpSession.removeAttribute(LIMS_SESSION_ID);
            httpSession.invalidate();
        }
        if (sessionID != null) {
            this.parentManager.closeSession(sessionID);
        }
    }

    public final Session getSession(String sessionToken) throws UserFailureException {
        HttpSession httpSession = this.getHttpSession(false);
        if (httpSession == null) {
            return null;
        }
        String sessionID = (String)httpSession.getAttribute(LIMS_SESSION_ID);
        if (sessionID == null) {
            String msg = "Attempt to get non-existent session from host '" + this.getRemoteHost() + "': user is not logged in.";
            Logger authenticationLog = this.loginLogManager.getAuthenticationLog();
            if (authenticationLog.isInfoEnabled()) {
                authenticationLog.info(msg);
            }
            throw new InvalidSessionException(msg);
        }
        return this.parentManager.getSession(sessionID);
    }

    public final String openSession(String user, String password, GroupDTO group, boolean cmdLineSession) {
        String sessionToken = this.parentManager.openSession(user, password, group, cmdLineSession);
        HttpSession httpSession = this.getHttpSession(true);
        httpSession.setMaxInactiveInterval(this.sessionExpirationPeriodSeconds - 30);
        httpSession.setAttribute(LIMS_SESSION_ID, (Object)sessionToken);
        httpSession.setAttribute(LIMS_PARENT_SESSION_MANAGER, (Object)this.parentManager);
        return sessionToken;
    }
}

