/*
 * Decompiled with CFR 0.152.
 */
package com.filemaker.jdbc;

import com.filemaker.jdbc.Encoding;
import com.filemaker.jdbc.FMSQLException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.sql.SQLException;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class FMStream {
    public String host;
    public int port;
    public Socket connection;
    public InputStream fm_input;
    public BufferedOutputStream fm_output;
    private byte[] byte_buf = new byte[65536];
    private final byte[] _int8buf;
    private final byte[] _int4buf;
    private final byte[] _int2buf;
    private Cipher decryptCipher;
    private Cipher encryptCipher;
    private boolean doEncrypt;

    public FMStream(String string, int n) throws Exception {
        this.host = string;
        this.port = n;
        this.connection = new Socket(this.host, this.port);
        this.doEncrypt = !this.connection.getLocalAddress().equals(this.connection.getInetAddress());
        this._int2buf = new byte[2];
        this._int4buf = new byte[4];
        this._int8buf = new byte[8];
        this.connection.setTcpNoDelay(true);
        this.fm_input = new BufferedInputStream(this.connection.getInputStream(), 8192);
        this.fm_output = new BufferedOutputStream(this.connection.getOutputStream(), 8192);
        byte[] byArray = new byte[]{-61, 87, -86, -31, 27, 69, -73, -80, -94, -57, -67, 40, -88, -36, -103, -6};
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "AES");
        this.decryptCipher = Cipher.getInstance("AES/ECB/NoPadding");
        this.decryptCipher.init(2, secretKeySpec);
        this.encryptCipher = Cipher.getInstance("AES/ECB/NoPadding");
        this.encryptCipher.init(1, secretKeySpec);
    }

    public Cipher getD() {
        return this.decryptCipher;
    }

    public Cipher getE() {
        return this.encryptCipher;
    }

    public boolean getEncryption() {
        return this.doEncrypt;
    }

    public void SendChar(int n) throws IOException {
        this.fm_output.write((byte)n);
    }

    public void SendInteger(int n, int n2) throws IOException {
        byte[] byArray = new byte[n2];
        while (n2-- > 0) {
            byArray[n2] = (byte)(n & 0xFF);
            n >>= 8;
        }
        this.Send(byArray);
    }

    public void SendIntegerR(int n, int n2) throws IOException {
        byte[] byArray = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            byArray[i] = (byte)(n & 0xFF);
            n >>= 8;
        }
        this.Send(byArray);
    }

    public void SendInteger4(int n) throws IOException {
        this._int4buf[3] = (byte)(n >>> 24);
        this._int4buf[2] = (byte)(n >>> 16);
        this._int4buf[1] = (byte)(n >>> 8);
        this._int4buf[0] = (byte)n;
        this.fm_output.write(this._int4buf);
    }

    public void SendInteger8(long l) throws IOException {
        this._int8buf[7] = (byte)(l >>> 56);
        this._int8buf[6] = (byte)(l >>> 48);
        this._int8buf[5] = (byte)(l >>> 40);
        this._int8buf[4] = (byte)(l >>> 32);
        this._int8buf[3] = (byte)(l >>> 24);
        this._int8buf[2] = (byte)(l >>> 16);
        this._int8buf[1] = (byte)(l >>> 8);
        this._int8buf[0] = (byte)l;
        this.fm_output.write(this._int8buf);
    }

    public void SendInteger2(int n) throws IOException {
        this._int2buf[1] = (byte)(n >>> 8);
        this._int2buf[0] = (byte)n;
        this.fm_output.write(this._int2buf);
    }

    public void Send(byte[] byArray) throws IOException {
        this.fm_output.write(byArray);
    }

    public void Send(byte[] byArray, int n) throws IOException {
        this.Send(byArray, 0, n);
    }

    public void Send(byte[] byArray, int n, int n2) throws IOException {
        this.fm_output.write(byArray, n, byArray.length - n < n2 ? byArray.length - n : n2);
        if (byArray.length - n < n2) {
            for (int i = byArray.length - n; i < n2; ++i) {
                this.fm_output.write(0);
            }
        }
    }

    public int ReceiveChar() throws SQLException {
        int n = 0;
        try {
            n = this.fm_input.read();
            if (n < 0) {
                throw new FMSQLException("Unexpected end of data.", "08S01");
            }
        }
        catch (IOException iOException) {
            throw new FMSQLException(iOException.getMessage(), "08S01");
        }
        return n;
    }

    public int ReceiveInteger(int n) throws SQLException {
        int n2 = 0;
        try {
            for (int i = 0; i < n; ++i) {
                int n3 = this.fm_input.read();
                if (n3 < 0) {
                    throw new FMSQLException("Unexpected end of data.", "08S01");
                }
                n2 |= n3 << 8 * i;
            }
        }
        catch (IOException iOException) {
            throw new FMSQLException(iOException.getMessage(), "08S01");
        }
        return n2;
    }

    public int ReceiveIntegerR(int n) throws SQLException {
        int n2 = 0;
        try {
            for (int i = 0; i < n; ++i) {
                int n3 = this.fm_input.read();
                if (n3 < 0) {
                    throw new FMSQLException("Unexpected end of data.", "08S01");
                }
                n2 = n3 | n2 << 8;
            }
        }
        catch (IOException iOException) {
            throw new FMSQLException(iOException.getMessage(), "08S01");
        }
        return n2;
    }

    public long ReceiveInteger8() throws SQLException, IOException {
        if (this.fm_input.read(this._int8buf) != 8) {
            throw new FMSQLException("Unexpected end of data.", "08S01");
        }
        return (this._int8buf[7] & 0xFF) << 56 | (this._int8buf[6] & 0xFF) << 48 | (this._int8buf[5] & 0xFF) << 40 | (this._int8buf[4] & 0xFF) << 32 | (this._int8buf[3] & 0xFF) << 24 | (this._int8buf[2] & 0xFF) << 16 | (this._int8buf[1] & 0xFF) << 8 | this._int8buf[0] & 0xFF;
    }

    public int ReceiveInteger4() throws SQLException, IOException {
        if (this.fm_input.read(this._int4buf) != 4) {
            throw new FMSQLException("Unexpected end of data.", "08S01");
        }
        return (this._int4buf[3] & 0xFF) << 24 | (this._int4buf[2] & 0xFF) << 16 | (this._int4buf[1] & 0xFF) << 8 | this._int4buf[0] & 0xFF;
    }

    public int ReceiveInteger2() throws SQLException, IOException {
        int n = this.fm_input.read(this._int2buf);
        if (n != 2) {
            throw new FMSQLException("Unexpected end of data.", "08S01");
        }
        return (this._int2buf[1] & 0xFF) << 8 | this._int2buf[0] & 0xFF;
    }

    public String ReceiveString(Encoding encoding, int n) throws SQLException {
        int n2 = 0;
        byte[] byArray = this.byte_buf;
        try {
            int n3 = byArray.length;
            boolean bl = false;
            if (n <= 0) {
                byArray[n2] = 0;
                bl = true;
            }
            block2: while (!bl) {
                while (n2 < n3) {
                    int n4 = this.fm_input.read();
                    if (n4 < 0) {
                        throw new FMSQLException("Unexpected end of data.", "08S01");
                    }
                    if (n4 == 0) {
                        byArray[n2] = 0;
                        bl = true;
                        continue block2;
                    }
                    byArray[n2++] = (byte)n4;
                    if (n2 >= n) {
                        byArray[n2] = 0;
                        bl = true;
                        continue block2;
                    }
                    if (n2 < n3) continue;
                    byte[] byArray2 = new byte[n3 *= 2];
                    System.arraycopy(byArray, 0, byArray2, 0, n2);
                    byArray = byArray2;
                }
            }
        }
        catch (IOException iOException) {
            throw new FMSQLException(iOException.getMessage(), "08S01");
        }
        return encoding.decode(byArray, 0, n2);
    }

    public String ReceiveString(Encoding encoding) throws SQLException {
        int n = 0;
        byte[] byArray = this.byte_buf;
        try {
            int n2 = byArray.length;
            boolean bl = false;
            block2: while (!bl) {
                while (n < n2) {
                    int n3 = this.fm_input.read();
                    if (n3 < 0) {
                        throw new FMSQLException("Unexpected end of data.", "08S01");
                    }
                    if (n3 == 0) {
                        byArray[n] = 0;
                        bl = true;
                        continue block2;
                    }
                    byArray[n++] = (byte)n3;
                    if (n < n2) continue;
                    byte[] byArray2 = new byte[n2 *= 2];
                    System.arraycopy(byArray, 0, byArray2, 0, n);
                    byArray = byArray2;
                }
            }
        }
        catch (IOException iOException) {
            throw new FMSQLException(iOException.getMessage(), "08S01");
        }
        return encoding.decode(byArray, 0, n);
    }

    public byte[] Receive(int n) throws SQLException {
        byte[] byArray = new byte[n];
        this.Receive(byArray, 0, n);
        return byArray;
    }

    public void Receive(byte[] byArray, int n, int n2) throws SQLException {
        try {
            int n3;
            for (int i = 0; i < n2; i += n3) {
                n3 = this.fm_input.read(byArray, n + i, n2 - i);
                if (n3 >= 0) continue;
                throw new FMSQLException("Unexpected end of data.", "08S01");
            }
        }
        catch (IOException iOException) {
            throw new FMSQLException(iOException.getMessage(), "08S01");
        }
    }

    public void flush() throws SQLException {
        try {
            this.fm_output.flush();
        }
        catch (IOException iOException) {
            throw new FMSQLException(iOException.getMessage(), "08S01");
        }
    }

    public void close() throws IOException {
        this.fm_output.close();
        this.fm_input.close();
        this.connection.close();
    }
}

