/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.asapi.v3.dto.property;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.ICodeHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IDescriptionHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IPermIdHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IRegistrationDateHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IRegistratorHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.ISemanticAnnotationsHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.MaterialType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.Person;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.DataType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.fetchoptions.PropertyTypeFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.id.PropertyTypePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.semanticannotation.SemanticAnnotation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.vocabulary.Vocabulary;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.NotFetchedException;
import ch.systemsx.cisd.base.annotation.JsonObject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

@JsonObject(value="as.dto.property.PropertyType")
public class PropertyType
implements Serializable,
ICodeHolder,
IDescriptionHolder,
IPermIdHolder,
IRegistrationDateHolder,
IRegistratorHolder,
ISemanticAnnotationsHolder {
    private static final long serialVersionUID = 1L;
    @JsonProperty
    private PropertyTypeFetchOptions fetchOptions;
    @JsonProperty
    private String code;
    @JsonProperty
    private PropertyTypePermId permId;
    @JsonProperty
    private String label;
    @JsonProperty
    private String description;
    @JsonProperty
    private Boolean managedInternally;
    @JsonProperty
    private Boolean internalNameSpace;
    @JsonProperty
    private DataType dataType;
    @JsonProperty
    private Vocabulary vocabulary;
    @JsonProperty
    private MaterialType materialType;
    @JsonProperty
    private String schema;
    @JsonProperty
    private String transformation;
    @JsonProperty
    private List<SemanticAnnotation> semanticAnnotations;
    @JsonProperty
    private Person registrator;
    @JsonProperty
    private Date registrationDate;

    @JsonIgnore
    public PropertyTypeFetchOptions getFetchOptions() {
        return this.fetchOptions;
    }

    public void setFetchOptions(PropertyTypeFetchOptions fetchOptions) {
        this.fetchOptions = fetchOptions;
    }

    @Override
    @JsonIgnore
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    @JsonIgnore
    public PropertyTypePermId getPermId() {
        return this.permId;
    }

    public void setPermId(PropertyTypePermId permId) {
        this.permId = permId;
    }

    @JsonIgnore
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    @JsonIgnore
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @JsonIgnore
    public Boolean isManagedInternally() {
        return this.managedInternally;
    }

    public void setManagedInternally(Boolean managedInternally) {
        this.managedInternally = managedInternally;
    }

    @JsonIgnore
    public Boolean isInternalNameSpace() {
        return this.internalNameSpace;
    }

    public void setInternalNameSpace(Boolean internalNameSpace) {
        this.internalNameSpace = internalNameSpace;
    }

    @JsonIgnore
    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    @JsonIgnore
    public Vocabulary getVocabulary() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasVocabulary()) {
            return this.vocabulary;
        }
        throw new NotFetchedException("Vocabulary has not been fetched.");
    }

    public void setVocabulary(Vocabulary vocabulary) {
        this.vocabulary = vocabulary;
    }

    @JsonIgnore
    public MaterialType getMaterialType() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasMaterialType()) {
            return this.materialType;
        }
        throw new NotFetchedException("Material type has not been fetched.");
    }

    public void setMaterialType(MaterialType materialType) {
        this.materialType = materialType;
    }

    @JsonIgnore
    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    @JsonIgnore
    public String getTransformation() {
        return this.transformation;
    }

    public void setTransformation(String transformation) {
        this.transformation = transformation;
    }

    @Override
    @JsonIgnore
    public List<SemanticAnnotation> getSemanticAnnotations() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasSemanticAnnotations()) {
            return this.semanticAnnotations;
        }
        throw new NotFetchedException("Semantic annotations have not been fetched.");
    }

    public void setSemanticAnnotations(List<SemanticAnnotation> semanticAnnotations) {
        this.semanticAnnotations = semanticAnnotations;
    }

    @Override
    @JsonIgnore
    public Person getRegistrator() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasRegistrator()) {
            return this.registrator;
        }
        throw new NotFetchedException("Registrator has not been fetched.");
    }

    public void setRegistrator(Person registrator) {
        this.registrator = registrator;
    }

    @Override
    @JsonIgnore
    public Date getRegistrationDate() {
        return this.registrationDate;
    }

    public void setRegistrationDate(Date registrationDate) {
        this.registrationDate = registrationDate;
    }

    public String toString() {
        return "PropertyType " + this.code;
    }
}

