/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.bsse.cisd.plasmid.dss;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.etlserver.IDataSetHandler;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.filefilter.HiddenFileFilter;
import org.apache.log4j.Logger;

public class PlasmidDataSetHandler
implements IDataSetHandler {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, PlasmidDataSetHandler.class);
    private final IDataSetHandler delegator;

    public PlasmidDataSetHandler(Properties parentProperties, IDataSetHandler delegator, IEncapsulatedOpenBISService openbisService) {
        this.delegator = delegator;
    }

    public List<DataSetInformation> handleDataSet(File dataSet) {
        File[] hiddenFiles;
        File[] visibleFiles;
        if (!dataSet.isDirectory()) {
            throw UserFailureException.fromTemplate((String)"Failed to handle file '%s'. Expected a directory.", (Object[])new Object[]{dataSet});
        }
        ArrayList<DataSetInformation> result = new ArrayList<DataSetInformation>();
        File[] fileArray = visibleFiles = dataSet.listFiles((FileFilter)HiddenFileFilter.VISIBLE);
        int n = visibleFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            result.addAll(this.delegator.handleDataSet(file));
            ++n2;
        }
        File[] fileArray2 = hiddenFiles = dataSet.listFiles((FileFilter)HiddenFileFilter.HIDDEN);
        int n3 = hiddenFiles.length;
        n = 0;
        while (n < n3) {
            File file = fileArray2[n];
            String deletionStatus = FileUtilities.deleteRecursively((File)file) ? "Deleted" : "Failed to delete";
            operationLog.info((Object)String.format("%s hidden file: %s", deletionStatus, file));
            ++n;
        }
        if (!dataSet.delete()) {
            throw new EnvironmentFailureException(String.format("Failed to delete '%s' directory.", dataSet));
        }
        return result;
    }
}

