/*
 * Decompiled with CFR 0.152.
 */
package com.filemaker.jdbc;

import com.filemaker.jdbc.BaseConnection;
import com.filemaker.jdbc.BaseResultSet;
import com.filemaker.jdbc.BaseStatement;
import com.filemaker.jdbc.Encoding;
import com.filemaker.jdbc.FMCloseCursorRequest;
import com.filemaker.jdbc.FMColumnCountResponse;
import com.filemaker.jdbc.FMColumnDescriptionResponse;
import com.filemaker.jdbc.FMColumnPrivilegesRequest;
import com.filemaker.jdbc.FMColumnsRequest;
import com.filemaker.jdbc.FMEndStatementRequest;
import com.filemaker.jdbc.FMErrorResponse;
import com.filemaker.jdbc.FMExecuteRequest;
import com.filemaker.jdbc.FMIndexRequest;
import com.filemaker.jdbc.FMNextRowsRequest;
import com.filemaker.jdbc.FMPrepareRequest;
import com.filemaker.jdbc.FMPrimaryKeyRequest;
import com.filemaker.jdbc.FMQueryRequest;
import com.filemaker.jdbc.FMRowResponse;
import com.filemaker.jdbc.FMSQLException;
import com.filemaker.jdbc.FMStream;
import com.filemaker.jdbc.FMSuccessResponse;
import com.filemaker.jdbc.FMTablesRequest;
import com.filemaker.jdbc.Field;
import com.filemaker.jdbc.MessageBlock;
import com.filemaker.jdbc.MessageBlockBytes;
import com.filemaker.jdbc.ProtocolMessage;
import java.sql.SQLException;
import java.util.Vector;

public class FM_API {
    public static final short ROW_BUFFER_SIZE = 5000;
    private String[] m_sqlFrags;
    private Object[] m_binds;
    private String[] m_bindTypes;
    private BaseStatement statement;
    private BaseResultSet rs;
    private BaseConnection connection;
    private FMStream fmStream;
    private Field[] fields = null;
    private Vector tuples = new Vector();
    private boolean binaryCursor = false;
    private String status = null;
    private int update_count = 1;
    private long insert_type = 0L;
    private int maxRows;

    public static BaseResultSet getTables(String string, BaseStatement baseStatement) throws SQLException {
        FM_API fM_API = new FM_API();
        fM_API.statement = baseStatement;
        fM_API.maxRows = baseStatement != null ? baseStatement.getMaxRows() : 0;
        fM_API.connection = baseStatement.getFMConnection();
        fM_API.fmStream = fM_API.connection.getFMStream();
        Encoding encoding = fM_API.connection.getEncoding();
        return fM_API.getTables(string, encoding);
    }

    public static BaseResultSet getPrimaryKeys(String string, BaseStatement baseStatement) throws SQLException {
        FM_API fM_API = new FM_API();
        fM_API.statement = baseStatement;
        fM_API.maxRows = baseStatement != null ? baseStatement.getMaxRows() : 0;
        fM_API.connection = baseStatement.getFMConnection();
        fM_API.fmStream = fM_API.connection.getFMStream();
        Encoding encoding = fM_API.connection.getEncoding();
        return fM_API.getPrimaryKeys(string, encoding);
    }

    public static BaseResultSet getIndexInfo(String string, BaseStatement baseStatement) throws SQLException {
        FM_API fM_API = new FM_API();
        fM_API.statement = baseStatement;
        fM_API.maxRows = baseStatement != null ? baseStatement.getMaxRows() : 0;
        fM_API.connection = baseStatement.getFMConnection();
        fM_API.fmStream = fM_API.connection.getFMStream();
        Encoding encoding = fM_API.connection.getEncoding();
        return fM_API.getIndexInfo(string, encoding);
    }

    public static BaseResultSet getColumns(String string, String string2, BaseStatement baseStatement) throws SQLException {
        FM_API fM_API = new FM_API();
        fM_API.statement = baseStatement;
        fM_API.maxRows = baseStatement != null ? baseStatement.getMaxRows() : 0;
        fM_API.connection = baseStatement.getFMConnection();
        fM_API.fmStream = fM_API.connection.getFMStream();
        Encoding encoding = fM_API.connection.getEncoding();
        return fM_API.getColumns(string, string2, encoding);
    }

    public static BaseResultSet getColumnPrivileges(String string, String string2, BaseStatement baseStatement) throws SQLException {
        FM_API fM_API = new FM_API();
        fM_API.statement = baseStatement;
        fM_API.maxRows = baseStatement != null ? baseStatement.getMaxRows() : 0;
        fM_API.connection = baseStatement.getFMConnection();
        fM_API.fmStream = fM_API.connection.getFMStream();
        Encoding encoding = fM_API.connection.getEncoding();
        return fM_API.getColumnPrivileges(string, string2, encoding);
    }

    public static BaseResultSet execDirect(String[] stringArray, Object[] objectArray, String[] stringArray2, BaseStatement baseStatement) throws SQLException {
        FM_API fM_API = new FM_API();
        fM_API.m_sqlFrags = stringArray;
        fM_API.m_binds = objectArray;
        fM_API.m_bindTypes = stringArray2;
        fM_API.statement = baseStatement;
        fM_API.maxRows = baseStatement != null ? baseStatement.getMaxRows() : 0;
        fM_API.connection = baseStatement.getFMConnection();
        fM_API.fmStream = fM_API.connection.getFMStream();
        return fM_API.execDirect();
    }

    public static int prepare(String[] stringArray, Object[] objectArray, BaseStatement baseStatement) throws SQLException {
        FM_API fM_API = new FM_API();
        fM_API.m_sqlFrags = stringArray;
        fM_API.m_binds = objectArray;
        fM_API.statement = baseStatement;
        fM_API.connection = baseStatement.getFMConnection();
        fM_API.fmStream = fM_API.connection.getFMStream();
        return fM_API.prepare();
    }

    public static BaseResultSet execute(int n, Object[] objectArray, String[] stringArray, BaseStatement baseStatement) throws SQLException {
        FM_API fM_API = new FM_API();
        fM_API.m_binds = objectArray;
        fM_API.m_bindTypes = stringArray;
        fM_API.statement = baseStatement;
        fM_API.maxRows = baseStatement != null ? baseStatement.getMaxRows() : 0;
        fM_API.connection = baseStatement.getFMConnection();
        fM_API.fmStream = fM_API.connection.getFMStream();
        return fM_API.execute(n);
    }

    public static void execute(int n, Object[] objectArray, BaseResultSet baseResultSet) throws SQLException {
        FM_API fM_API = new FM_API();
        fM_API.m_binds = objectArray;
        fM_API.rs = baseResultSet;
        fM_API.statement = fM_API.rs.getFMStatement();
        fM_API.maxRows = fM_API.statement != null ? fM_API.statement.getMaxRows() : 0;
        fM_API.connection = fM_API.statement.getFMConnection();
        fM_API.fmStream = fM_API.connection.getFMStream();
        fM_API.execute(n);
    }

    public static void execDirect(String[] stringArray, Object[] objectArray, BaseResultSet baseResultSet) throws SQLException {
        FM_API fM_API = new FM_API();
        fM_API.m_sqlFrags = stringArray;
        fM_API.m_binds = objectArray;
        fM_API.rs = baseResultSet;
        fM_API.statement = fM_API.rs.getFMStatement();
        fM_API.maxRows = fM_API.statement != null ? fM_API.statement.getMaxRows() : 0;
        fM_API.connection = fM_API.statement.getFMConnection();
        fM_API.fmStream = fM_API.connection.getFMStream();
        fM_API.execDirect();
    }

    public static void endStatement(int n, BaseStatement baseStatement) throws SQLException {
        FM_API fM_API = new FM_API();
        fM_API.statement = baseStatement;
        fM_API.connection = fM_API.statement.getFMConnection();
        fM_API.fmStream = fM_API.connection.getFMStream();
        fM_API.endStmt(n);
    }

    public static void closeCursor(int n, boolean bl, BaseStatement baseStatement) throws SQLException {
        FM_API fM_API = new FM_API();
        fM_API.statement = baseStatement;
        fM_API.connection = fM_API.statement.getFMConnection();
        fM_API.fmStream = fM_API.connection.getFMStream();
        fM_API.closeServerCursor(n, bl);
    }

    private FM_API() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseResultSet execDirect() throws SQLException {
        if (this.fmStream == null) {
            throw new FMSQLException("Connection is closed. Execute operation is not permitted.", "08003");
        }
        int n = 0;
        Encoding encoding = this.connection.getEncoding();
        String string = "";
        if (this.m_binds.length <= this.m_sqlFrags.length) {
            for (n = 0; n < this.m_binds.length; ++n) {
                string = string + this.m_sqlFrags[n];
                string = string + "?";
            }
        }
        while (n < this.m_sqlFrags.length) {
            string = string + this.m_sqlFrags[n];
            ++n;
        }
        FMQueryRequest fMQueryRequest = new FMQueryRequest(string, 0L);
        for (n = 0; n < this.m_binds.length; ++n) {
            short s;
            int n2 = this.connection.getFMTypeFromName(this.m_bindTypes[n]);
            short s2 = s = this.m_binds[n].toString().equalsIgnoreCase("null") ? (short)1 : 0;
            if (n2 == 6) {
                fMQueryRequest.addParameterValue(n, (short)n2, s, (long)((byte[])this.m_binds[n]).length, (byte[])this.m_binds[n]);
                continue;
            }
            fMQueryRequest.addParameterValue(n, (short)n2, s, (long)this.m_binds[n].toString().length(), this.m_binds[n].toString());
        }
        FMStream fMStream = this.fmStream;
        synchronized (fMStream) {
            fMQueryRequest.send(this.fmStream);
            this.rs = this.getAllResults();
        }
        return this.rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int prepare() throws SQLException {
        if (this.fmStream == null) {
            throw new FMSQLException("Connection is closed. Execute operation is not permitted.", "08003");
        }
        int n = 0;
        Encoding encoding = this.connection.getEncoding();
        int n2 = -1;
        String string = "";
        if (this.m_binds.length <= this.m_sqlFrags.length) {
            for (n = 0; n < this.m_binds.length; ++n) {
                string = string + this.m_sqlFrags[n];
                string = string + "?";
            }
        }
        while (n < this.m_sqlFrags.length) {
            string = string + this.m_sqlFrags[n];
            ++n;
        }
        FMPrepareRequest fMPrepareRequest = new FMPrepareRequest(string);
        FMStream fMStream = this.fmStream;
        synchronized (fMStream) {
            fMPrepareRequest.send(this.fmStream);
            try {
                boolean bl = false;
                n2 = -1;
                boolean bl2 = false;
                MessageBlockBytes messageBlockBytes = MessageBlock.getBlock(this.fmStream);
                byte[] byArray = messageBlockBytes.blockBytes;
                short s = messageBlockBytes.commandType;
                if (s != 83) {
                    if (s == 69) {
                        FMErrorResponse fMErrorResponse = new FMErrorResponse(byArray);
                        int n3 = fMErrorResponse.getErrorCode();
                        String string2 = fMErrorResponse.getErrorMessage();
                        throw new FMSQLException(string2, "HY000");
                    }
                    throw new FMSQLException("Unexpected listener response type (1) " + s, "08S01");
                }
                FMSuccessResponse fMSuccessResponse = new FMSuccessResponse(byArray);
                n2 = fMSuccessResponse.getCommandID();
                this.update_count = (int)fMSuccessResponse.getAffectedRowCount();
                this.statement.setCommandID(n2);
            }
            catch (Exception exception) {
                throw new FMSQLException(exception.getMessage(), "08007");
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseResultSet execute(int n) throws SQLException {
        if (this.fmStream == null) {
            throw new FMSQLException("Connection is closed. Execute operation is not permitted.", "08003");
        }
        int n2 = 0;
        Encoding encoding = this.connection.getEncoding();
        FMExecuteRequest fMExecuteRequest = new FMExecuteRequest(n, 0L);
        for (n2 = 0; n2 < this.m_binds.length; ++n2) {
            short s;
            int n3 = this.connection.getFMTypeFromName(this.m_bindTypes[n2]);
            short s2 = s = this.m_binds[n2].toString().equalsIgnoreCase("null") ? (short)1 : 0;
            if (n3 == 6) {
                fMExecuteRequest.addParameterValue(n2, (short)n3, s, (long)((byte[])this.m_binds[n2]).length, (byte[])this.m_binds[n2]);
                continue;
            }
            fMExecuteRequest.addParameterValue(n2, (short)n3, s, (long)this.m_binds[n2].toString().length(), this.m_binds[n2].toString());
        }
        FMStream fMStream = this.fmStream;
        synchronized (fMStream) {
            fMExecuteRequest.send(this.fmStream);
            this.rs = this.getAllResults();
        }
        return this.rs;
    }

    private BaseResultSet getAllResults() throws SQLException {
        if (this.fmStream == null) {
            throw new FMSQLException("Connection is closed. Fetch operation is not permitted.", "08003");
        }
        try {
            int n;
            Object object;
            int n2;
            ProtocolMessage protocolMessage;
            int n3 = 0;
            int n4 = -1;
            int n5 = 0;
            MessageBlockBytes messageBlockBytes = MessageBlock.getBlock(this.fmStream);
            byte[] byArray = messageBlockBytes.blockBytes;
            short s = messageBlockBytes.commandType;
            if (s == 85) {
                protocolMessage = new FMColumnCountResponse(byArray);
                n4 = ((FMColumnCountResponse)protocolMessage).getCommandID();
                n3 = ((FMColumnCountResponse)protocolMessage).getColumnCount();
                this.statement.setCommandID(n4);
                this.fields = new Field[n3];
            } else if (s == 83) {
                protocolMessage = new FMSuccessResponse(byArray);
                this.update_count = (int)((FMSuccessResponse)protocolMessage).getAffectedRowCount();
            } else {
                if (s == 69) {
                    FMErrorResponse fMErrorResponse = new FMErrorResponse(byArray);
                    int n6 = fMErrorResponse.getErrorCode();
                    String string = fMErrorResponse.getErrorMessage();
                    throw new FMSQLException(string, "HY000");
                }
                throw new FMSQLException("Unexpected listener response type (1) " + s, "08S01");
            }
            for (n2 = 0; n2 < n3; ++n2) {
                String string;
                ProtocolMessage protocolMessage2;
                messageBlockBytes = MessageBlock.getBlock(this.fmStream);
                byArray = messageBlockBytes.blockBytes;
                s = messageBlockBytes.commandType;
                if (s != 68) {
                    if (s == 69) {
                        protocolMessage2 = new FMErrorResponse(byArray);
                        int n7 = ((FMErrorResponse)protocolMessage2).getErrorCode();
                        string = ((FMErrorResponse)protocolMessage2).getErrorMessage();
                        throw new FMSQLException(string, "HY000");
                    }
                    throw new FMSQLException("Unexpected listener response type (2) " + s, "08S01");
                }
                protocolMessage2 = new FMColumnDescriptionResponse(byArray);
                n4 = ((FMColumnDescriptionResponse)protocolMessage2).getCommandID();
                object = ((FMColumnDescriptionResponse)protocolMessage2).getDatabaseName();
                string = ((FMColumnDescriptionResponse)protocolMessage2).getTableName();
                String string2 = ((FMColumnDescriptionResponse)protocolMessage2).getColumnName();
                String string3 = ((FMColumnDescriptionResponse)protocolMessage2).getOriginalColumnName();
                short s2 = ((FMColumnDescriptionResponse)protocolMessage2).getColumnType();
                int n8 = ((FMColumnDescriptionResponse)protocolMessage2).getFlags();
                long l = ((FMColumnDescriptionResponse)protocolMessage2).getFieldSize();
                int n9 = ((FMColumnDescriptionResponse)protocolMessage2).getDecimalDigits();
                n = this.connection.getSQLType(s2);
                String string4 = this.connection.getFMType(n);
                this.fields[n2] = new Field(this.connection, string2, n, l, n8);
            }
            if (n3 > 0) {
                n2 = 0;
                boolean bl = false;
                object = new FMNextRowsRequest(n4, 0, 0L, 5000L);
                ((ProtocolMessage)object).send(this.fmStream);
                do {
                    ProtocolMessage protocolMessage3;
                    messageBlockBytes = MessageBlock.getBlock(this.fmStream);
                    byArray = messageBlockBytes.blockBytes;
                    s = messageBlockBytes.commandType;
                    int n10 = messageBlockBytes.sequenceNumber;
                    boolean bl2 = messageBlockBytes.endOfMessage;
                    int n11 = 0;
                    if (s == 87) {
                        bl = false;
                        protocolMessage3 = new FMRowResponse(byArray);
                        while (true) {
                            if (n10 != 0) {
                                protocolMessage3.append(n10, byArray);
                            }
                            if (bl2) break;
                            messageBlockBytes = MessageBlock.getBlock(this.fmStream);
                            byArray = messageBlockBytes.blockBytes;
                            s = messageBlockBytes.commandType;
                            n10 = messageBlockBytes.sequenceNumber;
                            bl2 = messageBlockBytes.endOfMessage;
                        }
                        n4 = ((FMRowResponse)protocolMessage3).getCommandID();
                        n11 = ((FMRowResponse)protocolMessage3).getColumnCount();
                        Vector vector = ((FMRowResponse)protocolMessage3).getColumns();
                        byte[][] byArray2 = new byte[n11][0];
                        for (int i = 0; i < n11; ++i) {
                            FMRowResponse.FMColumnValue fMColumnValue = (FMRowResponse.FMColumnValue)vector.elementAt(i);
                            n = fMColumnValue.columnNumber;
                            short s3 = fMColumnValue.isNull;
                            long l = fMColumnValue.totalFieldLength;
                            byArray2[i] = (byte[])(s3 == 0 ? fMColumnValue.value : null);
                        }
                        if (this.maxRows <= 0 || n5 < this.maxRows) {
                            this.tuples.addElement(byArray2);
                            ++n5;
                        }
                    } else if (s == 83) {
                        if (bl) {
                            n2 = 1;
                        }
                        bl = true;
                        protocolMessage3 = new FMSuccessResponse(byArray);
                        this.update_count = (int)((FMSuccessResponse)protocolMessage3).getAffectedRowCount();
                    } else {
                        if (s == 69) {
                            FMErrorResponse fMErrorResponse = new FMErrorResponse(byArray);
                            int n12 = fMErrorResponse.getErrorCode();
                            String string = fMErrorResponse.getErrorMessage();
                            throw new FMSQLException(string, "HY000");
                        }
                        throw new FMSQLException("Unexpected listener response type (3) " + s, "08S01");
                    }
                    if (n2 != 0 || !bl) continue;
                    object = new FMNextRowsRequest(n4, 0, 0L, 5000L);
                    ((ProtocolMessage)object).send(this.fmStream);
                } while (n2 == 0);
                this.rs = this.statement.createResultSet(this.fields, this.tuples, this.status, this.update_count, this.insert_type, this.binaryCursor);
                return this.rs;
            }
            this.rs = this.statement.createResultSet(null, this.tuples, this.status, this.update_count, this.insert_type, this.binaryCursor);
            return this.rs;
        }
        catch (Exception exception) {
            throw new FMSQLException(exception.getMessage(), "08007");
        }
    }

    private BaseResultSet getTables(String string, Encoding encoding) throws SQLException {
        if (this.fmStream == null) {
            throw new FMSQLException("Connection is closed. getTables() is not permitted.", "08003");
        }
        FMStream fMStream = this.fmStream;
        synchronized (fMStream) {
            try {
                FMTablesRequest fMTablesRequest = new FMTablesRequest(string);
                fMTablesRequest.send(this.fmStream);
                this.rs = this.getAllResults();
                return this.rs;
            }
            catch (Exception exception) {
                throw new FMSQLException(exception.getMessage(), "08007");
            }
        }
    }

    private BaseResultSet getPrimaryKeys(String string, Encoding encoding) throws SQLException {
        if (this.fmStream == null) {
            throw new FMSQLException("Connection is closed. getPrimaryKeys() is not permitted.", "08003");
        }
        FMStream fMStream = this.fmStream;
        synchronized (fMStream) {
            try {
                FMPrimaryKeyRequest fMPrimaryKeyRequest = new FMPrimaryKeyRequest(string);
                fMPrimaryKeyRequest.send(this.fmStream);
                this.rs = this.getAllResults();
                return this.rs;
            }
            catch (Exception exception) {
                throw new FMSQLException(exception.getMessage(), "08007");
            }
        }
    }

    private BaseResultSet getIndexInfo(String string, Encoding encoding) throws SQLException {
        if (this.fmStream == null) {
            throw new FMSQLException("Connection is closed. getIndexInfo() is not permitted.", "08003");
        }
        FMStream fMStream = this.fmStream;
        synchronized (fMStream) {
            try {
                FMIndexRequest fMIndexRequest = new FMIndexRequest(string);
                fMIndexRequest.send(this.fmStream);
                this.rs = this.getAllResults();
                return this.rs;
            }
            catch (Exception exception) {
                throw new FMSQLException(exception.getMessage(), "08007");
            }
        }
    }

    private BaseResultSet getColumns(String string, String string2, Encoding encoding) throws SQLException {
        if (this.fmStream == null) {
            throw new FMSQLException("Connection is closed. getColumns() is not permitted.", "08003");
        }
        FMStream fMStream = this.fmStream;
        synchronized (fMStream) {
            try {
                FMColumnsRequest fMColumnsRequest = new FMColumnsRequest(string, string2);
                fMColumnsRequest.send(this.fmStream);
                this.rs = this.getAllResults();
                return this.rs;
            }
            catch (Exception exception) {
                throw new FMSQLException(exception.getMessage(), "08007");
            }
        }
    }

    private BaseResultSet getColumnPrivileges(String string, String string2, Encoding encoding) throws SQLException {
        if (this.fmStream == null) {
            throw new FMSQLException("Connection is closed. getColumnPrivileges() is not permitted.", "08003");
        }
        FMStream fMStream = this.fmStream;
        synchronized (fMStream) {
            try {
                FMColumnPrivilegesRequest fMColumnPrivilegesRequest = new FMColumnPrivilegesRequest(string, string2);
                fMColumnPrivilegesRequest.send(this.fmStream);
                this.rs = this.getAllResults();
                return this.rs;
            }
            catch (Exception exception) {
                throw new FMSQLException(exception.getMessage(), "08007");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endStmt(int n) throws SQLException {
        if (this.fmStream == null) {
            throw new FMSQLException("Connection is closed. Execute operation is not permitted.", "08003");
        }
        FMEndStatementRequest fMEndStatementRequest = new FMEndStatementRequest(n);
        FMStream fMStream = this.fmStream;
        synchronized (fMStream) {
            fMEndStatementRequest.send(this.fmStream);
            try {
                MessageBlockBytes messageBlockBytes = MessageBlock.getBlock(this.fmStream);
                byte[] byArray = messageBlockBytes.blockBytes;
                short s = messageBlockBytes.commandType;
                if (s != 83) {
                    if (s == 69) {
                        FMErrorResponse fMErrorResponse = new FMErrorResponse(byArray);
                        int n2 = fMErrorResponse.getErrorCode();
                        String string = fMErrorResponse.getErrorMessage();
                        throw new FMSQLException(string, "HY000");
                    }
                    throw new FMSQLException("Unexpected listener response type (1) " + s, "08S01");
                }
                FMSuccessResponse fMSuccessResponse = new FMSuccessResponse(byArray);
            }
            catch (Exception exception) {
                throw new FMSQLException(exception.getMessage(), "08007");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeServerCursor(int n, boolean bl) throws SQLException {
        if (this.fmStream == null) {
            throw new FMSQLException("Connection is closed. Execute operation is not permitted.", "08003");
        }
        short s = 0;
        if (bl) {
            s = 1;
        }
        FMCloseCursorRequest fMCloseCursorRequest = new FMCloseCursorRequest(n, s);
        FMStream fMStream = this.fmStream;
        synchronized (fMStream) {
            fMCloseCursorRequest.send(this.fmStream);
            try {
                MessageBlockBytes messageBlockBytes = MessageBlock.getBlock(this.fmStream);
                byte[] byArray = messageBlockBytes.blockBytes;
                short s2 = messageBlockBytes.commandType;
                if (s2 != 83) {
                    if (s2 == 69) {
                        FMErrorResponse fMErrorResponse = new FMErrorResponse(byArray);
                        int n2 = fMErrorResponse.getErrorCode();
                        String string = fMErrorResponse.getErrorMessage();
                        throw new FMSQLException(string, "HY000");
                    }
                    throw new FMSQLException("Unexpected listener response type (1) " + s2, "08S01");
                }
                FMSuccessResponse fMSuccessResponse = new FMSuccessResponse(byArray);
            }
            catch (Exception exception) {
                throw new FMSQLException(exception.getMessage(), "08007");
            }
        }
    }
}

