/*
 * Decompiled with CFR 0.152.
 */
package com.filemaker.util;

public class AES {
    protected int current;
    protected static int[] invSBox = new int[]{82, 9, 106, 213, 48, 54, 165, 56, 191, 64, 163, 158, 129, 243, 215, 251, 124, 227, 57, 130, 155, 47, 255, 135, 52, 142, 67, 68, 196, 222, 233, 203, 84, 123, 148, 50, 166, 194, 35, 61, 238, 76, 149, 11, 66, 250, 195, 78, 8, 46, 161, 102, 40, 217, 36, 178, 118, 91, 162, 73, 109, 139, 209, 37, 114, 248, 246, 100, 134, 104, 152, 22, 212, 164, 92, 204, 93, 101, 182, 146, 108, 112, 72, 80, 253, 237, 185, 218, 94, 21, 70, 87, 167, 141, 157, 132, 144, 216, 171, 0, 140, 188, 211, 10, 247, 228, 88, 5, 184, 179, 69, 6, 208, 44, 30, 143, 202, 63, 15, 2, 193, 175, 189, 3, 1, 19, 138, 107, 58, 145, 17, 65, 79, 103, 220, 234, 151, 242, 207, 206, 240, 180, 230, 115, 150, 172, 116, 34, 231, 173, 53, 133, 226, 249, 55, 232, 28, 117, 223, 110, 71, 241, 26, 113, 29, 41, 197, 137, 111, 183, 98, 14, 170, 24, 190, 27, 252, 86, 62, 75, 198, 210, 121, 32, 154, 219, 192, 254, 120, 205, 90, 244, 31, 221, 168, 51, 136, 7, 199, 49, 177, 18, 16, 89, 39, 128, 236, 95, 96, 81, 127, 169, 25, 181, 74, 13, 45, 229, 122, 159, 147, 201, 156, 239, 160, 224, 59, 77, 174, 42, 245, 176, 200, 235, 187, 60, 131, 83, 153, 97, 23, 43, 4, 126, 186, 119, 214, 38, 225, 105, 20, 99, 85, 33, 12, 125};
    protected int[] rCon = new int[]{141, 1, 2, 4, 8, 16, 32, 64, 128, 27, 54, 108, 216, 171, 77, 154, 47, 94, 188, 99, 198, 151, 53, 106, 212, 179, 125, 250, 239, 197, 145, 57, 114, 228, 211, 189, 97, 194, 159, 37, 74, 148, 51, 102, 204, 131, 29, 58, 116, 232, 203, 141, 1, 2, 4, 8, 16, 32, 64, 128, 27, 54, 108, 216, 171, 77, 154, 47, 94, 188, 99, 198, 151, 53, 106, 212, 179, 125, 250, 239, 197, 145, 57, 114, 228, 211, 189, 97, 194, 159, 37, 74, 148, 51, 102, 204, 131, 29, 58, 116, 232, 203, 141, 1, 2, 4, 8, 16, 32, 64, 128, 27, 54, 108, 216, 171, 77, 154, 47, 94, 188, 99, 198, 151, 53, 106, 212, 179, 125, 250, 239, 197, 145, 57, 114, 228, 211, 189, 97, 194, 159, 37, 74, 148, 51, 102, 204, 131, 29, 58, 116, 232, 203, 141, 1, 2, 4, 8, 16, 32, 64, 128, 27, 54, 108, 216, 171, 77, 154, 47, 94, 188, 99, 198, 151, 53, 106, 212, 179, 125, 250, 239, 197, 145, 57, 114, 228, 211, 189, 97, 194, 159, 37, 74, 148, 51, 102, 204, 131, 29, 58, 116, 232, 203, 141, 1, 2, 4, 8, 16, 32, 64, 128, 27, 54, 108, 216, 171, 77, 154, 47, 94, 188, 99, 198, 151, 53, 106, 212, 179, 125, 250, 239, 197, 145, 57, 114, 228, 211, 189, 97, 194, 159, 37, 74, 148, 51, 102, 204, 131, 29, 58, 116, 232, 203};
    protected static int Nb = 4;
    protected int Nk;
    protected int Nr;
    protected int[][][] s;
    protected static int[] sBox = new int[]{99, 124, 119, 123, 242, 107, 111, 197, 48, 1, 103, 43, 254, 215, 171, 118, 202, 130, 201, 125, 250, 89, 71, 240, 173, 212, 162, 175, 156, 164, 114, 192, 183, 253, 147, 38, 54, 63, 247, 204, 52, 165, 229, 241, 113, 216, 49, 21, 4, 199, 35, 195, 24, 150, 5, 154, 7, 18, 128, 226, 235, 39, 178, 117, 9, 131, 44, 26, 27, 110, 90, 160, 82, 59, 214, 179, 41, 227, 47, 132, 83, 209, 0, 237, 32, 252, 177, 91, 106, 203, 190, 57, 74, 76, 88, 207, 208, 239, 170, 251, 67, 77, 51, 133, 69, 249, 2, 127, 80, 60, 159, 168, 81, 163, 64, 143, 146, 157, 56, 245, 188, 182, 218, 33, 16, 255, 243, 210, 205, 12, 19, 236, 95, 151, 68, 23, 196, 167, 126, 61, 100, 93, 25, 115, 96, 129, 79, 220, 34, 42, 144, 136, 70, 238, 184, 20, 222, 94, 11, 219, 224, 50, 58, 10, 73, 6, 36, 92, 194, 211, 172, 98, 145, 149, 228, 121, 231, 200, 55, 109, 141, 213, 78, 169, 108, 86, 244, 234, 101, 122, 174, 8, 186, 120, 37, 46, 28, 166, 180, 198, 232, 221, 116, 31, 75, 189, 139, 138, 112, 62, 181, 102, 72, 3, 246, 14, 97, 53, 87, 185, 134, 193, 29, 158, 225, 248, 152, 17, 105, 217, 142, 148, 155, 30, 135, 233, 206, 85, 40, 223, 140, 161, 137, 13, 191, 230, 66, 104, 65, 153, 45, 15, 176, 84, 187, 22};
    protected int[] w;
    protected int[] key;

    public AES(byte[] byArray) {
        this.key = new int[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            this.key[i] = byArray[i];
        }
        Nb = 4;
        switch (byArray.length) {
            case 16: {
                this.Nr = 10;
                this.Nk = 4;
                break;
            }
            case 24: {
                this.Nr = 12;
                this.Nk = 6;
                break;
            }
            case 32: {
                this.Nr = 14;
                this.Nk = 8;
                break;
            }
            default: {
                throw new IllegalArgumentException("Only 128, 192, 256 keys are supported");
            }
        }
        this.s = new int[2][4][Nb];
        this.w = new int[Nb * (this.Nr + 1)];
        this.keyExpand();
    }

    protected AES() {
    }

    protected int[][] addRoundKey(int[][] nArray, int n) {
        for (int i = 0; i < Nb; ++i) {
            for (int j = 0; j < 4; ++j) {
                nArray[j][i] = nArray[j][i] ^ this.w[n * Nb + i] << j * 8 >>> 24;
            }
        }
        return nArray;
    }

    protected int[][] cipher(int[][] nArray, int[][] nArray2) {
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[0].length; ++j) {
                nArray2[i][j] = nArray[i][j];
            }
        }
        this.current = 0;
        this.addRoundKey(nArray2, this.current);
        this.current = 1;
        while (this.current < this.Nr) {
            this.subBytes(nArray2);
            this.shiftRows(nArray2);
            this.mixColumns(nArray2);
            this.addRoundKey(nArray2, this.current);
            ++this.current;
        }
        this.subBytes(nArray2);
        this.shiftRows(nArray2);
        this.addRoundKey(nArray2, this.current);
        return nArray2;
    }

    protected int[][] invCipher(int[][] nArray, int[][] nArray2) {
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[0].length; ++j) {
                nArray2[i][j] = nArray[i][j];
            }
        }
        this.current = this.Nr;
        this.addRoundKey(nArray2, this.current);
        this.current = this.Nr - 1;
        while (this.current > 0) {
            this.invShiftRows(nArray2);
            this.invSubBytes(nArray2);
            this.addRoundKey(nArray2, this.current);
            this.invMixColumns(nArray2);
            --this.current;
        }
        this.invShiftRows(nArray2);
        this.invSubBytes(nArray2);
        this.addRoundKey(nArray2, this.current);
        return nArray2;
    }

    public byte[] decrypt(byte[] byArray) {
        int n;
        int n2;
        if (byArray.length != 16) {
            throw new IllegalArgumentException("Can only decrypt 16byte arrays");
        }
        byte[] byArray2 = new byte[byArray.length];
        for (n2 = 0; n2 < Nb; ++n2) {
            for (n = 0; n < 4; ++n) {
                this.s[0][n][n2] = byArray[n2 * Nb + n] & 0xFF;
            }
        }
        this.invCipher(this.s[0], this.s[1]);
        for (n2 = 0; n2 < Nb; ++n2) {
            for (n = 0; n < 4; ++n) {
                byArray2[n2 * AES.Nb + n] = (byte)(this.s[1][n][n2] & 0xFF);
            }
        }
        return byArray2;
    }

    public void decrypt2(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(byArray[i] ^ this.key[i]);
        }
    }

    public byte[] encrypt(byte[] byArray) {
        int n;
        int n2;
        if (byArray.length != 16) {
            throw new IllegalArgumentException("Can only encrypt 16byte arrays");
        }
        byte[] byArray2 = new byte[byArray.length];
        for (n2 = 0; n2 < Nb; ++n2) {
            for (n = 0; n < 4; ++n) {
                this.s[0][n][n2] = byArray[n2 * Nb + n] & 0xFF;
            }
        }
        this.cipher(this.s[0], this.s[1]);
        for (n2 = 0; n2 < Nb; ++n2) {
            for (n = 0; n < 4; ++n) {
                byArray2[n2 * AES.Nb + n] = (byte)(this.s[1][n][n2] & 0xFF);
            }
        }
        return byArray2;
    }

    public void encrypt2(byte[] byArray) {
        this.decrypt2(byArray);
    }

    protected int[][] invMixColumns(int[][] nArray) {
        for (int i = 0; i < Nb; ++i) {
            int n = AES.mult(14, nArray[0][i]) ^ AES.mult(11, nArray[1][i]) ^ AES.mult(13, nArray[2][i]) ^ AES.mult(9, nArray[3][i]);
            int n2 = AES.mult(9, nArray[0][i]) ^ AES.mult(14, nArray[1][i]) ^ AES.mult(11, nArray[2][i]) ^ AES.mult(13, nArray[3][i]);
            int n3 = AES.mult(13, nArray[0][i]) ^ AES.mult(9, nArray[1][i]) ^ AES.mult(14, nArray[2][i]) ^ AES.mult(11, nArray[3][i]);
            int n4 = AES.mult(11, nArray[0][i]) ^ AES.mult(13, nArray[1][i]) ^ AES.mult(9, nArray[2][i]) ^ AES.mult(14, nArray[3][i]);
            nArray[0][i] = n;
            nArray[1][i] = n2;
            nArray[2][i] = n3;
            nArray[3][i] = n4;
        }
        return nArray;
    }

    protected int[][] invShiftRows(int[][] nArray) {
        int n;
        int n2 = nArray[1][Nb - 1];
        for (n = Nb - 1; n > 0; --n) {
            nArray[1][n] = nArray[1][(n - 1) % Nb];
        }
        nArray[1][0] = n2;
        n2 = nArray[2][Nb - 1];
        int n3 = nArray[2][Nb - 2];
        for (n = Nb - 1; n > 1; --n) {
            nArray[2][n] = nArray[2][(n - 2) % Nb];
        }
        nArray[2][1] = n2;
        nArray[2][0] = n3;
        n2 = nArray[3][Nb - 3];
        n3 = nArray[3][Nb - 2];
        int n4 = nArray[3][Nb - 1];
        for (n = Nb - 1; n > 2; --n) {
            nArray[3][n] = nArray[3][(n - 3) % Nb];
        }
        nArray[3][0] = n2;
        nArray[3][1] = n3;
        nArray[3][2] = n4;
        return nArray;
    }

    protected int[][] invSubBytes(int[][] nArray) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < Nb; ++j) {
                nArray[i][j] = AES.invSubWord(nArray[i][j]) & 0xFF;
            }
        }
        return nArray;
    }

    protected static int invSubWord(int n) {
        int n2 = 0;
        for (int i = 24; i >= 0; i -= 8) {
            int n3 = n << i >>> 24;
            n2 |= invSBox[n3] << 24 - i;
        }
        return n2;
    }

    protected int[] keyExpand() {
        int n;
        for (n = 0; n < this.Nk; ++n) {
            this.w[n] = 0;
            int n2 = n;
            this.w[n2] = this.w[n2] | this.key[4 * n] << 24;
            int n3 = n;
            this.w[n3] = this.w[n3] | this.key[4 * n + 1] << 16;
            int n4 = n;
            this.w[n4] = this.w[n4] | this.key[4 * n + 2] << 8;
            int n5 = n;
            this.w[n5] = this.w[n5] | this.key[4 * n + 3];
        }
        for (n = this.Nk; n < Nb * (this.Nr + 1); ++n) {
            int n6 = this.w[n - 1];
            if (n % this.Nk == 0) {
                n6 = AES.subWord(AES.rotWord(n6)) ^ this.rCon[n / this.Nk] << 24;
            } else if (this.Nk > 6 && n % this.Nk == 4) {
                n6 = AES.subWord(n6);
            }
            this.w[n] = this.w[n - this.Nk] ^ n6;
        }
        return this.w;
    }

    protected int[][] mixColumns(int[][] nArray) {
        for (int i = 0; i < Nb; ++i) {
            int n = AES.mult(2, nArray[0][i]) ^ AES.mult(3, nArray[1][i]) ^ nArray[2][i] ^ nArray[3][i];
            int n2 = nArray[0][i] ^ AES.mult(2, nArray[1][i]) ^ AES.mult(3, nArray[2][i]) ^ nArray[3][i];
            int n3 = nArray[0][i] ^ nArray[1][i] ^ AES.mult(2, nArray[2][i]) ^ AES.mult(3, nArray[3][i]);
            int n4 = AES.mult(3, nArray[0][i]) ^ nArray[1][i] ^ nArray[2][i] ^ AES.mult(2, nArray[3][i]);
            nArray[0][i] = n;
            nArray[1][i] = n2;
            nArray[2][i] = n3;
            nArray[3][i] = n4;
        }
        return nArray;
    }

    protected static int mult(int n, int n2) {
        int n3 = 0;
        while (n != 0) {
            if ((n & 1) != 0) {
                n3 ^= n2;
            }
            n2 = AES.xtime(n2);
            n >>>= 1;
        }
        return n3;
    }

    protected static int rotWord(int n) {
        return n << 8 | (n & 0xFF000000) >>> 24;
    }

    protected int[][] shiftRows(int[][] nArray) {
        int n;
        int n2 = nArray[1][0];
        for (n = 0; n < Nb - 1; ++n) {
            nArray[1][n] = nArray[1][(n + 1) % Nb];
        }
        nArray[1][AES.Nb - 1] = n2;
        n2 = nArray[2][0];
        int n3 = nArray[2][1];
        for (n = 0; n < Nb - 2; ++n) {
            nArray[2][n] = nArray[2][(n + 2) % Nb];
        }
        nArray[2][AES.Nb - 2] = n2;
        nArray[2][AES.Nb - 1] = n3;
        n2 = nArray[3][0];
        n3 = nArray[3][1];
        int n4 = nArray[3][2];
        for (n = 0; n < Nb - 3; ++n) {
            nArray[3][n] = nArray[3][(n + 3) % Nb];
        }
        nArray[3][AES.Nb - 3] = n2;
        nArray[3][AES.Nb - 2] = n3;
        nArray[3][AES.Nb - 1] = n4;
        return nArray;
    }

    protected int[][] subBytes(int[][] nArray) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < Nb; ++j) {
                nArray[i][j] = AES.subWord(nArray[i][j]) & 0xFF;
            }
        }
        return nArray;
    }

    protected static int subWord(int n) {
        int n2 = 0;
        for (int i = 24; i >= 0; i -= 8) {
            int n3 = n << i >>> 24;
            n2 |= sBox[n3] << 24 - i;
        }
        return n2;
    }

    protected static int xtime(int n) {
        if ((n & 0x80) == 0) {
            return n << 1;
        }
        return n << 1 ^ 0x11B;
    }
}

