/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.asapi.v3.dto.person;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IPermIdHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IRegistrationDateHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IRegistratorHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.ISpaceHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.fetchoptions.PersonFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.id.PersonPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.roleassignment.RoleAssignment;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.Space;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.NotFetchedException;
import ch.systemsx.cisd.base.annotation.JsonObject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

@JsonObject(value="as.dto.person.Person")
public class Person
implements Serializable,
IPermIdHolder,
IRegistrationDateHolder,
IRegistratorHolder,
ISpaceHolder {
    private static final long serialVersionUID = 1L;
    @JsonProperty
    private PersonFetchOptions fetchOptions;
    @JsonProperty
    private PersonPermId permId;
    @JsonProperty
    private String userId;
    @JsonProperty
    private String firstName;
    @JsonProperty
    private String lastName;
    @JsonProperty
    private String email;
    @JsonProperty
    private Date registrationDate;
    @JsonProperty
    private Boolean active;
    @JsonProperty
    private Space space;
    @JsonProperty
    private Person registrator;
    @JsonProperty
    private List<RoleAssignment> roleAssignments;

    @JsonIgnore
    public PersonFetchOptions getFetchOptions() {
        return this.fetchOptions;
    }

    public void setFetchOptions(PersonFetchOptions fetchOptions) {
        this.fetchOptions = fetchOptions;
    }

    @Override
    @JsonIgnore
    public PersonPermId getPermId() {
        return this.permId;
    }

    public void setPermId(PersonPermId permId) {
        this.permId = permId;
    }

    @JsonIgnore
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    @JsonIgnore
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @JsonIgnore
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @JsonIgnore
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    @JsonIgnore
    public Date getRegistrationDate() {
        return this.registrationDate;
    }

    public void setRegistrationDate(Date registrationDate) {
        this.registrationDate = registrationDate;
    }

    @JsonIgnore
    public Boolean isActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    @Override
    @JsonIgnore
    public Space getSpace() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasSpace()) {
            return this.space;
        }
        throw new NotFetchedException("Space has not been fetched.");
    }

    public void setSpace(Space space) {
        this.space = space;
    }

    @Override
    @JsonIgnore
    public Person getRegistrator() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasRegistrator()) {
            return this.registrator;
        }
        throw new NotFetchedException("Registrator has not been fetched.");
    }

    public void setRegistrator(Person registrator) {
        this.registrator = registrator;
    }

    @JsonIgnore
    public List<RoleAssignment> getRoleAssignments() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasRoleAssignments()) {
            return this.roleAssignments;
        }
        throw new NotFetchedException("Role assignments have not been fetched.");
    }

    public void setRoleAssignments(List<RoleAssignment> roleAssignments) {
        this.roleAssignments = roleAssignments;
    }

    public String toString() {
        return "Person " + this.userId;
    }
}

