/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.spring;

import ch.systemsx.cisd.common.http.JettyHttpClientFactory;
import ch.systemsx.cisd.common.spring.IRemoteSpringBeanProvider;
import ch.systemsx.cisd.common.spring.JettyRemoteSpringBeanProvider;
import com.marathon.util.spring.StreamSupportingHttpInvokerProxyFactoryBean;
import com.marathon.util.spring.StreamSupportingHttpInvokerRequestExecutor;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.HttpHost;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.impl.NoConnectionReuseStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.springframework.remoting.httpinvoker.HttpComponentsHttpInvokerRequestExecutor;
import org.springframework.remoting.httpinvoker.HttpInvokerProxyFactoryBean;

public class HttpInvokerUtils {
    public static IRemoteSpringBeanProvider provider;
    private static SSLConnectionSocketFactory sf;

    static {
        sf = HttpInvokerUtils.initializeSSLConnectionFactory();
    }

    private static SSLConnectionSocketFactory initializeSSLConnectionFactory() {
        try {
            return new SSLConnectionSocketFactory(SSLContexts.createDefault(), SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T createServiceStub(Class<T> serviceInterface, String serviceURL, long serverTimeoutInMillis) {
        if (HttpInvokerUtils.checkAndInitializeJettyProvider()) {
            return provider.create(serviceInterface, serviceURL, serverTimeoutInMillis);
        }
        return HttpInvokerUtils.createApacheServiceStub(serviceInterface, serviceURL, serverTimeoutInMillis);
    }

    public static <T> T createStreamSupportingServiceStub(Class<T> serviceInterface, String serviceURL, long serverTimeoutInMillis) {
        if (HttpInvokerUtils.checkAndInitializeJettyProvider()) {
            return provider.create(serviceInterface, serviceURL, serverTimeoutInMillis);
        }
        return HttpInvokerUtils.createStreamSupportingApacheServiceStub(serviceInterface, serviceURL, serverTimeoutInMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkAndInitializeJettyProvider() {
        try {
            Class.forName("org.eclipse.jetty.client.HttpClient", false, HttpInvokerUtils.class.getClassLoader());
            Class<HttpInvokerUtils> clazz = HttpInvokerUtils.class;
            synchronized (HttpInvokerUtils.class) {
                if (provider == null) {
                    provider = new JettyRemoteSpringBeanProvider(JettyHttpClientFactory.getHttpClient());
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private static <T> T createApacheServiceStub(Class<T> serviceInterface, String serviceURL, long serverTimeoutInMillis) {
        HttpInvokerProxyFactoryBean httpInvokerProxy = new HttpInvokerProxyFactoryBean();
        Registry<ConnectionSocketFactory> schemeRegistry = RegistryBuilder.create().register("http", PlainConnectionSocketFactory.getSocketFactory()).register("https", (PlainConnectionSocketFactory)((Object)sf)).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(schemeRegistry);
        connectionManager.setMaxTotal(100);
        connectionManager.setDefaultMaxPerRoute(5);
        CloseableHttpClient client = HttpClientBuilder.create().setConnectionManager(connectionManager).useSystemProperties().setConnectionReuseStrategy(new NoConnectionReuseStrategy()).build();
        HttpComponentsHttpInvokerRequestExecutor httpInvokerRequestExecutor = new HttpComponentsHttpInvokerRequestExecutor(client);
        httpInvokerProxy.setHttpInvokerRequestExecutor(httpInvokerRequestExecutor);
        httpInvokerProxy.setBeanClassLoader(serviceInterface.getClassLoader());
        httpInvokerProxy.setServiceUrl(serviceURL);
        httpInvokerProxy.setServiceInterface(serviceInterface);
        httpInvokerRequestExecutor.setReadTimeout((int)serverTimeoutInMillis);
        InetSocketAddress proxyAddressOrNull = HttpInvokerUtils.tryFindProxy(serviceURL);
        if (proxyAddressOrNull != null) {
            HttpHost proxy = new HttpHost(proxyAddressOrNull.getHostName(), proxyAddressOrNull.getPort(), "http");
            CloseableHttpClient client2 = HttpClientBuilder.create().setProxy(proxy).useSystemProperties().setConnectionManager(connectionManager).setConnectionReuseStrategy(new NoConnectionReuseStrategy()).build();
            httpInvokerRequestExecutor.setHttpClient(client2);
        }
        httpInvokerProxy.afterPropertiesSet();
        return HttpInvokerUtils.getCastedService(httpInvokerProxy);
    }

    private static <T> T createStreamSupportingApacheServiceStub(Class<T> serviceInterface, String serviceURL, long serverTimeoutInMillis) {
        StreamSupportingHttpInvokerProxyFactoryBean httpInvokerProxy = new StreamSupportingHttpInvokerProxyFactoryBean();
        httpInvokerProxy.setBeanClassLoader(serviceInterface.getClassLoader());
        httpInvokerProxy.setServiceUrl(serviceURL);
        httpInvokerProxy.setServiceInterface(serviceInterface);
        Registry<ConnectionSocketFactory> schemeRegistry = RegistryBuilder.create().register("http", PlainConnectionSocketFactory.getSocketFactory()).register("https", (PlainConnectionSocketFactory)((Object)sf)).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(schemeRegistry);
        connectionManager.setMaxTotal(100);
        connectionManager.setDefaultMaxPerRoute(5);
        StreamSupportingHttpInvokerRequestExecutor httpInvokerRequestExecutor = (StreamSupportingHttpInvokerRequestExecutor)httpInvokerProxy.getHttpInvokerRequestExecutor();
        httpInvokerRequestExecutor.setReadTimeout((int)serverTimeoutInMillis);
        InetSocketAddress proxyAddressOrNull = HttpInvokerUtils.tryFindProxy(serviceURL);
        if (proxyAddressOrNull != null) {
            HttpHost proxy = new HttpHost(proxyAddressOrNull.getHostName(), proxyAddressOrNull.getPort(), "http");
            CloseableHttpClient client2 = HttpClientBuilder.create().setConnectionReuseStrategy(new NoConnectionReuseStrategy()).setProxy(proxy).useSystemProperties().setConnectionManager(connectionManager).build();
            httpInvokerRequestExecutor.setHttpClient(client2);
        } else {
            httpInvokerRequestExecutor.setHttpClient(HttpClientBuilder.create().setConnectionReuseStrategy(new NoConnectionReuseStrategy()).useSystemProperties().setConnectionManager(connectionManager).build());
        }
        httpInvokerProxy.afterPropertiesSet();
        return HttpInvokerUtils.getCastedService(httpInvokerProxy);
    }

    public static final <T> T getCastedService(HttpInvokerProxyFactoryBean httpInvokerProxy) {
        return (T)httpInvokerProxy.getObject();
    }

    public static InetSocketAddress tryFindProxy(String serviceURL) {
        try {
            ProxySelector selector = ProxySelector.getDefault();
            List<Proxy> proxyList = selector.select(new URI(serviceURL));
            for (Proxy proxy : proxyList) {
                if (Proxy.Type.HTTP != proxy.type()) continue;
                return (InetSocketAddress)proxy.address();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (URISyntaxException uRISyntaxException) {}
        return null;
    }

    private HttpInvokerUtils() {
    }
}

