/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.ArchivingStatus;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.Complete;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.FileFormatType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.LocatorType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.StorageFormat;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.fetchoptions.PhysicalDataFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.NotFetchedException;
import ch.systemsx.cisd.base.annotation.JsonObject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;

@JsonObject(value="as.dto.dataset.PhysicalData")
public class PhysicalData
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty
    private PhysicalDataFetchOptions fetchOptions;
    @JsonProperty
    private String shareId;
    @JsonProperty
    private String location;
    @JsonProperty
    private Long size;
    @JsonProperty
    private StorageFormat storageFormat;
    @JsonProperty
    private FileFormatType fileFormatType;
    @JsonProperty
    private LocatorType locatorType;
    @JsonProperty
    private Complete complete;
    @JsonProperty
    private ArchivingStatus status;
    @JsonProperty
    private Boolean presentInArchive;
    @JsonProperty
    private Boolean storageConfirmation;
    @JsonProperty
    private Integer speedHint;

    @JsonIgnore
    public PhysicalDataFetchOptions getFetchOptions() {
        return this.fetchOptions;
    }

    public void setFetchOptions(PhysicalDataFetchOptions fetchOptions) {
        this.fetchOptions = fetchOptions;
    }

    @JsonIgnore
    public String getShareId() {
        return this.shareId;
    }

    public void setShareId(String shareId) {
        this.shareId = shareId;
    }

    @JsonIgnore
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    @JsonIgnore
    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    @JsonIgnore
    public StorageFormat getStorageFormat() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasStorageFormat()) {
            return this.storageFormat;
        }
        throw new NotFetchedException("Storage format has not been fetched.");
    }

    public void setStorageFormat(StorageFormat storageFormat) {
        this.storageFormat = storageFormat;
    }

    @JsonIgnore
    public FileFormatType getFileFormatType() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasFileFormatType()) {
            return this.fileFormatType;
        }
        throw new NotFetchedException("File Format Type has not been fetched.");
    }

    public void setFileFormatType(FileFormatType fileFormatType) {
        this.fileFormatType = fileFormatType;
    }

    @JsonIgnore
    public LocatorType getLocatorType() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasLocatorType()) {
            return this.locatorType;
        }
        throw new NotFetchedException("Locator Type has not been fetched.");
    }

    public void setLocatorType(LocatorType locatorType) {
        this.locatorType = locatorType;
    }

    @JsonIgnore
    public Complete getComplete() {
        return this.complete;
    }

    public void setComplete(Complete complete) {
        this.complete = complete;
    }

    @JsonIgnore
    public ArchivingStatus getStatus() {
        return this.status;
    }

    public void setStatus(ArchivingStatus status) {
        this.status = status;
    }

    @JsonIgnore
    public Boolean isPresentInArchive() {
        return this.presentInArchive;
    }

    public void setPresentInArchive(Boolean presentInArchive) {
        this.presentInArchive = presentInArchive;
    }

    @JsonIgnore
    public Boolean isStorageConfirmation() {
        return this.storageConfirmation;
    }

    public void setStorageConfirmation(Boolean storageConfirmation) {
        this.storageConfirmation = storageConfirmation;
    }

    @JsonIgnore
    public Integer getSpeedHint() {
        return this.speedHint;
    }

    public void setSpeedHint(Integer speedHint) {
        this.speedHint = speedHint;
    }

    public String toString() {
        return "PhysicalData " + this.location;
    }
}

