/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.hpack;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.hpack.AuthorityHttpField;
import org.eclipse.jetty.http2.hpack.HpackContext;
import org.eclipse.jetty.http2.hpack.Huffman;
import org.eclipse.jetty.http2.hpack.MetaDataBuilder;
import org.eclipse.jetty.http2.hpack.NBitInteger;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HpackDecoder {
    public static final Logger LOG = Log.getLogger(HpackDecoder.class);
    public static final HttpField.LongValueHttpField CONTENT_LENGTH_0 = new HttpField.LongValueHttpField(HttpHeader.CONTENT_LENGTH, 0L);
    private final HpackContext _context;
    private final MetaDataBuilder _builder;
    private int _localMaxDynamicTableSize;

    public HpackDecoder(int localMaxDynamicTableSize, int maxHeaderSize) {
        this._context = new HpackContext(localMaxDynamicTableSize);
        this._localMaxDynamicTableSize = localMaxDynamicTableSize;
        this._builder = new MetaDataBuilder(maxHeaderSize);
    }

    public HpackContext getHpackContext() {
        return this._context;
    }

    public void setLocalMaxDynamicTableSize(int localMaxdynamciTableSize) {
        this._localMaxDynamicTableSize = localMaxdynamciTableSize;
    }

    public MetaData decode(ByteBuffer buffer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("CtxTbl[%x] decoding %d octets", this._context.hashCode(), buffer.remaining()), new Object[0]);
        }
        if (buffer.remaining() > this._builder.getMaxSize()) {
            throw new BadMessageException(431, "Header frame size " + buffer.remaining() + ">" + this._builder.getMaxSize());
        }
        block10: while (buffer.hasRemaining()) {
            HttpField field;
            HttpHeader header;
            String name;
            int name_index;
            boolean indexed;
            byte b;
            if (LOG.isDebugEnabled() && buffer.hasArray()) {
                int l = Math.min(buffer.remaining(), 32);
                LOG.debug("decode {}{}", TypeUtil.toHexString(buffer.array(), buffer.arrayOffset() + buffer.position(), l), l < buffer.remaining() ? "..." : "");
            }
            if ((b = buffer.get()) < 0) {
                int index = NBitInteger.decode(buffer, 7);
                HpackContext.Entry entry = this._context.get(index);
                if (entry == null) {
                    throw new BadMessageException(400, "Unknown index " + index);
                }
                if (entry.isStatic()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("decode IdxStatic {}", entry);
                    }
                    this._builder.emit(entry.getHttpField());
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("decode Idx {}", entry);
                }
                this._builder.emit(entry.getHttpField());
                continue;
            }
            byte f = (byte)((b & 0xF0) >> 4);
            switch (f) {
                case 2: 
                case 3: {
                    int size = NBitInteger.decode(buffer, 5);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("decode resize=" + size, new Object[0]);
                    }
                    if (size > this._localMaxDynamicTableSize) {
                        throw new IllegalArgumentException();
                    }
                    this._context.resize(size);
                    continue block10;
                }
                case 0: 
                case 1: {
                    indexed = false;
                    name_index = NBitInteger.decode(buffer, 4);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    indexed = true;
                    name_index = NBitInteger.decode(buffer, 6);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            boolean huffmanName = false;
            if (name_index > 0) {
                HpackContext.Entry name_entry = this._context.get(name_index);
                name = name_entry.getHttpField().getName();
                header = name_entry.getHttpField().getHeader();
            } else {
                huffmanName = (buffer.get() & 0x80) == 128;
                int length = NBitInteger.decode(buffer, 7);
                this._builder.checkSize(length, huffmanName);
                name = huffmanName ? Huffman.decode(buffer, length) : HpackDecoder.toASCIIString(buffer, length);
                for (int i = 0; i < name.length(); ++i) {
                    char c = name.charAt(i);
                    if (c < 'A' || c > 'Z') continue;
                    throw new BadMessageException(400, "Uppercase header name");
                }
                header = HttpHeader.CACHE.get(name);
            }
            boolean huffmanValue = (buffer.get() & 0x80) == 128;
            int length = NBitInteger.decode(buffer, 7);
            this._builder.checkSize(length, huffmanValue);
            String value = huffmanValue ? Huffman.decode(buffer, length) : HpackDecoder.toASCIIString(buffer, length);
            if (header == null) {
                field = new HttpField(null, name, value);
            } else {
                switch (header) {
                    case C_STATUS: {
                        if (indexed) {
                            field = new HttpField.IntValueHttpField(header, name, value);
                            break;
                        }
                        field = new HttpField(header, name, value);
                        break;
                    }
                    case C_AUTHORITY: {
                        field = new AuthorityHttpField(value);
                        break;
                    }
                    case CONTENT_LENGTH: {
                        if ("0".equals(value)) {
                            field = CONTENT_LENGTH_0;
                            break;
                        }
                        field = new HttpField.LongValueHttpField(header, name, value);
                        break;
                    }
                    default: {
                        field = new HttpField(header, name, value);
                    }
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("decoded '{}' by {}/{}/{}", field, name_index > 0 ? "IdxName" : (huffmanName ? "HuffName" : "LitName"), huffmanValue ? "HuffVal" : "LitVal", indexed ? "Idx" : "");
            }
            this._builder.emit(field);
            if (!indexed || this._context.add(field) != null) continue;
            throw new BadMessageException(431, "Indexed field value too large");
        }
        return this._builder.build();
    }

    public static String toASCIIString(ByteBuffer buffer, int length) {
        StringBuilder builder = new StringBuilder(length);
        int position = buffer.position();
        int start = buffer.arrayOffset() + position;
        int end = start + length;
        buffer.position(position + length);
        byte[] array = buffer.array();
        for (int i = start; i < end; ++i) {
            builder.append((char)(0x7F & array[i]));
        }
        return builder.toString();
    }

    public String toString() {
        return String.format("HpackDecoder@%x{%s}", this.hashCode(), this._context);
    }
}

