#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Helper Methods
#
def getVocabularyTermCodeForVocabularyAndTermLabel(vocabularyCode, termLabel):
    vocabulary = vocabularyDefinitions[vocabularyCode]
    for term in vocabulary:
        if term[1] == termLabel:
            #print repr("TERM NOT FOUND IN VOCABULARY LIST: " + unicode(vocabularyCode) + " : '" + unicode(termLabel) + "'")
            return term[0]
    return None

# "VOCABULARY_CODE" : { "TERM_CODE" : "OBJECT" }
createdVocabularyTerms = { }

def printCreatedTerms():
    print "--- Created Vocabulary Terms Report"
    for vocabularyCode in createdVocabularyTerms:
        print "Vocabulary [" + vocabularyCode + "]"
        for vocabularyTermCode in createdVocabularyTerms[vocabularyCode]:
            print "Term [" + vocabularyTermCode + "] Label: [" + repr(createdVocabularyTerms[vocabularyCode][vocabularyTermCode].getLabel()) + "]"
    print "---"

def getCreatedTerm(vocabularyCode, termCode):
    if vocabularyCode in createdVocabularyTerms:
        if termCode in createdVocabularyTerms[vocabularyCode]:
            return createdVocabularyTerms[vocabularyCode][termCode]
    return None

def addCreatedTerm(vocabularyCode, termCode, object):
    if vocabularyCode not in createdVocabularyTerms:
        createdVocabularyTerms[vocabularyCode] = {}
    createdVocabularyTerms[vocabularyCode][termCode] = object
    
def createVocabularyTerm(tr, vocabularyCode, termCode, termLabel):
    createdTerm = getCreatedTerm(vocabularyCode, termCode)
    if createdTerm is None:
        vocabulary = tr.getVocabularyForUpdate(vocabularyCode)
        
        for term in vocabulary.getTerms():
            if term.getCode() == termCode:
                createdTerm = term
        
        if createdTerm is None:
            createdTerm = tr.createNewVocabularyTerm()
            createdTerm.setCode(termCode)
            createdTerm.setLabel(termLabel)
            createdTerm.setOrdinal(vocabulary.getTerms().size())
            vocabulary.addTerm(createdTerm)
            addCreatedTerm(vocabularyCode, termCode, createdTerm)
    return createdTerm

#
# Vocabularies
#

vocabularyDefinitions = {
                          "ALL_LAB_MEMBERS" : [
                                        ["ANNA_DEPLAZES",   "Anna Deplazes"],
                                        ["ANNE-CHRISTINE_BUTTY",   "Anne-Christine Butty"],
                                        ["BRIAN_LUKE",   "Brian Luke"],
                                        ["CAROLINE_ZBINDEN",   "Caroline Zbinden"],
                                        ["CELINE_LAFOURCADE",   "Celine Lafourcade"],
                                        ["CHRISTINE_RUPP",   "Christine Rupp"],
                                        ["CLAUDINE_KRAFT",   "Claudine Kraft"],
                                        ["EDYTA_SIERGIEJUK",   "Edyta Siergiejuk"],
                                        ["FABIAN_HERZOG",   "Fabian Herzog"],
                                        ["FABIAN_RUDOLF",   "Fabian Rudolf"],
                                        ["FRANK_VAN_DROGEN",   "Frank Van Drogen"],
                                        ["GERDA_JORRITSMA",   "Gerda Jorritsma"],
                                        ["GWEN_RABUT",   "Gw\xe9nael Rabut"],
                                        ["INGRID_STOFFEL-STUDER",   "Ingrid Stoffel-Studer"],
                                        ["IRAM_ZAIDI",   "Iram Zaidi"],
                                        ["IZABELA_SUMARA",   "Izabela Sumara"],
                                        ["LIONEL_PINTARD",   "Lionel Pintard"],
                                        ["MALIKAJAQUENOUD",   "MalikaJaquenoud"],
                                        ["MARC_SOHRMANN",   "Marc Sohrmann"],
                                        ["MARIE-LYN_HECHT",   "Marie-Lyn Hecht"],
                                        ["MARIE-PIERRE_GULLI",   "Marie-Pierre Gulli"],
                                        ["MATTHIAS_PETER",   "Matthias Peter"],
                                        ["MICHAEL_OLMA",   "Michael Olma"],
                                        ["MICHAEL_SCHNEIDER",   "Michael Schneider"],
                                        ["MICHELE_KNAUS",   "Michele Knaus"],
                                        ["MONIKA_GERSBACH",   "Monika Gersbach"],
                                        ["NATHALIE_MEYER-SCHALLER",   "Nathalie Meyer-Schaller"],
                                        ["NATHALIE_PERRINJAQUET",   "Nathalie Perrinjaquet"],
                                        ["NICOLAS_DARD",   "Nicolas Dard"],
                                        ["NICOLAS_PAGE",   "Nicolas Page"],
                                        ["PATRICK_PEDRIOLI",   "Patrick Pedrioli"],
                                        ["PHILIPPE_WIGET",   "Philippe Wiget"],
                                        ["PIERRE_MAILLARD",   "Pierre Maillard"],
                                        ["REINHARD_DECHANT",   "Reinhard Dechant"],
                                        ["SANDER_SPRINGER",   "Sander Springer"],
                                        ["SARAH_GLASER",   "Sarah Glaser"],
                                        ["SARAH_MAERKI",   "Sarah  M\xe4rki"],
                                        ["SEBASTIAN_LEIDEL",   "Sebastian Leidel"],
                                        ["SERGE_PELET",   "Serge Pelet"],
                                        ["STEFAN_MUELLER",   "Stefan M�ller"],
                                        ["TANIA_ROBERTS",   "Tania Roberts"],
                                        ["THIMO_KURZ",   "Thimo Kurz"],
                                        ["TOBIAS_BRAUN",   "Tobias Braun"],
                                        ["VANESSA_REZGUI",   "Vanessa Rezgui"],
                                        ["WOJCIECH_PIWKO",   "Wojciech Piwko"],
                                        ["YUKIKO_SHIMADA",   "Yukiko Shimada"],
                                        ["YVONNE_GLOOR",   "Yvonne Gloor"],
                                        ["JOCHEN_BECK",   "Jochen Beck"],
                                        ["MONIKA_KIJANSKA",   "Monika Kijanska"],
                                        ["ANGIE_RAGHEB",   "Angie Ragheb"],
                                        ["ANNE_PACQUELET",   "Anne Pacquelet"],
                                        ["BJORN_HEGEMANN",   "Bj\xf6rn Hegemann"],
                                        ["JANNY_TILMA",   "Janny Tilma"],
                                        ["THIBAULT_COURTHEOUX",   "Thibault Courtheoux"],
                                        ["SAMUEL_GILBERTO",   "Samuel Gilberto"],
                                        ["REMY_BUSER",   "Remy Buser"],
                                        ["RADOSLAV_ENCHEV",   "Radoslav Enchev"],
                                        ["MICHAELA_HUBNER",   "Michaela Hubner"],
                                        ["MIA_LI",   "Mia Li"],
                                        ["JULIEN_MOUYSSET",   "Julien Mouysset"]
                                    ],
                           "LAB_MEMBERS_INITIALS" : [
                                        ["AD", "AD"],
                                        ["ACB", "ACB"],
                                        ["BL", "BL"],
                                        ["CZ", "CZ"],
                                        ["CL", "CL"],
                                        ["CR", "CR"],
                                        ["CK", "CK"],
                                        ["ES", "ES"],
                                        ["FH", "FH"],
                                        ["FR", "FR"],
                                        ["FD", "FD"],
                                        ["GJ", "GJ"],
                                        ["GR", "GR"],
                                        ["ISS", "ISS"],
                                        ["IZ", "IZ"],
                                        ["IS", "IS"],
                                        ["LP", "LP"],
                                        ["MJ", "MJ"],
                                        ["MSO", "MSo"],
                                        ["MH", "MH"],
                                        ["MG", "MG"],
                                        ["MP", "MP"],
                                        ["MO", "MO"],
                                        ["MSC", "MSc"],
                                        ["MK", "MK"],
                                        ["MG", "MG"],
                                        ["NS", "NS"],
                                        ["NPE", "NPe"],
                                        ["ND", "ND"],
                                        ["NPA", "NPa"],
                                        ["PP", "PP"],
                                        ["PW", "PW"],
                                        ["PM", "PM"],
                                        ["RD", "RD"],
                                        ["SS", "SS"],
                                        ["SG", "SG"],
                                        ["SMA", "SMa"],
                                        ["SL", "SL"],
                                        ["SP", "SP"],
                                        ["SM", "SM"],
                                        ["TR", "TR"],
                                        ["TK", "TK"],
                                        ["TB", "TB"],
                                        ["VR", "VR"],
                                        ["WP", "WP"],
                                        ["YS", "YS"],
                                        ["YG", "YG"],
                                        ["JB", "JB"],
                                        ["MKI", "MKi"]
                                    ],
                            "BLOCK" : [
                                       ["1BSA_01TRITON-X100",  "1% BSA; 0.1% Triton-X100"],
                                    ],
                            "CLASS" : [
                                ["IGM", "IgM"],
                                ["IGG1",    "IgG1"],
                                ["IGG2",    "IgG2"]
                                    ],
                            "COMPANY" : [
                                    ["ABCAM", "abcam"],
                                    ["CELL_SIGNALING", "cell signaling"],
                                    ["STRATAGEN", "stratagene"],
                                    ["CLONTECH", "clontech"],
                                    ["UBI", "ubi"],
                                    ["SOUTHERN_BIOTECH", "southern biotech"],
                                    ["PIERCE", "pierce"],
                                    ["PHARMIGEN", "pharmingen"],
                                    ["MOLECULAR_PROBES", "molecular probes"],
                                    ["PHARMACIA", "pharmacia"],
                                    ["BIORAD", "biorad"],
                                    ["EUROGENETIC", "eurogentec"],
                                    ["HOMEMADE", "homemade"],
                                    ["BD_BIOSCIENCE", "BD bioscience"],
                                    ["OBTAINED_FROM", "obtained from "],
                                    ["ZYMED", "Zymed"],
                                    ["UNKNOWN", "Unknown"],
                                    ["SANTA_CRUZ", "Santa Cruz"],
                                    ["BIOLEGEND", "Biolegend"],
                                    ["BETHYL", "Bethyl"],
                                    ["UPSTATE", "Upstate"],
                                    ["ROCKLAND", "Rockland"],
                                    ["NOVUS_BIOLOGICALS", "Novus Biologicals"],
                                    ["CHEMICON_INTERNATIONAL", "Chemicon International"],
                                    ["SIGMA", "Sigma"],
                                    ["ALPHA_DIAGNOSTIC_INTERNATIONAL", "Alpha Diagnostic International"],
                                    ["MILLIPORE", "Millipore"],
                                    ["ACTIVE_MOTIF", "Active motif"],
                                    ["NEB", "NEB"],
                                    ["NEOMARKERS", "Neomarkers"],
                                    ["LUBIOSCIENCE", "LubioScience"],
                                    ["EBIOSCIENCE", "eBioscience"],
                                    ["INVITROGEN", "Invitrogen"],
                                    ["STRESSGEN", "Stressgen"],
                                    ["COVANCE", "Covance"],
                                    ["ENZO_LIFE_SCIENCES", "Enzo Life Sciences"],
                                    ["CALBIOCHEM", "Calbiochem"],
                                    ["ROCHE", "Roche"],
                                    ["CYTOSKELETON", "Cytoskeleton"],
                                    ["OPEN_BIOSYSTEMS", "Open Biosystems"],
                                    ["BD_TRANSDUCTION", "BD Transduction"],
                                    ["ATLAS_ANTIBODIES_AB", "Atlas Antibodies AB"],
                                    ["GENENTECH", "Genentech"],
                                    ["TRANSDUCTION_LABS", "Transduction Labs"],
                                    ["ANTIBODIES_INCORPORATED", "Antibodies Incorporated"],
                                    ["BABCO", "BAbCO"],
                                    ["ERICH_NIGG_LAB_BASEL", "Erich Nigg lab (Basel)"],
                                    ["FRANCIS_BARR", "Francis Barr"],
                                    ["AVIVA_SYSTEMS_BIOLOGY", "Aviva Systems Biology"],
                                    ["LUCERNACHEM", "LucernaChem"],
                                    ["LI-COR", "LI-COR"],
                                    ["ABGENT", "Abgent"],
                                    ["CHROMOTEK", "Chromotek"],
                                    ["ABNOVA", "Abnova"],
                                    ["UNKNOWN", "Unknown"],
                                    ["ABSEA", "Absea"],
                                    ["GE_HEALTHCARE", "GE Healthcare"],
                                    ["GRAMSCH_LABORATORIES", "Gramsch Laboratories"],
                                    ["ADIPOGEN", "Adipogen"],
                                    ["COSMO_BIO_CO", "Cosmo bio co."],
                                    ["BECKTON_DICKINSON", "Beckton Dickinson"],
                                    ["BIOTIUM", "Biotium"]
                                    ],
                            "CONCENTRATION_FACS" : [
                                            ["1_TO_10", "1 : 10"],
                                            ["1_TO_20", "1 : 20"],
                                            ["1_TO_30", "1 : 30"],
                                            ["1_TO_40", "1 : 40"],
                                            ["1_TO_50", "1 : 50"],
                                            ["1_TO_100", "1 : 100"],
                                            ["1_TO_200", "1 : 200"],
                                            ["1_TO_500", "1 : 500"],
                                            ["1_TO_1000", "1 : 1000"],
                                            ["1_TO_2000", "1 : 2000"],
                                            ["1_TO_3000", "1 : 3000"],
                                            ["NOT_TESTED", "not tested"],
                                            ["NOT_WORKING", "not working"]
                                    ],
                            "CONCENTRATION_IP" : [
                                            ["1UL", "1 �l"],
                                            ["5UL", "5 �l"],
                                            ["10UL", "10 �l"],
                                            ["15UL", "15 �l"],
                                            ["20UL", "20 �l"],
                                            ["NOT_TESTED", "not tested"],
                                            ["NOT_WORKING", "not working"]
                                    ],
                            "CONCENTRATION_WESTERN" : [
                                                ["1_TO_100", "1 : 100"],
                                                ["1_TO_500", "1 : 500"],
                                                ["1_TO_1000", "1 : 1000"],
                                                ["1_TO_2000", "1 : 2000"],
                                                ["1_TO_3000", "1 : 3000"],
                                                ["1_TO_5000", "1 : 5000"],
                                                ["1_TO_10000", "1 : 10000"],
                                                ["1_TO_20000", "1 : 20000"],
                                                ["1_TO_25000", "1 : 25000"],
                                                ["NOT_TESTED", "not tested"],
                                                ["NOT_WORKING", "not working"]
                                    ],
                          "CURRENT_LAB_MEMBERS" : [
                                            ["CAROLINE_ZBINDEN", "Caroline Zbinden"],
                                            ["FRANK_VAN_DROGEN", "Frank Van Drogen"],
                                            ["INGRID_STOFFEL-STUDER", "Ingrid Stoffel-Studer"],
                                            ["MATTHIAS_PETER", "Matthias Peter"],
                                            ["REINHARD_DECHANT", "Reinhard Dechant"],
                                            ["WOJCIECH_PIWKO", "Wojciech Piwko"],
                                            ["JOCHEN_BECK", "Jochen Beck"]
                                    ],
                          "FIX" : [
                                ["1H-RT", "1h, RT"],
                                ["PTEMF", "PTEMF"],
                                ["PFA", "PFA"],
                                ["MEOH", "MeOH"]
                                    ],
                          "LABEL" : [
                                ["HRP", "hrp"],
                                ["AP", "ap"],
                                ["FITC", "fitc"],
                                ["CY3", "Cy3"],
                                ["ALEXA647", "Alexa 647"]
                                    ],
                          "ANTIBODY_LOCATION" : [
                                    ["SMALL_PETER_LAB", "Small Peter Lab"],
                                    ["BIG_PETER_LAB", "Big Peter Lab"],
                                    ["NEW_PETER_LAB", "New Peter Lab"],
                                    ["MINUS20_C-FLOOR", "-20C C-Floor"]
                                    ],
                          "MONO-POLYCLONAL" : [
                                            ["MONOCLONAL",  "Monoclonal"],
                                            ["POLYCLONAL",  "Polyclonal"],
                                            ["UNKNOWN", "Unknown"]
                                    ],
                          "SOURCE" : [
                                ["MOUSE",  "Mouse"],
                                ["RABBIT",  "Rabbit"],
                                ["HAMSTER",  "Hamster"],
                                ["GOAT",  "Goat"],
                                ["RAT",  "Rat"],
                                ["CHICKEN",  "Chicken"],
                                ["SHEEP",  "Sheep"],
                                ["HUMAN",  "Human"],
                                ["GUINEA_PIG",  "Guinea pig"],
                                ["DONEKY",  "Donkey"],
                                ["UNKNOWN",  "Unknown"]
                                    ],
                          "CELL_LOCATION" : [
                                ["FRIDGE",  "fridge"],
                                ["FREEZER",  "freezer"],
                                ["REFCO",  "refco"],
                                ["TANK",  "tank"]
                                    ],
                          "SELECTION" : [
                                ["NEOMYCIN_G418",  "Neomycin/G418"],
                                ["HYGROMYCIN",  "Hygromycin"],
                                ["MPA",  "MPA"],
                                ["G418",  "G418"],
                                ["PUROMYCIN",  "puromycin"],
                                ["BLASTICIDIN",  "Blasticidin"],
                                ["ZEOCIN",  "Zeocin"] 
                                    ],
                          "CO2" : [
                                ["5",  "5"],
                                ["7.5",  "7.5"]
                                    ],
                          "GROWTH_TEMPERATURE" : [
                                ["37",  "37"],
                                ["28",  "28"],
                                ["34",  "34"]
                                    ],
                          "MEDIUM" : [
                                ["RPMI1640",  "RPMI 1640"],
                                ["ISCOVES",  "Iscoves"],
                                ["DMEM",  "DMEM"],
                                ["LB",  "LB"],
                                ["DMEM_NUTRIENT",  "DMEM nutrient mixture F-12 HAM [D8437]"]
                                    ], 
                          "CELL_OBTAINED_FROM" : [
                                ["FREIBURG",  "Freiburg"],
                                ["ATCC",  "ATCC"],
                                ["DANIEL_GERLICH",  "Daniel Gerlich"],
                                ["ERICH_NIGG",  "Erich Nigg"],
                                ["KREK",  "Krek"],
                                ["TONY_HEYMAN",  "Tony Heyman"],
                                ["THOMAS-WILD_ULRIKE-KUTAY",  "Thomas Wild/Ulrike Kutay"],
                                ["JAN_MICHAEL_PETERS",  "Jan-Michael Peters"],
                                ["M_BRANDEIS",  "M Brandeis"],
                                ["ARI_HELENIUS",  "Ari Helenius"],
                                ["ROMEO_RICCI",  "Romeo Ricci"]
                                    ],  
                          "CELL_SPECIES" : [
                                ["HUMAN",  "human"],
                                ["MOUSE",  "mouse"],
                                ["RAT",  "rat"],
                                ["CHINESE_HAMSTER",  "chines hamster"],
                                ["HYBRIDOMA",  "hybridoma (human & mouse)"]                                
                                    ],  
                          "CONC_UNITS" : [
                                ["MICROG_MICROL",  "�g/�l"],
                                ["MG_ML",  "mgl/ml"],
                                ["UG_ML",  "ug/ml"]                               
                                    ],  
                          "STRAIN_SOURCE" : [
                                ["F_CHANG", "F. Chang"],
                                ["J_CHANT", "J. Chant"],
                                ["R_DESHAIES", "R. Deshaies"],
                                ["E_ELION", "E. Elion"],
                                ["P_HIETER", "P. Hieter"],
                                ["I_HERSKOWITZ", "I. Herskowitz"],
                                ["A_NEIMAN", "A. Neiman"],
                                ["P_SORGER", "P. Sorger"],
                                ["T_STEARNS", "T. Stearns"],
                                ["MARC_BONDEL", "Marc Bondel"],
                                ["G_SUMARA", "G. Sumara"],
                                ["MICHAEL_ALTMANN", "Michael Altmann"],
                                ["HETEROZYGOUS_DIPLOID_COLLECTION", "Heterozygous diploid collection"],
                                ["ANNE-CHRISTINE_BUTTY", "Anne-Christine Butty"],
                                ["ANNE_PAQUELET", "Anne Paquelet"],
                                ["YAGMUR-TURGAY_KUTAY-GROUP", "Yagmur Turgay - Kutay group"],
                                ["BARBAR_CATARIN", "Barbar Catarin"],
                                ["FRANK_VAN-DROGEN", "Frank van Drogen"],
                                ["HEMMO_MEYER", "Hemmo Meyer"],
                                ["JEAN-MARC_GALLAND", "Jean-Marc Galland"],
                                ["JEFF_PARVIN", "Jeff Parvin"],
                                ["MARIE-PIERRE_GULLI", "Marie-Pierre Gulli"],
                                ["MIKIKO_TAKAHASHI", "Mikiko Takahashi"],
                                ["SANDRA_HENCHOZ", "Sandra Henchoz"],
                                ["MALIKA_JAQUENOUD", "Malika Jaquenoud"],
                                ["GERDA_JORRITSMA", "Gerda Jorritsma"],
                                ["CELINE_LAFOURCADE", "Céline Lafourcade"],
                                ["CELINE_LONGARETTI", "Céline Longaretti"],
                                ["BRIAN_LUKE", "Brian Luke"],
                                ["GUY_NIEDERHAUSER", "Guy Niederhäuser"],
                                ["NICOLAS_PAGE", "Nicolas Pag�"],
                                ["NATHALIE_PERRINJAQUET", "Nathalie Perrinjaquet"],
                                ["MATTHIAS_PETER", "Matthias Peter"],
                                ["AUDREY_PETIT", "Audrey Petit"],
                                ["LIONEL_PINTARD", "Lionel Pintard"],
                                ["YUKIKO_SHIMADA", "Yukiko Shimada"],
                                ["PHILIPPE_WIGET", "Philippe Wiget"],
                                ["VOLKER_STUCKE", "Volker Stucke"],
                                ["KATRIN_PETER", "Katrin Peter"],
                                ["MARC_BLONDEL", "marc blondel"],
                                ["M_FUNK", "M. Funk"],
                                ["ATTILA_BECSKEI", "Attila Becskei"],
                                ["GWENAEL_RABUT", "Gwenael Rabut"],
                                ["PHILIP_JERMANN", "Philip Jermann"],
                                ["P_PRYCIAK", "P.Pryciak"],
                                ["LINDA_HICKE", "Linda Hicke"],
                                ["RZPD", "RZPD"],
                                ["OPENBIO", "OpenBio"],
                                ["F_POSAS", "F. Posas"],
                                ["HAPLOID_COLLECTION", "Haploid collection"],
                                ["MIRIAM_BORTFELD", "Miriam Bortfeld"],
                                ["EUROSCARF", "Euroscarf"],
                                ["TS_COLLECTION", "ts collection"],
                                ["CONZELMANN_LAB", "Conzelmann lab"],
                                ["SEBASTIAN_LEIDEL", "Sebastian Leidel"],
                                ["ANNA_DEPLAZES", "Anna Deplazes"],
                                ["BIBOU", "Bibou"],
                                ["MARC_SOHRMANN", "Marc sohrmann"]
                                    ],
                          "SELECTION_YEAST" : [
                                ["NONE",  "None"],
                                ["URA",  "Ura"],
                                ["LEU",  "Leu"], 
                                ["TRP",  "Trp"], 
                                ["HIS",  "His"], 
                                ["VIABILITY",  "Viability"], 
                                ["NAT",  "nat"], 
                                ["KAN",  "kan"], 
                                ["KAN_NAT",  "kan + nat"], 
                                ["HIS_KAN",  "HIS + kan"], 
                                ["HIS_KAN_NAT",  "HIS + kan + nat"], 
                                ["HIS",  "HIS"], 
                                ["LEU_NAT",  "leu + nat"], 
                                ["ADE2",  "ade2"]
                                    ],  
                         "DERIVATION" : [
                                ["GAMMA_INTEG",  "gamma integ"],
                                ["DELTA_INTEG",  "� integ"],
                                ["5FAO_LOOPOUT",  "5-FAO loopout"],
                                ["PLASMID_SHUFFLE",  "plasmid shuffle"],
                                ["TETRAD",  "tetrad"],
                                ["LOOP-IN_LOOP-OUT",  "loop-in/loop-out"],
                                ["GALPHO",  "GalpHO mating type switch"],
                                ["DELETION",  "Deletion"],
                                ["INTEGRATION",  "Integration"]
                                    ],
                         "STRAIN_BACKGROUND" : [
                                ["W303",  "W303"],
                                ["K699",  "K699"],
                                ["K700",  "K700"],
                                ["S288C",  "S288C"],
                                ["1278",  "*1278*"],
                                ["EG123",  "EG123"],
                                ["DF5",  "DF5"],
                                ["SIGMA",  "Sigma"],
                                ["UNKNOWN",  "Don't know"],
                                ["BY7092",  "BY7092"],
                                ["BY5565",  "BY5565"],
                                ["BY4741",  "BY4741"]
                                    ],
                        "CIR" : [
                                ["CIR_PLUS",  "cir+"],
                                ["CIR_DEG",  "cir�"],
                                    ],
                        "GAL" : [
                                ["PLUS",  "Plus"],
                                ["PLUS_PLUS",  "Plus/Plus"],
                                ["GAL1",  "gal1"],
                                ["GAL1_GAL1",  "gal1/gal1"],      
                                ["GAL2",  "gal2"],                                 
                                ["GAL2_GAL2",  "gal2/gal2"],                                                         
                                    ],
                        "MAT" : [
                                ["AT",  "@"],
                                ["A",  "a"],
                                ["ALPHA",  "alpha"],
                                ["DIPLOID",  "diploid"],      
                                ["UNKNOWN",  "unknown"]                                                      
                                    ],
                        "OLIGO_ORGANISM" : [
                                ["BMV",  "BMV"],
                                ["HUMAN",  "human"],
                                ["MOUSE",  "mouse"],
                                ["RAT",  "rat"],      
                                ["XENOPUS",  "xenopus"],
                                ["DROSOPHILA",  "drosophila"],
                                ["YEAST",  "yeast"],
                                ["ECOLI",  "E.coli"],
                                ["SYNTHETIC",  "synthetic"],
                                ["HIV1",  "HIV-1"],
                                ["CELEGANS",  "C.elegans"],
                                ["MYCOPLASMA",  "mycoplasma"]
                                    ],
                        "OLIGO_GRADE" : [
                                ["DESALTED",  "desalted"],
                                ["HPLC",  "hplc"],
                                ["PURITY",  "purity"],
                                ["UNKNOWN",  "?"]      
                                    ],     
                        "PRIMER_POSITION" : [
                                ["FORWARD",  "forward"],
                                ["REVERSE",  "reverse"]
                                    ],  
                        "OLIGO_COMPANY" : [
                                ["MWG",  "MWG"],
                                ["BIG",  "BIG"],
                                ["PHARMACIA",  "Pharmacia"],
                                ["IGLOI",  "Igloi"],      
                                ["INVITROGEN",  "invitrogen"],
                                ["MICROSYNTH",  "microsynth"]                                                     
                                    ],                                       
                        "OLIGO_USAGE" : [
                                ["PCR",  "pcr"],
                                ["SEQUENCING",  "sequencing"],
                                ["HYBRIDIZE",  "hybridize"],
                                ["MUTAGENESIS",  "mutagenesis"],      
                                ["RT-PCR",  "Real-Time PCR"]
                                    ],
                        "RESTRICTION" : [
                                ["AATII",  "AatII"],
                                ["ACCI",  "AccI"],
                                ["ACII",  "AciI"],
                                ["AFLII",  "AflII"],
                                ["AFLIII",  "AflIII"],
                                ["AGEI",  "AgeI"],
                                ["ALUI",  "AluI"],
                                ["ALWI",  "AlwI"],
                                ["ALWNI",  "AlwNI"],
                                ["APAI",  "ApaI"],
                                ["APALI",  "ApaLI"],
                                ["APOI",  "ApoI"],
                                ["ASCI",  "AscI"],
                                ["ASEI",  "AseI"],
                                ["AVAI",  "AvaI"],
                                ["AVAII",  "AvaII"],
                                ["AVRII",  "AvrII"],
                                ["BAMHI",  "BamHI"],
                                ["BANI",  "BanI"],
                                ["BANII",  "BanII"],
                                ["BBSI",  "BbsI"],
                                ["BBVI",  "BbvI"],
                                ["BCGI-1",  "BcgI-1"],
                                ["BCGI-2",  "BcgI-2"],
                                ["BCLI",  "BclI"],
                                ["BFAI",  "BfaI"],
                                ["BGLI",  "BglI"],
                                ["BGLII",  "BglII"],
                                ["BLPI",  "BlpI"],
                                ["BPMI",  "BpmI"],
                                ["BSAAI",  "BsaAI"],
                                ["BSABI",  "BsaBI"],
                                ["BSAHI",  "BsaHI"],
                                ["BSAI",  "BsaI"],
                                ["BSAJI",  "BsaJI"],
                                ["BSAWI",  "BsaWI"],
                                ["BSERI",  "BseRI"],
                                ["BSGI",  "BsgI"],
                                ["BSIEI",  "BsiEI"],
                                ["BSIHKAI",  "BsiHKAI"],
                                ["BSIWI",  "BsiWI"],
                                ["BSLI",  "BslI"],
                                ["BSMAI",  "BsmAI"],
                                ["BSMBI",  "BsmBI"],
                                ["BSMFI",  "BsmFI"],
                                ["BSMI",  "BsmI"],
                                ["BSOFI",  "BsoFI"],
                                ["BSP1286I",  "Bsp1286I"],
                                ["BSPEI",  "BspEI"],
                                ["BSPHI",  "BspHI"],
                                ["BSPMI",  "BspMI"],
                                ["BSRBI",  "BsrBI"],
                                ["BSRDI",  "BsrDI"],
                                ["BSRFI",  "BsrFI"],
                                ["BSRGI",  "BsrGI"],
                                ["BSRI",  "BsrI"],
                                ["BSSHII",  "BssHII"],
                                ["BST1107I",  "Bst1107I"],
                                ["BSTBI",  "BstBI"],
                                ["BSTEII",  "BstEII"],
                                ["BSTNI",  "BstNI"],
                                ["BSTUI",  "BstUI"],
                                ["BSTXI",  "BstXI"],
                                ["BSTYI",  "BstYI"],
                                ["BSU36I",  "Bsu36I"],
                                ["CAC8I",  "Cac8I"],
                                ["CLAI",  "ClaI"],
                                ["CVIJI",  "CviJI"],
                                ["DDEI",  "DdeI"],
                                ["DPNI",  "DpnI"],
                                ["DRAI",  "DraI"],
                                ["DRAIII",  "DraIII"],
                                ["DRDI",  "DrdI"],
                                ["DSAI",  "DsaI"],
                                ["EAEI",  "EaeI"],
                                ["EAGI",  "EagI"],
                                ["EAM1105I",  "Eam1105I"],
                                ["EARI",  "EarI"],
                                ["ECO47III",  "Eco47III"],
                                ["ECO57I",  "Eco57I"],
                                ["ECONI",  "EcoNI"],
                                ["ECOO109I",  "EcoO109I"],
                                ["ECORI",  "EcoRI"],
                                ["ECORV",  "EcoRV"],
                                ["FOKI",  "FokI"],
                                ["FSEI",  "FseI"],
                                ["FSPI",  "FspI"],
                                ["HAEII",  "HaeII"],
                                ["HAEIII",  "HaeIII"],
                                ["HGAI",  "HgaI"],
                                ["HHAI",  "HhaI"],
                                ["HINCII",  "HincII"],
                                ["HINDIII",  "HindIII"],
                                ["HINFI",  "HinfI"],
                                ["HPAI",  "HpaI"],
                                ["HPAII",  "HpaII"],
                                ["HPHI",  "HphI"],
                                ["KPNI",  "KpnI"],
                                ["MAEII",  "MaeII"],
                                ["MAEIII",  "MaeIII"],
                                ["MBOI",  "MboI"],
                                ["MBOII",  "MboII"],
                                ["MLUI",  "MluI"],
                                ["MNLI",  "MnlI"],
                                ["MSCI",  "MscI"],
                                ["MSEI",  "MseI"],
                                ["MSLI",  "MslI"],
                                ["MSPA1I",  "MspA1I"],
                                ["MUNI",  "MunI"],
                                ["MWOI",  "MwoI"],
                                ["NAEI",  "NaeI"],
                                ["NARI",  "NarI"],
                                ["NCII",  "NciI"],
                                ["NCOI",  "NcoI"],
                                ["NDEI",  "NdeI"],
                                ["NHEI",  "NheI"],
                                ["NLAIII",  "NlaIII"],
                                ["NLAIV",  "NlaIV"],
                                ["NOTI",  "NotI"],
                                ["NRUI",  "NruI"],
                                ["NSII",  "NsiI"],
                                ["NSPI",  "NspI"],
                                ["PACI",  "PacI"],
                                ["PFLMI",  "PflMI"],
                                ["PLEI",  "PleI"],
                                ["PMEI",  "PmeI"],
                                ["PMLI",  "PmlI"],
                                ["PPUMI",  "PpuMI"],
                                ["PSHAI",  "PshAI"],
                                ["PSP1406I",  "Psp1406I"],
                                ["PSTI",  "PstI"],
                                ["PVUI",  "PvuI"],
                                ["PVUII",  "PvuII"],
                                ["RSAI",  "RsaI"],
                                ["RSRII",  "RsrII"],
                                ["SACI",  "SacI"],
                                ["SACII",  "SacII"],
                                ["SALI",  "SalI"],
                                ["SAPI",  "SapI"],
                                ["SAU96I",  "Sau96I"],
                                ["SCAI",  "ScaI"],
                                ["SCRFI",  "ScrFI"],
                                ["SEXAI",  "SexAI"],
                                ["SFANI",  "SfaNI"],
                                ["SFCI",  "SfcI"],
                                ["SFII",  "SfiI"],
                                ["SGFI",  "SgfI"],
                                ["SGRAI",  "SgrAI"],
                                ["SMAI",  "SmaI"],
                                ["SNABI",  "SnaBI"],
                                ["SPEI",  "SpeI"],
                                ["SPHI",  "SphI"],
                                ["SRFI",  "SrfI"],
                                ["SSE8387I",  "Sse8387I"],
                                ["SSPI",  "SspI"],
                                ["STUI",  "StuI"],
                                ["STYI",  "StyI"],
                                ["SWAI",  "SwaI"],
                                ["TAQI",  "TaqI"],
                                ["TFII",  "TfiI"],
                                ["TSP45I",  "Tsp45I"],
                                ["TSP509I",  "Tsp509I"],
                                ["TTH111I",  "Tth111I"],
                                ["XBAI",  "XbaI"],
                                ["XCMI",  "XcmI"],
                                ["XHOI",  "XhoI"],
                                ["XMNI",  "XmnI"],
                                ["SACI_NHEI",  "sacI NheI"],
                                ["XMAI",  "XmaI"],
                                ["BAMHI",  "BamHI"],
                                ["CLAI",  "ClaI"],
                                ["PACI",  "PacI"],
                                ["NOTI",  "NotI"],
                                ["SALI",  "SalI"],
                                ["XHOI",  "XhoI"],
                                ["NONE",  "none"]
                            ],
                        "BACKBONE" : [
                                ["PCDNA3",  "pCDNA3"],
                                ["PABES-NEO2000",  "pABES-neo 2000"],    
                                ["PUC19",  "pUC 19"],                                
                                ["PMX-1",  "pMX-1"],
                                ["PRMHA-3",  "pRmHa-3"]
                            ],
                        "BACTERIAL_HOST" : [
                                ["DH10B",  "DH10B"],
                                ["JM110",  "JM110"],    
                                ["BL21",  "BL21"],                                
                                ["DH5A",  "DH5a"],
                                ["PB3",  "PB3"],
                                ["DB31",  "DB3.1"],
                                ["CCDB_SURVIVAL",  "ccdB survival"]
                            ],  
                        "BIOSAFETY_LEVEL" : [
                                ["S1",  "S1"],
                                ["S2",  "S2"],    
                                ["S3",  "S3"]        
                            ],
                        "SELECTION_IN_BACTERIA" : [
                                ["AMPICILLIN",  "Ampicillin"],
                                ["KANAMYCIN",  "Kanamycin"],    
                                ["SPECTINOMCIN",  "Spectinomcin"],
                                ["UNKNOWN",  "Unknown"]                                        
                            ],
                        "SELECTION_IN_EUKARYOTES" : [
                                ["G418_NEO",  "G418/neo"],
                                ["MPA",  "MPA"],    
                                ["HYGROMYCIN",  "Hygromycin"]                                 
                            ],                            
                        "SOURCE_OF_REPLICON" : [
                                ["CMV",  "CMV"]                                   
                            ],
                        "PLASMID_ORGANISM" : [
                                ["HUMAN",  "human"],
                                ["MOUSE",  "mouse"],
                                ["RAT",  "rat"],
                                ["XENOPUS",  "xenopus"],
                                ["DROSOPHILA",  "drosophila"],
                                ["YEAST",  "yeast"],
                                ["ECOLI",  "E.coli"],
                                ["SYNTHETIC",  "synthetic"]
                            ],
                        "PROMOTER" : [
                                ["ENDOGENOUS",  "endogenous"],
                                ["GAL1",  "gal1"],
                                ["GALL",  "galL"],
                                ["GALS",  "galS"],
                                ["TET",  "tet"],
                                ["ADH",  "adh"],
                                ["CYC",  "cyc"],
                                ["GPD",  "gpd"],
                                ["DASH",  "\"-\""],
                                ["CMV",  "cmv"],
                                ["SV40",  "SV40"],
                                ["TET_ON",  "tet on"],
                                ["TET_OFF",  "tet off"],
                                ["RIM1",  "rim1"]
                            ],
                        "EXON_OR_THREE_PRIME" : [
                                ["EXON",  "exon"],
                                ["3P",  "3'"],
                                ["5P",  "5'"]
                            ], 
                        "SIRNA_SPECIES" : [
                                ["HUMAN",  "Human"],
                                ["MOUSE",  "Mouse'"],
                            ], 
                        "SIRNA_COMPANY" : [
                                ["AMBION",  "Ambion"],
                                ["DHARMACON",  "Dharmacon'"],
                                ["INVITORGEN",  "Invitrogen'"],
                                ["MICROSYNTH",  "Microsynth'"],
                                ["QIAGEN",  "Qiagen'"],
                                ["GIFT",  "Gift'"]
                            ], 
                       "SIRNA_FREEZER_LOCATION" : [
                                ["BIGLABFREEZER",  "BigLab freezer"],
                                ["SMALLLAB_BIGFREEZER",  "SmallLab Big freezer'"],
                                ["FREEZER_G17",  "Freezer G17'"],
                                ["G93-FRANK",  "G9.3--Frank'"],
                                ["FREEZER-G17_BOX_NATHALIE",  "Freezer G17 Box Nathalie'"],
                                ["BOX-THIBAULT-BIGFREEZER-SMALLLAB",  "Box thibault Big freezer small lab'"],
                                ["BOX-NATHALIE",  "Box Nathalie'"]
                            ], 
                       "TRANSFECTION_AGENT" : [
                                ["FUGENE",  "Fugene"],
                                ["LIPOFECTAMINE",  "Lipofectamine'"],
                                ["OLIGOFECTAMINE",  "Oligofectamine'"],
                                ["RNAIMAX",  "RNAimax'"]
                            ],                             
                        "FREEZER" : [
                                ["G9_FRIDGE-1",  "G9 Fridge 1"],
                                ["G9_FRIDGE-2",  "G9 Fridge 2"],
                                ["G9_FREEZER-A",  "-20C Small Peter Lab"],
                                ["G9_FREEZER-B",  "G9 Freezer B"],
                                ["G9_FREEZER-C",  "G9 Freezer C"],
                                ["G10_FREEZER-D",  "G10 Freezer D"],
                                ["G10_FREEZER-E",  "G10 Freezer E"],
                                ["G10_FREEZER-F",  "G10 Freezer F"],
                                ["G10_FREEZER-G",  "G10 Freezer G"],
                                ["G10_FREEZER-H",  "G10 Freezer H"],
                                ["G10_FREEZER-I",  "G10 Freezer I"],
                                ["G10_FRIDGE-3",  "+4C Big Peter Lab"],
                                ["G10_FRIDGE-4",  "G10 Fridge 4"],
                                ["G10_FRIDGE-5",  "G10 Fridge 5"],
                                ["G10_FRIDGE-6",  "G10 Fridge 6"],
                                ["G10_FRIDGE-7",  "G10 Fridge 7"],
                                ["G11_FRIDGE-8",  "G10 Fridge 8"],
                                ["G14_FREEZER-J",  "G14 Freezer J"],
                                ["G14_FREEZER-K",  "G14 Freezer K"],
                                ["G14_FREEZER-L",  "G14 Freezer L"],
                                ["G14_FREEZER-M",  "G14 Freezer M"],
                                ["G14_FRIDGE-9",  "G14 Fridge 9"],
                                ["G14_FRIDGE-10",  "G14 Fridge 10"],
                                ["G17_FRIDGE-11",  "G17 Fridge 11"],
                                ["G17_FRIDGE-12",  "G17 Fridge 12"],
                                ["G17_FREEZER-N",  "G17 Freezer N"],
                                ["USER_BENCH-20",  "Bench -20�C"],
                                ["USER_BENCH-80",  "Bench -80�C"],
                                ["USER_BENCH-RT",  "Bench RT"],
                                ["USER_BENCH",  "Bench"]
                                    ]
                          }