/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.common.api.client;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.api.IRpcService;
import ch.systemsx.cisd.common.spring.HttpInvokerUtils;
import ch.systemsx.cisd.common.ssl.SslCertificateHelper;
import ch.systemsx.cisd.openbis.common.api.client.IServicePinger;
import java.io.File;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.springframework.remoting.RemoteAccessException;

public class ServiceFinder {
    public static final int SERVER_TIMEOUT_IN_MINUTES = 15;
    private static final long SERVER_TIMEOUT = 900000L;
    private final String applicationName;
    private final String urlServiceSuffix;

    public ServiceFinder(String applicationName, String urlServiceSuffix) {
        this.applicationName = applicationName;
        this.urlServiceSuffix = urlServiceSuffix.startsWith("/") ? urlServiceSuffix : "/" + urlServiceSuffix;
    }

    public <S extends IRpcService> S createService(Class<S> serviceInterface, String serverUrl) {
        return this.createService(serviceInterface, serverUrl, 900000L);
    }

    public <S extends IRpcService> S createService(Class<S> serviceInterface, String serverUrl, long timeoutInMillis) {
        return (S)((IRpcService)this.createService(serviceInterface, serverUrl, new IServicePinger<S>(){

            @Override
            public void ping(S service) {
                service.getMajorVersion();
            }
        }, timeoutInMillis));
    }

    public <S> S createService(Class<S> serviceInterface, String serverUrl, IServicePinger<S> servicePinger) {
        return this.createService(serviceInterface, serverUrl, servicePinger, 900000L);
    }

    public <S> S createService(Class<S> serviceInterface, String serverUrl, IServicePinger<S> servicePinger, long timeoutInMillis) {
        ServiceWithUrl<S> serviceWithUrl = this.createServiceWithUrl(serviceInterface, serverUrl, servicePinger, timeoutInMillis);
        return serviceWithUrl.getService();
    }

    public <S> String createServiceUrl(Class<S> serviceInterface, String serverUrl, IServicePinger<S> servicePinger, long timeoutInMillis) {
        ServiceWithUrl<S> serviceWithUrl = this.createServiceWithUrl(serviceInterface, serverUrl, servicePinger, timeoutInMillis);
        return serviceWithUrl.getUrl();
    }

    private <S> ServiceWithUrl<S> createServiceWithUrl(Class<S> serviceInterface, String serverUrl, IServicePinger<S> servicePinger, long timeoutInMillis) {
        String usedServerUrl = this.computeServerUrlWithDoubledApplicationName(serverUrl);
        S service = this.createServiceStubStoringCertificateIfNecessary(serviceInterface, timeoutInMillis, usedServerUrl);
        if (ServiceFinder.canConnectToService(service, servicePinger)) {
            return new ServiceWithUrl<S>(usedServerUrl, service);
        }
        usedServerUrl = this.computeServerUrl(serverUrl);
        service = this.createServiceStubStoringCertificateIfNecessary(serviceInterface, timeoutInMillis, usedServerUrl);
        if (ServiceFinder.canConnectToService(service, servicePinger)) {
            return new ServiceWithUrl<S>(usedServerUrl, service);
        }
        usedServerUrl = serverUrl;
        service = this.createServiceStubStoringCertificateIfNecessary(serviceInterface, timeoutInMillis, usedServerUrl);
        servicePinger.ping(service);
        return new ServiceWithUrl<S>(usedServerUrl, service);
    }

    private <S> S createServiceStubStoringCertificateIfNecessary(Class<S> serviceInterface, long timeoutInMillis, String usedServerUrl) {
        this.storeCertificateIfNecessary(usedServerUrl);
        S service = this.createServiceStub(serviceInterface, String.valueOf(usedServerUrl) + this.urlServiceSuffix, timeoutInMillis);
        return service;
    }

    private void storeCertificateIfNecessary(String usedServerUrl) {
        if (this.shouldAcceptInvalidCertificates()) {
            try {
                new SslCertificateHelper(usedServerUrl, this.getKeystoreFile(), "bis").setUpKeyStore();
            }
            catch (Throwable throwable) {}
        }
    }

    private boolean shouldAcceptInvalidCertificates() {
        boolean forced;
        String forceProperty = System.getProperty("force-accept-ssl-certificate");
        boolean bl = forced = forceProperty != null && !forceProperty.equalsIgnoreCase("false");
        return forced || this.isRunningUnderWebstart();
    }

    private boolean isRunningUnderWebstart() {
        return System.getProperty("javawebstart.version") != null;
    }

    @Private
    <S> S createServiceStub(Class<S> serviceClass, String serverUrl, long timeoutInMillis) {
        return HttpInvokerUtils.createServiceStub(serviceClass, serverUrl, timeoutInMillis);
    }

    private static <S> boolean canConnectToService(S service, IServicePinger<S> servicePinger) {
        boolean result = true;
        try {
            servicePinger.ping(service);
        }
        catch (RemoteAccessException rae) {
            Throwable cause = rae.getCause();
            if (cause instanceof SocketTimeoutException || cause instanceof SocketException) {
                throw rae;
            }
            result = false;
        }
        catch (Exception exception) {
            result = false;
        }
        return result;
    }

    private String computeServerUrlWithDoubledApplicationName(String serverUrl) {
        if (serverUrl.endsWith("/" + this.applicationName + "/" + this.applicationName)) {
            return serverUrl;
        }
        if (serverUrl.endsWith("/" + this.applicationName)) {
            return String.valueOf(serverUrl) + "/" + this.applicationName;
        }
        String myServerUrl = serverUrl;
        if (!serverUrl.endsWith("/")) {
            myServerUrl = String.valueOf(myServerUrl) + "/";
        }
        return String.valueOf(myServerUrl) + this.applicationName + "/" + this.applicationName;
    }

    private String computeServerUrl(String serverUrl) {
        if (serverUrl.endsWith("/" + this.applicationName + "/" + this.applicationName)) {
            return serverUrl.substring(0, serverUrl.length() - (1 + this.applicationName.length()));
        }
        if (serverUrl.endsWith("/" + this.applicationName)) {
            return serverUrl;
        }
        String myServerUrl = serverUrl;
        if (!serverUrl.endsWith("/")) {
            myServerUrl = String.valueOf(myServerUrl) + "/";
        }
        return String.valueOf(myServerUrl) + this.applicationName;
    }

    private File getKeystoreFile() {
        return new File(this.getConfigDirectory(), "keystore");
    }

    private File getConfigDirectory() {
        File configDir;
        String homeDir = System.getProperty("dss.root");
        if (homeDir != null) {
            configDir = new File(homeDir, "etc");
        } else {
            homeDir = System.getProperty("user.home");
            configDir = new File(homeDir, ".bis");
        }
        configDir.mkdirs();
        return configDir;
    }

    private class ServiceWithUrl<S> {
        private String url;
        private S service;

        public ServiceWithUrl(String url, S service) {
            this.url = String.valueOf(url) + ServiceFinder.this.urlServiceSuffix;
            this.service = service;
        }

        public String getUrl() {
            return this.url;
        }

        public S getService() {
            return this.service;
        }
    }
}

