/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.bsse.cisd.plasmid.dss;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.etlserver.FileTypeExtractor;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;

class DataSetTypeOracle {
    public static final String DATASET_TYPES_NAME = "dataset-types";
    private static Map<String, DataSetTypeInfo> typeInfoByExtension = new HashMap<String, DataSetTypeInfo>();

    DataSetTypeOracle() {
    }

    private static DataSetTypeInfo getType(String typeName) {
        try {
            return DataSetTypeInfo.valueOf(typeName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ConfigurationFailureException.fromTemplate((String)"Wrong dataset type '%s'. Expected one of: '%s'.", (Object[])new Object[]{typeName, Arrays.toString((Object[])DataSetTypeInfo.values())});
        }
    }

    static void initializeMapping(Properties properties) {
        Map map = FileTypeExtractor.createTypeByFileExtensionMap((Properties)properties, (String)DATASET_TYPES_NAME);
        for (Map.Entry entry : map.entrySet()) {
            typeInfoByExtension.put((String)entry.getKey(), DataSetTypeOracle.getType((String)entry.getValue()));
        }
    }

    static DataSetTypeInfo extractDataSetTypeInfo(File incomingDataSetPath) throws UserFailureException {
        if (incomingDataSetPath.isDirectory()) {
            return DataSetTypeInfo.UNKNOWN;
        }
        String fileName = incomingDataSetPath.getName().toLowerCase();
        String fileExtension = FilenameUtils.getExtension((String)fileName);
        DataSetTypeInfo result = DataSetTypeOracle.tryGetMappedType(fileExtension);
        return result == null ? DataSetTypeInfo.VERIFICATION : result;
    }

    private static DataSetTypeInfo tryGetMappedType(String fileExtension) {
        return typeInfoByExtension.get(DataSetTypeOracle.normalizeExtension(fileExtension));
    }

    private static String normalizeExtension(String extension) {
        return extension.toUpperCase();
    }

    static enum DataSetTypeInfo {
        SEQ_FILE(false),
        RAW_DATA(true),
        VERIFICATION(true),
        UNKNOWN(true);

        private final boolean measured;

        private DataSetTypeInfo(boolean measured) {
            this.measured = measured;
        }

        public String getDataSetTypeCode() {
            return this.name();
        }

        public boolean isMeasured() {
            return this.measured;
        }
    }
}

