/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.ICodeHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IEntityTypeHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IExperimentHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IMaterialPropertiesHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IModificationDateHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IModifierHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IParentChildrenHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IPermIdHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IPropertiesHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IRegistrationDateHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IRegistratorHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.ISampleHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.ITagsHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.DataSetKind;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.DataSetType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.LinkedData;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.PhysicalData;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.fetchoptions.DataSetFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.DataSetPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.datastore.DataStore;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.Experiment;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.history.HistoryEntry;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.Material;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.Person;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.Sample;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.tag.Tag;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.NotFetchedException;
import ch.systemsx.cisd.base.annotation.JsonObject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@JsonObject(value="as.dto.dataset.DataSet")
public class DataSet
implements Serializable,
ICodeHolder,
IEntityTypeHolder,
IExperimentHolder,
IMaterialPropertiesHolder,
IModificationDateHolder,
IModifierHolder,
IParentChildrenHolder<DataSet>,
IPermIdHolder,
IPropertiesHolder,
IRegistrationDateHolder,
IRegistratorHolder,
ISampleHolder,
ITagsHolder {
    private static final long serialVersionUID = 1L;
    @JsonProperty
    private DataSetFetchOptions fetchOptions;
    @JsonProperty
    private DataSetPermId permId;
    @JsonProperty
    private String code;
    @JsonProperty
    private DataSetType type;
    @JsonProperty
    private DataSetKind kind;
    @JsonProperty
    private DataStore dataStore;
    @JsonProperty
    private Boolean measured;
    @JsonProperty
    private Boolean postRegistered;
    @JsonProperty
    private PhysicalData physicalData;
    @JsonProperty
    private LinkedData linkedData;
    @JsonProperty
    private Experiment experiment;
    @JsonProperty
    private Sample sample;
    @JsonProperty
    private Map<String, String> properties;
    @JsonProperty
    private Map<String, Material> materialProperties;
    @JsonProperty
    private List<DataSet> parents;
    @JsonProperty
    private List<DataSet> children;
    @JsonProperty
    private List<DataSet> containers;
    @JsonProperty
    private List<DataSet> components;
    @JsonProperty
    private Set<Tag> tags;
    @JsonProperty
    private List<HistoryEntry> history;
    @JsonProperty
    private Date modificationDate;
    @JsonProperty
    private Person modifier;
    @JsonProperty
    private Date registrationDate;
    @JsonProperty
    private Person registrator;
    @JsonProperty
    private String dataProducer;
    @JsonProperty
    private Date dataProductionDate;
    @JsonProperty
    private Date accessDate;

    @JsonIgnore
    public DataSetFetchOptions getFetchOptions() {
        return this.fetchOptions;
    }

    public void setFetchOptions(DataSetFetchOptions fetchOptions) {
        this.fetchOptions = fetchOptions;
    }

    @Override
    @JsonIgnore
    public DataSetPermId getPermId() {
        return this.permId;
    }

    public void setPermId(DataSetPermId permId) {
        this.permId = permId;
    }

    @Override
    @JsonIgnore
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    @JsonIgnore
    public DataSetType getType() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasType()) {
            return this.type;
        }
        throw new NotFetchedException("Data Set type has not been fetched.");
    }

    public void setType(DataSetType type) {
        this.type = type;
    }

    @JsonIgnore
    public DataSetKind getKind() {
        return this.kind;
    }

    public void setKind(DataSetKind kind) {
        this.kind = kind;
    }

    @JsonIgnore
    public DataStore getDataStore() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasDataStore()) {
            return this.dataStore;
        }
        throw new NotFetchedException("Data store has not been fetched.");
    }

    public void setDataStore(DataStore dataStore) {
        this.dataStore = dataStore;
    }

    @JsonIgnore
    public Boolean isMeasured() {
        return this.measured;
    }

    public void setMeasured(Boolean measured) {
        this.measured = measured;
    }

    @JsonIgnore
    public Boolean isPostRegistered() {
        return this.postRegistered;
    }

    public void setPostRegistered(Boolean postRegistered) {
        this.postRegistered = postRegistered;
    }

    @JsonIgnore
    public PhysicalData getPhysicalData() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasPhysicalData()) {
            return this.physicalData;
        }
        throw new NotFetchedException("Physical data has not been fetched.");
    }

    public void setPhysicalData(PhysicalData physicalData) {
        this.physicalData = physicalData;
    }

    @JsonIgnore
    public LinkedData getLinkedData() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasLinkedData()) {
            return this.linkedData;
        }
        throw new NotFetchedException("Linked data has not been fetched.");
    }

    public void setLinkedData(LinkedData linkedData) {
        this.linkedData = linkedData;
    }

    @Override
    @JsonIgnore
    public Experiment getExperiment() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasExperiment()) {
            return this.experiment;
        }
        throw new NotFetchedException("Experiment has not been fetched.");
    }

    public void setExperiment(Experiment experiment) {
        this.experiment = experiment;
    }

    @Override
    @JsonIgnore
    public Sample getSample() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasSample()) {
            return this.sample;
        }
        throw new NotFetchedException("Sample has not been fetched.");
    }

    public void setSample(Sample sample) {
        this.sample = sample;
    }

    @Override
    @JsonIgnore
    public Map<String, String> getProperties() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasProperties()) {
            return this.properties;
        }
        throw new NotFetchedException("Properties have not been fetched.");
    }

    @Override
    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    @Override
    @JsonIgnore
    public Map<String, Material> getMaterialProperties() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasMaterialProperties()) {
            return this.materialProperties;
        }
        throw new NotFetchedException("Material Properties have not been fetched.");
    }

    @Override
    public void setMaterialProperties(Map<String, Material> materialProperties) {
        this.materialProperties = materialProperties;
    }

    @Override
    @JsonIgnore
    public List<DataSet> getParents() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasParents()) {
            return this.parents;
        }
        throw new NotFetchedException("Parents have not been fetched.");
    }

    public void setParents(List<DataSet> parents) {
        this.parents = parents;
    }

    @Override
    @JsonIgnore
    public List<DataSet> getChildren() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasChildren()) {
            return this.children;
        }
        throw new NotFetchedException("Children have not been fetched.");
    }

    public void setChildren(List<DataSet> children) {
        this.children = children;
    }

    @JsonIgnore
    public List<DataSet> getContainers() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasContainers()) {
            return this.containers;
        }
        throw new NotFetchedException("Container data sets have not been fetched.");
    }

    public void setContainers(List<DataSet> containers) {
        this.containers = containers;
    }

    @JsonIgnore
    public List<DataSet> getComponents() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasComponents()) {
            return this.components;
        }
        throw new NotFetchedException("Component data sets have not been fetched.");
    }

    public void setComponents(List<DataSet> components) {
        this.components = components;
    }

    @Override
    @JsonIgnore
    public Set<Tag> getTags() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasTags()) {
            return this.tags;
        }
        throw new NotFetchedException("Tags have not been fetched.");
    }

    public void setTags(Set<Tag> tags) {
        this.tags = tags;
    }

    @JsonIgnore
    public List<HistoryEntry> getHistory() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasHistory()) {
            return this.history;
        }
        throw new NotFetchedException("History have not been fetched.");
    }

    public void setHistory(List<HistoryEntry> history) {
        this.history = history;
    }

    @Override
    @JsonIgnore
    public Date getModificationDate() {
        return this.modificationDate;
    }

    public void setModificationDate(Date modificationDate) {
        this.modificationDate = modificationDate;
    }

    @Override
    @JsonIgnore
    public Person getModifier() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasModifier()) {
            return this.modifier;
        }
        throw new NotFetchedException("Modifier has not been fetched.");
    }

    public void setModifier(Person modifier) {
        this.modifier = modifier;
    }

    @Override
    @JsonIgnore
    public Date getRegistrationDate() {
        return this.registrationDate;
    }

    public void setRegistrationDate(Date registrationDate) {
        this.registrationDate = registrationDate;
    }

    @Override
    @JsonIgnore
    public Person getRegistrator() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasRegistrator()) {
            return this.registrator;
        }
        throw new NotFetchedException("Registrator has not been fetched.");
    }

    public void setRegistrator(Person registrator) {
        this.registrator = registrator;
    }

    @JsonIgnore
    public String getDataProducer() {
        return this.dataProducer;
    }

    public void setDataProducer(String dataProducer) {
        this.dataProducer = dataProducer;
    }

    @JsonIgnore
    public Date getDataProductionDate() {
        return this.dataProductionDate;
    }

    public void setDataProductionDate(Date dataProductionDate) {
        this.dataProductionDate = dataProductionDate;
    }

    @JsonIgnore
    public Date getAccessDate() {
        return this.accessDate;
    }

    public void setAccessDate(Date accessDate) {
        this.accessDate = accessDate;
    }

    @Override
    public String getProperty(String propertyName) {
        return this.getProperties() != null ? this.getProperties().get(propertyName) : null;
    }

    @Override
    public void setProperty(String propertyName, String propertyValue) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(propertyName, propertyValue);
    }

    @Override
    public Material getMaterialProperty(String propertyName) {
        return this.getMaterialProperties() != null ? this.getMaterialProperties().get(propertyName) : null;
    }

    @Override
    public void setMaterialProperty(String propertyName, Material propertyValue) {
        if (this.materialProperties == null) {
            this.materialProperties = new HashMap<String, Material>();
        }
        this.materialProperties.put(propertyName, propertyValue);
    }

    public String toString() {
        return "DataSet " + this.code;
    }
}

