/*
 * Decompiled with CFR 0.152.
 */
package com.filemaker.jdbc1;

import com.filemaker.jdbc.BaseConnection;
import com.filemaker.jdbc.BaseResultSet;
import com.filemaker.jdbc.BaseStatement;
import com.filemaker.jdbc.Driver;
import com.filemaker.jdbc.Encoding;
import com.filemaker.jdbc.FMAutoCommitRequest;
import com.filemaker.jdbc.FMConnectionResponse;
import com.filemaker.jdbc.FMDisconnectRequest;
import com.filemaker.jdbc.FMErrorResponse;
import com.filemaker.jdbc.FMLoginRequest;
import com.filemaker.jdbc.FMLoginResponse;
import com.filemaker.jdbc.FMSQLException;
import com.filemaker.jdbc.FMStream;
import com.filemaker.jdbc.FMSuccessResponse;
import com.filemaker.jdbc.FMTransactionRequest;
import com.filemaker.jdbc.FM_API;
import com.filemaker.jdbc.MessageBlock;
import com.filemaker.jdbc.MessageBlockBytes;
import com.filemaker.jdbc.ProtocolMessage;
import java.io.IOException;
import java.net.ConnectException;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;

public abstract class CommonJ1Connection
implements BaseConnection {
    private FMStream fmStream;
    protected String server;
    protected int portNumber;
    protected String userID;
    protected String fmDatabase;
    protected boolean fmStatus;
    protected String compatible;
    protected boolean useSSL;
    private Encoding encoding = Encoding.defaultEncoding();
    private String dbVersionNumber;
    public boolean CONNECTION_OK = true;
    public boolean CONNECTION_BAD = false;
    public boolean autoCommit = true;
    public boolean readOnly = false;
    public Driver this_driver;
    private String this_url;
    private String cursor = null;
    public SQLWarning firstWarning = null;
    private int isolationLevel = 2;
    int lastMessage = 0;
    protected DatabaseMetaData metadata;

    public FMStream getFMStream() {
        return this.fmStream;
    }

    public abstract Statement createStatement() throws SQLException;

    public abstract DatabaseMetaData getMetaData() throws SQLException;

    public void openConnection(String string, int n, Properties properties, String string2, String string3, Driver driver) throws SQLException {
        this.firstWarning = null;
        this.this_driver = driver;
        this.this_url = string3;
        this.userID = "";
        String string4 = "";
        this.server = string;
        this.portNumber = n;
        this.fmDatabase = string2;
        Object object = properties.propertyNames();
        while (object.hasMoreElements()) {
            String string5 = object.nextElement().toString();
            if (string5.compareToIgnoreCase("User") == 0) {
                this.userID = properties.getProperty(string5);
                continue;
            }
            if (string5.compareToIgnoreCase("Password") == 0) {
                string4 = properties.getProperty(string5);
                continue;
            }
            if (string5.compareToIgnoreCase("ServerName") == 0) {
                this.server = properties.getProperty(string5);
                continue;
            }
            if (string5.compareToIgnoreCase("ServerDataSource") != 0) continue;
            this.fmDatabase = properties.getProperty(string5);
        }
        if (this.userID.length() == 0) {
            throw new FMSQLException("User ID must be specified", "08004");
        }
        this.fmStatus = this.CONNECTION_BAD;
        this.useSSL = false;
        object = properties.getProperty("loglevel", "0");
        int n2 = 0;
        try {
            n2 = Integer.parseInt((String)object);
            if (n2 > 2 || n2 < 1) {
                n2 = 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n2 > 0) {
            Driver.setLogLevel(n2);
            this.enableDriverManagerLogging();
        }
        if (Driver.logInfo) {
            Driver.info("dbc.openConnection(\"" + this.server + "\"," + n + ",info,\"" + this.fmDatabase + "\",\"" + string3 + "\",driver);");
        }
        if (Driver.logInfo) {
            Driver.info("//" + Driver.getVersion());
        }
        try {
            this.fmStream = new FMStream(this.server, n);
        }
        catch (ConnectException connectException) {
            throw new FMSQLException("Connection refused. Check that the host address and port are correct and that xDBC sharing is enabled on the host.", "08004");
        }
        catch (IOException iOException) {
            throw new FMSQLException(iOException.getMessage(), "08001");
        }
        catch (Exception exception) {
            throw new FMSQLException(exception.getMessage(), "08001");
        }
        try {
            String string6;
            ProtocolMessage protocolMessage;
            MessageBlockBytes messageBlockBytes = MessageBlock.getBlock(this.fmStream);
            byte[] byArray = messageBlockBytes.blockBytes;
            short s = messageBlockBytes.commandType;
            if (s == 67) {
                protocolMessage = new FMConnectionResponse(byArray);
                short s2 = ((FMConnectionResponse)protocolMessage).getProtocolVersion();
                string6 = ((FMConnectionResponse)protocolMessage).getServerVersion();
                int n3 = ((FMConnectionResponse)protocolMessage).getCapabilities();
                if (s2 < 9) {
                    throw new FMSQLException("Driver requires a more recent version of xDBC listener", "08004");
                }
            } else {
                if (s == 69) {
                    FMErrorResponse fMErrorResponse = new FMErrorResponse(byArray);
                    int n4 = fMErrorResponse.getErrorCode();
                    String string7 = fMErrorResponse.getErrorMessage();
                    throw new FMSQLException(string7, "08004");
                }
                throw new FMSQLException("Problem connecting to host", "08004");
            }
            protocolMessage = new FMLoginRequest(9, 0, 65534, "JDBC", this.fmDatabase, this.userID, string4, 1);
            protocolMessage.send(this.fmStream);
            messageBlockBytes = MessageBlock.getBlock(this.fmStream);
            byArray = messageBlockBytes.blockBytes;
            s = messageBlockBytes.commandType;
            if (s != 71) {
                if (s == 69) {
                    FMErrorResponse fMErrorResponse = new FMErrorResponse(byArray);
                    int n5 = fMErrorResponse.getErrorCode();
                    String string8 = fMErrorResponse.getErrorMessage();
                    throw new FMSQLException(string8, "08004");
                }
                throw new FMSQLException("Unexpected listener response type " + s, "08S01");
            }
            FMLoginResponse fMLoginResponse = new FMLoginResponse(byArray);
            this.dbVersionNumber = string6 = fMLoginResponse.getFileMakerVersion();
        }
        catch (Exception exception) {
            if (this.fmStream != null) {
                try {
                    this.fmStream.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            throw new FMSQLException(exception.getMessage(), "08007");
        }
        this.fmStatus = this.CONNECTION_OK;
    }

    public Driver getDriver() {
        if (Driver.logInfo) {
            Driver.info("driver = dbc.getDriver();");
        }
        return this.this_driver;
    }

    public void addWarning(String string) {
        if (Driver.logInfo) {
            Driver.info("dbc.addWarning(\"" + string + "\");");
        }
        if (this.firstWarning != null) {
            this.firstWarning.setNextWarning(new SQLWarning(string));
        } else {
            this.firstWarning = new SQLWarning(string);
        }
    }

    public BaseResultSet execSQL(String string) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("rs = dbc.execSQL(\"" + string + "\");");
        }
        Object[] objectArray = new Object[]{};
        String[] stringArray = new String[]{};
        BaseStatement baseStatement = (BaseStatement)((Object)this.createStatement());
        return FM_API.execDirect(new String[]{string}, objectArray, stringArray, baseStatement);
    }

    public void setCursorName(String string) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("dbc.setCursorName(\"" + string + "\");");
        }
        this.cursor = string;
    }

    public String getCursorName() throws SQLException {
        if (Driver.logInfo) {
            Driver.info("String cursorName = dbc.getCursorName();");
        }
        return this.cursor;
    }

    public String getURL() throws SQLException {
        if (Driver.logInfo) {
            Driver.info("String url = dbc.getURL();");
        }
        return this.this_url;
    }

    public String getUserName() throws SQLException {
        if (Driver.logInfo) {
            Driver.info("String userName = dbc.getUserName();");
        }
        return this.userID;
    }

    public Encoding getEncoding() throws SQLException {
        if (Driver.logInfo) {
            Driver.info("Encoding encoding = dbc.getEncoding();");
        }
        return this.encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        if (Driver.logInfo) {
            Driver.info("dbc.close();");
        }
        if (this.fmStream != null) {
            try {
                FMDisconnectRequest fMDisconnectRequest = new FMDisconnectRequest();
                fMDisconnectRequest.send(this.fmStream);
                this.fmStream.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.fmStream = null;
            }
        }
    }

    public String nativeSQL(String string) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("String nativeSql = dbc.nativeSQL(\"" + string + "\");");
        }
        return string;
    }

    public SQLWarning getWarnings() throws SQLException {
        if (Driver.logInfo) {
            Driver.info("SQLWarning warnings = dbc.getWarnings();");
        }
        return this.firstWarning;
    }

    public void clearWarnings() throws SQLException {
        if (Driver.logInfo) {
            Driver.info("dbc.clearWarnings();");
        }
        this.firstWarning = null;
    }

    public void setReadOnly(boolean bl) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("dbc.setReadOnly(" + bl + ");");
        }
        this.readOnly = bl;
    }

    public boolean isReadOnly() throws SQLException {
        if (Driver.logInfo) {
            Driver.info("boolean readOnly = dbc.isReadOnly();");
        }
        return this.readOnly;
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("dbc.setAutoCommit(" + bl + ");");
        }
        if (this.autoCommit == bl) {
            return;
        }
        FMAutoCommitRequest fMAutoCommitRequest = new FMAutoCommitRequest((short)(bl ? 1 : 0));
        fMAutoCommitRequest.send(this.fmStream);
        MessageBlockBytes messageBlockBytes = MessageBlock.getBlock(this.fmStream);
        byte[] byArray = messageBlockBytes.blockBytes;
        short s = messageBlockBytes.commandType;
        if (s != 83) {
            if (s == 69) {
                FMErrorResponse fMErrorResponse = new FMErrorResponse(byArray);
                int n = fMErrorResponse.getErrorCode();
                String string = fMErrorResponse.getErrorMessage();
                throw new FMSQLException(string, "HY000");
            }
            throw new FMSQLException("Unexpected listener response type " + s, "08S01");
        }
        FMSuccessResponse fMSuccessResponse = new FMSuccessResponse(byArray);
        this.autoCommit = bl;
    }

    public boolean getAutoCommit() {
        if (Driver.logInfo) {
            Driver.info("boolean autoCommit = dbc.getAutoCommit();");
        }
        return this.autoCommit;
    }

    public void commit() throws SQLException {
        if (Driver.logInfo) {
            Driver.info("dbc.commit();");
        }
        if (this.autoCommit) {
            return;
        }
        FMTransactionRequest fMTransactionRequest = new FMTransactionRequest(0);
        fMTransactionRequest.send(this.fmStream);
        MessageBlockBytes messageBlockBytes = MessageBlock.getBlock(this.fmStream);
        byte[] byArray = messageBlockBytes.blockBytes;
        short s = messageBlockBytes.commandType;
        if (s != 83) {
            if (s == 69) {
                FMErrorResponse fMErrorResponse = new FMErrorResponse(byArray);
                int n = fMErrorResponse.getErrorCode();
                String string = fMErrorResponse.getErrorMessage();
                throw new FMSQLException(string, "HY000");
            }
            throw new FMSQLException("Unexpected listener response type " + s, "08S01");
        }
        FMSuccessResponse fMSuccessResponse = new FMSuccessResponse(byArray);
    }

    public void rollback() throws SQLException {
        if (Driver.logInfo) {
            Driver.info("dbc.rollback();");
        }
        if (this.autoCommit) {
            return;
        }
        FMTransactionRequest fMTransactionRequest = new FMTransactionRequest(1);
        fMTransactionRequest.send(this.fmStream);
        MessageBlockBytes messageBlockBytes = MessageBlock.getBlock(this.fmStream);
        byte[] byArray = messageBlockBytes.blockBytes;
        short s = messageBlockBytes.commandType;
        if (s != 83) {
            if (s == 69) {
                FMErrorResponse fMErrorResponse = new FMErrorResponse(byArray);
                int n = fMErrorResponse.getErrorCode();
                String string = fMErrorResponse.getErrorMessage();
                throw new FMSQLException(string, "HY000");
            }
            throw new FMSQLException("Unexpected listener response type " + s, "08S01");
        }
        FMSuccessResponse fMSuccessResponse = new FMSuccessResponse(byArray);
    }

    public int getTransactionIsolation() throws SQLException {
        if (Driver.logInfo) {
            Driver.info("int level = dbc.getTransactionIsolation();");
        }
        return 2;
    }

    public void setTransactionIsolation(int n) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("dbc.setTransactionIsolation(" + n + ");");
        }
        this.isolationLevel = n;
    }

    public void setCatalog(String string) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("dbc.setCatalog(" + string + ");");
        }
    }

    public String getCatalog() throws SQLException {
        if (Driver.logInfo) {
            Driver.info("String catalog = dbc.getCatalog();");
        }
        return null;
    }

    public void finalize() throws Throwable {
        if (Driver.logInfo) {
            Driver.info("dbc.finalize();");
        }
        this.close();
    }

    public String getDBVersionNumber() {
        if (Driver.logInfo) {
            Driver.info("String versionNumber = dbc.getDBVersionNumber();");
        }
        return this.dbVersionNumber;
    }

    private static String extractVersionNumber(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        stringTokenizer.nextToken();
        return stringTokenizer.nextToken();
    }

    private static int integerPart(String string) {
        int n;
        int n2;
        for (n2 = 0; n2 < string.length() && !Character.isDigit(string.charAt(n2)); ++n2) {
        }
        for (n = n2; n < string.length() && Character.isDigit(string.charAt(n)); ++n) {
        }
        if (n2 == n) {
            return 0;
        }
        return Integer.parseInt(string.substring(n2, n));
    }

    public int getServerMajorVersion() {
        if (Driver.logInfo) {
            Driver.info("int majorVersion = dbc.getServerMajorVersion();");
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(this.dbVersionNumber, ".");
            return CommonJ1Connection.integerPart(stringTokenizer.nextToken());
        }
        catch (NoSuchElementException noSuchElementException) {
            return 0;
        }
    }

    public int getServerMinorVersion() {
        if (Driver.logInfo) {
            Driver.info("int minorVersion = dbc.getServerMinorVersion();");
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(this.dbVersionNumber, ".");
            stringTokenizer.nextToken();
            return CommonJ1Connection.integerPart(stringTokenizer.nextToken());
        }
        catch (NoSuchElementException noSuchElementException) {
            return 0;
        }
    }

    public int getSQLType(int n) throws SQLException {
        int n2 = 12;
        n2 = n == 1 ? 12 : (n == 2 ? 8 : (n == 3 ? 91 : (n == 4 ? 92 : (n == 5 ? 93 : (n == 6 ? -4 : (n == 7 ? 8 : 12))))));
        return n2;
    }

    public int getFMType(String string) {
        int n = -1;
        n = string.equalsIgnoreCase("varchar") ? 12 : (string.equalsIgnoreCase("numeric") ? 8 : (string.equalsIgnoreCase("date") ? 91 : (string.equalsIgnoreCase("time") ? 92 : (string.equalsIgnoreCase("timestamp") ? 93 : (string.equalsIgnoreCase("blob") ? -4 : 12)))));
        return n;
    }

    public int getFMTypeFromName(String string) {
        int n = -1;
        n = string.equalsIgnoreCase("varchar") ? 1 : (string.equalsIgnoreCase("numeric") || string.equalsIgnoreCase("int") ? 2 : (string.equalsIgnoreCase("date") ? 3 : (string.equalsIgnoreCase("time") ? 4 : (string.equalsIgnoreCase("timestamp") ? 5 : (string.equalsIgnoreCase("blob") ? 6 : 1)))));
        return n;
    }

    public String getFMType(int n) {
        String string = "";
        string = n == 12 ? "varchar" : (n == 8 ? "numeric" : (n == 91 ? "date" : (n == 92 ? "time" : (n == 93 ? "timestamp" : (n == -4 ? "blob" : (n == 4 ? "int" : (n == 5 ? "smallint" : (n == -6 ? "tinyint" : "varchar"))))))));
        return string;
    }

    protected void enableDriverManagerLogging() {
        if (DriverManager.getLogStream() == null) {
            DriverManager.setLogStream(System.out);
        }
    }

    public boolean isClosed() throws SQLException {
        if (Driver.logInfo) {
            Driver.info("boolean isClosed = dbc.isClosed();");
        }
        return this.fmStream == null;
    }

    public int getSQLType(String string) {
        return this.getFMType(string);
    }

    public void cancelQuery() throws SQLException {
        if (Driver.logInfo) {
            Driver.info("dbc.cancelQuery();");
        }
    }
}

