/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractDateValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractFieldSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.DateEarlierThanOrEqualToValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.DateEqualToValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.DateLaterThanOrEqualToValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.DateObjectEarlierThanOrEqualToValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.DateObjectEqualToValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.DateObjectLaterThanOrEqualToValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.IDate;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.IDateFormat;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ITimeZone;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.LongDateFormat;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.NormalDateFormat;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.SearchFieldType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ServerTimeZone;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ShortDateFormat;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.TimeZone;
import ch.systemsx.cisd.base.annotation.JsonObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@JsonObject(value="as.dto.common.search.DateFieldSearchCriteria")
public abstract class DateFieldSearchCriteria
extends AbstractFieldSearchCriteria<IDate> {
    private static final long serialVersionUID = 1L;
    private static final List<IDateFormat> DATE_FORMATS = new ArrayList<IDateFormat>();
    private ITimeZone timeZone = new ServerTimeZone();

    static {
        DATE_FORMATS.add(new ShortDateFormat());
        DATE_FORMATS.add(new NormalDateFormat());
        DATE_FORMATS.add(new LongDateFormat());
    }

    DateFieldSearchCriteria(String fieldName, SearchFieldType fieldType) {
        super(fieldName, fieldType);
    }

    public void thatEquals(Date date) {
        this.setFieldValue(new DateObjectEqualToValue(date));
    }

    public void thatEquals(String date) {
        this.setFieldValue(new DateEqualToValue(date));
    }

    public void thatIsLaterThanOrEqualTo(Date date) {
        this.setFieldValue(new DateObjectLaterThanOrEqualToValue(date));
    }

    public void thatIsLaterThanOrEqualTo(String date) {
        this.setFieldValue(new DateLaterThanOrEqualToValue(date));
    }

    public void thatIsEarlierThanOrEqualTo(Date date) {
        this.setFieldValue(new DateObjectEarlierThanOrEqualToValue(date));
    }

    public void thatIsEarlierThanOrEqualTo(String date) {
        this.setFieldValue(new DateEarlierThanOrEqualToValue(date));
    }

    public DateFieldSearchCriteria withServerTimeZone() {
        this.timeZone = new ServerTimeZone();
        return this;
    }

    public DateFieldSearchCriteria withTimeZone(int hourOffset) {
        this.timeZone = new TimeZone(hourOffset);
        return this;
    }

    public void setTimeZone(ITimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public ITimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public void setFieldValue(IDate value) {
        DateFieldSearchCriteria.checkValueFormat(value);
        super.setFieldValue(value);
    }

    private static void checkValueFormat(IDate value) {
        if (value instanceof AbstractDateValue) {
            for (IDateFormat dateFormat : DATE_FORMATS) {
                try {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat.getFormat());
                    simpleDateFormat.setLenient(false);
                    simpleDateFormat.parse((String)((AbstractDateValue)value).getValue());
                    return;
                }
                catch (ParseException parseException) {}
            }
            throw new IllegalArgumentException("Date value: " + value + " does not match any of the supported formats: " + DATE_FORMATS);
        }
    }
}

