/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.http;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import java.security.KeyStore;
import java.util.concurrent.Executor;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpProxy;
import org.eclipse.jetty.client.ProxyConfiguration;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;

public class JettyHttpClientFactory {
    private static HttpClient httpClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpClient getHttpClient() {
        if (httpClient != null) return httpClient;
        Class<JettyHttpClientFactory> clazz = JettyHttpClientFactory.class;
        synchronized (JettyHttpClientFactory.class) {
            HttpClient client = JettyHttpClientFactory.createHttpClient();
            String proxyHost = System.getProperties().getProperty("openbis.proxyHost");
            String proxyPort = System.getProperties().getProperty("openbis.proxyPort");
            if (proxyHost != null && proxyPort != null) {
                ProxyConfiguration proxyConfig = client.getProxyConfiguration();
                HttpProxy proxy = new HttpProxy(proxyHost, Integer.parseInt(proxyPort));
                proxyConfig.getProxies().add(proxy);
            }
            try {
                client.start();
                httpClient = client;
            }
            catch (Exception e) {
                throw CheckedExceptionTunnel.wrapIfNecessary(e);
            }
            return httpClient;
        }
    }

    private static HttpClient createHttpClient() {
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setEndpointIdentificationAlgorithm(null);
        String trustStorePath = System.getProperties().getProperty("javax.net.ssl.trustStore");
        if (trustStorePath != null) {
            sslContextFactory.setKeyStore(JettyHttpClientFactory.createDummyKeyStore());
            sslContextFactory.setTrustStorePath(trustStorePath);
        } else {
            sslContextFactory.setTrustAll(true);
        }
        HttpClient client = new HttpClient(sslContextFactory){

            protected void doStart() throws Exception {
                if (this.getExecutor() == null) {
                    QueuedThreadPool threadPool = new QueuedThreadPool();
                    threadPool.setName("openBIS-jetty");
                    threadPool.setDaemon(true);
                    this.setExecutor((Executor)threadPool);
                }
                if (this.getScheduler() == null) {
                    this.setScheduler((Scheduler)new ScheduledExecutorScheduler("openBIS-jetty-scheduler", true));
                }
                super.doStart();
            }
        };
        return client;
    }

    private static KeyStore createDummyKeyStore() {
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, null);
            return keyStore;
        }
        catch (Exception ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    private JettyHttpClientFactory() {
    }
}

