/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.spring;

import ch.systemsx.cisd.common.spring.HttpInvokerUtils;
import ch.systemsx.cisd.common.spring.IRemoteSpringBeanProvider;
import ch.systemsx.cisd.common.spring.JettyHttpInvokerRequestExecutor;
import com.marathon.util.spring.StreamSupportingHttpInvokerProxyFactoryBean;
import java.net.InetSocketAddress;
import java.util.List;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpProxy;
import org.eclipse.jetty.client.ProxyConfiguration;

public class JettyRemoteSpringBeanProvider
implements IRemoteSpringBeanProvider {
    private HttpClient client;

    public JettyRemoteSpringBeanProvider(HttpClient client) {
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public <T> T create(Class<T> serviceInterface, String serviceURL, long serverTimeoutInMillis) {
        JettyHttpInvokerRequestExecutor jettyExecutor = new JettyHttpInvokerRequestExecutor(this.client, serverTimeoutInMillis);
        StreamSupportingHttpInvokerProxyFactoryBean httpInvokerProxy = new StreamSupportingHttpInvokerProxyFactoryBean(jettyExecutor);
        httpInvokerProxy.setBeanClassLoader(serviceInterface.getClassLoader());
        httpInvokerProxy.setServiceUrl(serviceURL);
        httpInvokerProxy.setServiceInterface(serviceInterface);
        InetSocketAddress proxyAddress = HttpInvokerUtils.tryFindProxy(serviceURL);
        if (proxyAddress != null) {
            Class<JettyRemoteSpringBeanProvider> clazz = JettyRemoteSpringBeanProvider.class;
            // MONITORENTER : ch.systemsx.cisd.common.spring.JettyRemoteSpringBeanProvider.class
            List proxies = this.client.getProxyConfiguration().getProxies();
            if (!this.isProxyAlreadyInitialized(proxies, proxyAddress)) {
                proxies.add(new HttpProxy(proxyAddress.getHostName(), proxyAddress.getPort()));
            }
            // MONITOREXIT : clazz
        }
        httpInvokerProxy.afterPropertiesSet();
        return HttpInvokerUtils.getCastedService(httpInvokerProxy);
    }

    private boolean isProxyAlreadyInitialized(List<ProxyConfiguration.Proxy> proxies, InetSocketAddress proxyAddress) {
        for (ProxyConfiguration.Proxy proxy : proxies) {
            if (!proxy.getAddress().getHost().equals(proxyAddress.getHostName()) || proxy.getAddress().getPort() != proxyAddress.getPort()) continue;
            return true;
        }
        return false;
    }
}

