/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.microservices.download.server.startup;

import ch.ethz.sis.microservices.download.api.configuration.Config;
import ch.ethz.sis.microservices.download.server.json.jackson.JacksonObjectMapper;
import ch.ethz.sis.microservices.download.server.logging.LogManager;
import ch.ethz.sis.microservices.download.server.logging.Logger;
import ch.ethz.sis.microservices.download.server.logging.log4j.Log4J2LogFactory;
import ch.ethz.sis.microservices.download.server.startup.ServerLauncher;
import java.io.File;
import java.io.FileInputStream;

public class Main {
    private static Logger logger;

    public static void main(String[] args) throws Exception {
        File configFile;
        logger.info("Current Workspace: " + new File("").getAbsolutePath(), new Object[0]);
        if (args.length < 1) {
            configFile = new File("config.json");
            logger.info("No arguments given, starting with default config file: " + configFile.getAbsolutePath(), new Object[0]);
        } else {
            configFile = new File(args[0]);
        }
        Config config = JacksonObjectMapper.getInstance().readValue(new FileInputStream(configFile), Config.class);
        ServerLauncher servicesStarter = new ServerLauncher(config);
        servicesStarter.getServer().join();
    }

    static {
        LogManager.setLogFactory(new Log4J2LogFactory());
        logger = LogManager.getLogger(Main.class);
    }
}

