/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.bsse.cisd.plasmid.dss;

import ch.ethz.bsse.cisd.plasmid.dss.DataSetTypeOracle;
import ch.ethz.bsse.cisd.plasmid.plasmapper.PlasMapperUploader;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.filesystem.FileOperations;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.etlserver.AbstractDelegatingStorageProcessor;
import ch.systemsx.cisd.etlserver.AbstractDelegatingStorageProcessorTransaction;
import ch.systemsx.cisd.etlserver.IStorageProcessorTransactional;
import ch.systemsx.cisd.etlserver.ITypeExtractor;
import java.io.File;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class PlasmidStorageProcessor
extends AbstractDelegatingStorageProcessor {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, PlasmidStorageProcessor.class);
    private static final Logger notifyLog = LogFactory.getLogger((LogCategory)LogCategory.NOTIFY, PlasmidStorageProcessor.class);
    private static final String HTML_FILE_TEMPLATE = "<html><head>\n<meta http-equiv=\"content-type\" content=\"text/html; charset=ISO-8859-1\"><title>PlasMapper - Graphic Map</title></head>\n<body>\n<embed src=\"%%FILE_NAME%%\" type=\"image/svg+xml\" pluginspage=\"http://www.adobe.com/svg/viewer/install/\" id=\"Panel\" height=\"1010\" width=\"1010\">\n<br>\n<a href=\"%%FILE_NAME%%\" target=\"_blank\">Download Link</a></body></html>";
    private static final String PLASMAPPER_BASE_URL_KEY = "plasmapper-base-url";
    private static final String PLASMAPPER_ROOT_DIR_KEY = "plasmapper-root-dir";
    private static final String ORIGINAL_DIR = "original";
    private static final String GENERATED_DIR = "generated";
    private static final String GB_FILE_EXTENSION = ".gb";
    private static final String SVG_FILE_EXTENSION = ".svg";
    private final PlasMapperUploader uploader;
    private final String serverRootDir;

    public PlasmidStorageProcessor(Properties properties) {
        super(properties);
        String baseUrl = PropertyUtils.getMandatoryProperty((Properties)properties, (String)PLASMAPPER_BASE_URL_KEY);
        this.uploader = new PlasMapperUploader(baseUrl);
        this.serverRootDir = PropertyUtils.getMandatoryProperty((Properties)properties, (String)PLASMAPPER_ROOT_DIR_KEY);
        File serverRootFile = new File(this.serverRootDir);
        if (!serverRootFile.isDirectory() || !serverRootFile.canRead()) {
            String msg = String.format("'%s' (value of '%s' property) is supposed to be a path to an existing readable directory but isn't.", this.serverRootDir, PLASMAPPER_ROOT_DIR_KEY);
            throw new EnvironmentFailureException(msg);
        }
    }

    public IStorageProcessorTransactional.IStorageProcessorTransaction createTransaction(IStorageProcessorTransactional.StorageProcessorTransactionParameters parameters) {
        return new PlasmidStorageProcessorTransaction(parameters, super.createTransaction(parameters), this);
    }

    private void uploadAndCopyGeneratedFile(File seqFile, PlasMapperUploader.PlasMapperService service, File destinationFile) {
        String outputFilePath = this.uploader.upload(seqFile, service);
        if (StringUtils.isBlank((String)outputFilePath)) {
            notifyLog.error((Object)("Cannot upload file '" + seqFile.getName() + "', see jetty.out for details."));
            throw new IllegalStateException("Cannot upload file '" + seqFile.getName() + "', see jetty.out for details.");
        }
        File outputFile = new File((String.valueOf(this.serverRootDir) + outputFilePath).trim());
        if (outputFile.isFile()) {
            operationLog.info((Object)("Renaming and copying file '" + outputFile.getName() + "' from '" + outputFile + "' to " + destinationFile));
            FileOperations.getInstance().copyFile(outputFile, destinationFile);
            if (destinationFile.getName().endsWith("svg")) {
                String htmlFileName = destinationFile.getName().replaceAll(SVG_FILE_EXTENSION, ".html");
                File htmlFile = new File(destinationFile.getParentFile(), htmlFileName);
                operationLog.info((Object)("Generating html file '" + htmlFile + "'"));
                FileUtilities.writeToFile((File)htmlFile, (String)HTML_FILE_TEMPLATE.replaceAll("%%FILE_NAME%%", destinationFile.getName()));
            }
        } else {
            throw new EnvironmentFailureException("'" + outputFile + "' doesn't exist or is not a file.");
        }
    }

    static class PlasmidStorageProcessorTransaction
    extends AbstractDelegatingStorageProcessorTransaction {
        private static final long serialVersionUID = 1L;
        private final transient PlasmidStorageProcessor processor;

        public PlasmidStorageProcessorTransaction(IStorageProcessorTransactional.StorageProcessorTransactionParameters parameters, IStorageProcessorTransactional.IStorageProcessorTransaction superTransaction, PlasmidStorageProcessor processor) {
            super(parameters, superTransaction);
            this.processor = processor;
        }

        protected File executeStoreData(ITypeExtractor typeExtractor, IMailClient mailClient) {
            this.nestedTransaction.storeData(typeExtractor, mailClient, this.incomingDataSetDirectory);
            File answer = this.nestedTransaction.getStoredDataDirectory();
            boolean isSeqType = typeExtractor.getDataSetType(this.incomingDataSetDirectory).getCode().equals(DataSetTypeOracle.DataSetTypeInfo.SEQ_FILE.name());
            boolean isFaExtension = "fa".equals(FilenameUtils.getExtension((String)this.incomingDataSetDirectory.getName()));
            if (isSeqType && !isFaExtension) {
                File originalDir = new File(answer, PlasmidStorageProcessor.ORIGINAL_DIR);
                File[] files = originalDir.listFiles();
                assert (files.length == 1);
                File seqFile = files[0];
                String baseFileName = FilenameUtils.getBaseName((String)seqFile.getName());
                String svgFileName = String.valueOf(baseFileName) + PlasmidStorageProcessor.SVG_FILE_EXTENSION;
                String gbFileName = String.valueOf(baseFileName) + PlasmidStorageProcessor.GB_FILE_EXTENSION;
                File generatedDir = new File(answer, PlasmidStorageProcessor.GENERATED_DIR);
                if (generatedDir.mkdir()) {
                    File svgFileDest = new File(generatedDir, svgFileName);
                    File gbFileDest = new File(generatedDir, gbFileName);
                    operationLog.info((Object)("Uploading '" + seqFile.getName() + "' to PlasMapper."));
                    this.processor.uploadAndCopyGeneratedFile(seqFile, PlasMapperUploader.PlasMapperService.GRAPHIC_MAP, svgFileDest);
                    this.processor.uploadAndCopyGeneratedFile(seqFile, PlasMapperUploader.PlasMapperService.GENEBANK_OUTPUT, gbFileDest);
                } else {
                    throw new EnvironmentFailureException("Couldn't create directory '" + generatedDir + "'.");
                }
            }
            return answer;
        }

        protected IStorageProcessorTransactional.UnstoreDataAction executeRollback(Throwable ex) {
            return this.nestedTransaction.rollback(ex);
        }

        protected void executeCommit() {
            this.nestedTransaction.commit();
        }
    }
}

