/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.dssapi.v3.dto.datasetfile.download;

import ch.ethz.sis.openbis.generic.dssapi.v3.dto.datasetfile.DataSetFile;
import ch.ethz.sis.openbis.generic.dssapi.v3.dto.datasetfile.download.DataSetFileDownload;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class DataSetFileDownloadReader
implements Serializable {
    private static final long serialVersionUID = 1L;
    private InputStream in;
    private DataSetFileDownload lastDownload;

    public DataSetFileDownloadReader(InputStream in) {
        this.in = in;
    }

    public DataSetFileDownload read() {
        try {
            this.closeLastDownload();
            long headerSize = this.readSize();
            DataSetFile header = (DataSetFile)this.deserializeObject(headerSize);
            long contentSize = this.readSize();
            InputStream content = new InputStream(contentSize){
                long bytesToRead;
                {
                    this.bytesToRead = l;
                }

                @Override
                public int read() throws IOException {
                    if (DataSetFileDownloadReader.this.lastDownload.getInputStream() != this) {
                        throw new IllegalStateException("Input stream no longer valid");
                    }
                    if (this.bytesToRead > 0L) {
                        --this.bytesToRead;
                        return DataSetFileDownloadReader.this.in.read();
                    }
                    return -1;
                }
            };
            this.lastDownload = new DataSetFileDownload(header, content);
            return this.lastDownload;
        }
        catch (EOFException eOFException) {
            this.close();
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        try {
            this.in.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void closeLastDownload() throws IOException {
        if (this.lastDownload != null) {
            InputStream stream = this.lastDownload.getInputStream();
            while (stream.read() != -1) {
            }
            return;
        }
    }

    private long readSize() throws IOException {
        DataInputStream data = new DataInputStream(this.in);
        return data.readLong();
    }

    private Object deserializeObject(long objectSize) throws IOException, ClassNotFoundException {
        if (objectSize == 0L) {
            return null;
        }
        byte[] bytes = new byte[(int)objectSize];
        int i = 0;
        while ((long)i < objectSize) {
            bytes[i] = (byte)this.in.read();
            ++i;
        }
        ByteArrayInputStream b = new ByteArrayInputStream(bytes);
        ObjectInputStream o = new ObjectInputStream(b);
        return o.readObject();
    }
}

