/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.format.number;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Currency;
import java.util.Locale;
import org.springframework.format.number.AbstractNumberFormatter;
import org.springframework.util.ClassUtils;

public class CurrencyFormatter
extends AbstractNumberFormatter {
    private static final boolean roundingModeOnDecimalFormat = ClassUtils.hasMethod(DecimalFormat.class, "setRoundingMode", RoundingMode.class);
    private int fractionDigits = 2;
    private RoundingMode roundingMode;
    private Currency currency;

    public void setFractionDigits(int fractionDigits) {
        this.fractionDigits = fractionDigits;
    }

    public void setRoundingMode(RoundingMode roundingMode) {
        this.roundingMode = roundingMode;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    @Override
    public BigDecimal parse(String text, Locale locale) throws ParseException {
        BigDecimal decimal = (BigDecimal)super.parse(text, locale);
        if (decimal != null) {
            decimal = this.roundingMode != null ? decimal.setScale(this.fractionDigits, this.roundingMode) : decimal.setScale(this.fractionDigits);
        }
        return decimal;
    }

    @Override
    protected NumberFormat getNumberFormat(Locale locale) {
        DecimalFormat format = (DecimalFormat)NumberFormat.getCurrencyInstance(locale);
        format.setParseBigDecimal(true);
        format.setMaximumFractionDigits(this.fractionDigits);
        format.setMinimumFractionDigits(this.fractionDigits);
        if (this.roundingMode != null && roundingModeOnDecimalFormat) {
            format.setRoundingMode(this.roundingMode);
        }
        if (this.currency != null) {
            format.setCurrency(this.currency);
        }
        return format;
    }
}

