/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.imagereaders;

import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.base.io.ByteBufferRandomAccessFile;
import ch.systemsx.cisd.base.io.IRandomAccessFile;
import ch.systemsx.cisd.base.io.RandomAccessFileImpl;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.imagereaders.IImageReader;
import ch.systemsx.cisd.imagereaders.IReadParams;
import ch.systemsx.cisd.imagereaders.ImageID;
import java.awt.image.BufferedImage;
import java.io.File;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractImageReader
implements IImageReader {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, AbstractImageReader.class);
    private final String libraryName;
    private final String readerName;

    public AbstractImageReader(String libraryName, String readerName) {
        this.libraryName = libraryName;
        this.readerName = readerName;
    }

    @Override
    public String getLibraryName() {
        return this.libraryName;
    }

    @Override
    public String getName() {
        return this.readerName;
    }

    @Override
    public final List<ImageID> getImageIDs(File file) throws IOExceptionUnchecked {
        try (IRandomAccessFile raf = this.createRandomAccessFile(file);){
            List<ImageID> list = this.getImageIDs(raf);
            return list;
        }
    }

    @Override
    public final List<ImageID> getImageIDs(byte[] bytes) {
        return this.getImageIDs((IRandomAccessFile)new ByteBufferRandomAccessFile(bytes));
    }

    @Override
    public List<ImageID> getImageIDs(IRandomAccessFile handle) throws IOExceptionUnchecked {
        return Arrays.asList(ImageID.NULL);
    }

    @Override
    public BufferedImage readImage(File file, ImageID imageID, IReadParams params) throws IOExceptionUnchecked {
        try (IRandomAccessFile raf = this.createRandomAccessFile(file);){
            BufferedImage bufferedImage = this.readImage(raf, imageID, params);
            return bufferedImage;
        }
    }

    @Override
    public BufferedImage readImage(byte[] bytes, ImageID imageID, IReadParams params) {
        ByteBufferRandomAccessFile raf = new ByteBufferRandomAccessFile(bytes);
        return this.readImage((IRandomAccessFile)raf, imageID, params);
    }

    @Override
    public boolean isMetaDataAware() {
        return false;
    }

    @Override
    public Map<String, Object> readMetaData(File file, ImageID imageID, IReadParams params) throws IOExceptionUnchecked {
        return Collections.emptyMap();
    }

    @Override
    public Map<String, Object> readMetaData(byte[] bytes, ImageID imageID, IReadParams params) {
        return Collections.emptyMap();
    }

    @Override
    public Map<String, Object> readMetaData(IRandomAccessFile handle, ImageID imageID, IReadParams params) {
        return Collections.emptyMap();
    }

    @Override
    public void close() {
    }

    protected IRandomAccessFile createRandomAccessFile(File file) {
        return new RandomAccessFileWithLogging(file, operationLog);
    }

    private static final class RandomAccessFileWithLogging
    implements IRandomAccessFile {
        private static int counter;
        private final IRandomAccessFile file;
        private final Logger logger;
        private final int id;

        public RandomAccessFileWithLogging(File file, Logger logger) {
            this.file = new RandomAccessFileImpl(file, "r");
            this.logger = logger;
            this.id = counter++;
            logger.info((Object)("Create random access file object " + this.id + " for file " + file.getAbsolutePath()));
        }

        public void close() throws IOExceptionUnchecked {
            this.logger.info((Object)("Close random access file object " + this.id), (Throwable)new RuntimeException("Stack trace"));
            this.file.close();
            this.logger.info((Object)("Successfully closed random access file object " + this.id));
        }

        public int read() throws IOExceptionUnchecked {
            return this.file.read();
        }

        public int read(byte[] b) throws IOExceptionUnchecked {
            return this.file.read(b);
        }

        public ByteOrder getByteOrder() {
            return this.file.getByteOrder();
        }

        public int read(byte[] b, int off, int len) throws IOExceptionUnchecked {
            return this.file.read(b, off, len);
        }

        public void setByteOrder(ByteOrder byteOrder) {
            this.file.setByteOrder(byteOrder);
        }

        public long skip(long n) throws IOExceptionUnchecked {
            return this.file.skip(n);
        }

        public void flush() throws IOExceptionUnchecked {
            this.file.flush();
        }

        public long getFilePointer() throws IOExceptionUnchecked {
            return this.file.getFilePointer();
        }

        public int available() throws IOExceptionUnchecked {
            return this.file.available();
        }

        public void synchronize() throws IOExceptionUnchecked {
            this.file.synchronize();
        }

        public void mark(int readlimit) {
            this.file.mark(readlimit);
        }

        public void reset() throws IOExceptionUnchecked {
            this.file.reset();
        }

        public void seek(long pos) throws IOExceptionUnchecked {
            this.file.seek(pos);
        }

        public boolean markSupported() {
            return this.file.markSupported();
        }

        public long length() throws IOExceptionUnchecked {
            return this.file.length();
        }

        public void setLength(long newLength) throws IOExceptionUnchecked {
            this.file.setLength(newLength);
        }

        public void readFully(byte[] b) throws IOExceptionUnchecked {
            this.file.readFully(b);
        }

        public void readFully(byte[] b, int off, int len) throws IOExceptionUnchecked {
            this.file.readFully(b, off, len);
        }

        public int skipBytes(int n) throws IOExceptionUnchecked {
            return this.file.skipBytes(n);
        }

        public boolean readBoolean() throws IOExceptionUnchecked {
            return this.file.readBoolean();
        }

        public byte readByte() throws IOExceptionUnchecked {
            return this.file.readByte();
        }

        public int readUnsignedByte() throws IOExceptionUnchecked {
            return this.file.readUnsignedByte();
        }

        public short readShort() throws IOExceptionUnchecked {
            return this.file.readShort();
        }

        public int readUnsignedShort() throws IOExceptionUnchecked {
            return this.file.readUnsignedShort();
        }

        public char readChar() throws IOExceptionUnchecked {
            return this.file.readChar();
        }

        public int readInt() throws IOExceptionUnchecked {
            return this.file.readInt();
        }

        public long readLong() throws IOExceptionUnchecked {
            return this.file.readLong();
        }

        public float readFloat() throws IOExceptionUnchecked {
            return this.file.readFloat();
        }

        public double readDouble() throws IOExceptionUnchecked {
            return this.file.readDouble();
        }

        public String readLine() throws IOExceptionUnchecked {
            return this.file.readLine();
        }

        public String readUTF() throws IOExceptionUnchecked {
            return this.file.readUTF();
        }

        public void write(int b) throws IOExceptionUnchecked {
            this.file.write(b);
        }

        public void write(byte[] b) throws IOExceptionUnchecked {
            this.file.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOExceptionUnchecked {
            this.file.write(b, off, len);
        }

        public void writeBoolean(boolean v) throws IOExceptionUnchecked {
            this.file.writeBoolean(v);
        }

        public void writeByte(int v) throws IOExceptionUnchecked {
            this.file.writeByte(v);
        }

        public void writeShort(int v) throws IOExceptionUnchecked {
            this.file.writeShort(v);
        }

        public void writeChar(int v) throws IOExceptionUnchecked {
            this.file.writeChar(v);
        }

        public void writeInt(int v) throws IOExceptionUnchecked {
            this.file.writeInt(v);
        }

        public void writeLong(long v) throws IOExceptionUnchecked {
            this.file.writeLong(v);
        }

        public void writeFloat(float v) throws IOExceptionUnchecked {
            this.file.writeFloat(v);
        }

        public void writeDouble(double v) throws IOExceptionUnchecked {
            this.file.writeDouble(v);
        }

        public void writeBytes(String s) throws IOExceptionUnchecked {
            this.file.writeBytes(s);
        }

        public void writeChars(String s) throws IOExceptionUnchecked {
            this.file.writeChars(s);
        }

        public void writeUTF(String str) throws IOExceptionUnchecked {
            this.file.writeUTF(str);
        }
    }
}

