/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.imagereaders;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.imagereaders.IImageReaderLibrary;
import ch.systemsx.cisd.imagereaders.ImageReaderFactory;
import ch.systemsx.cisd.imagereaders.bioformats.BioFormatsReaderLibrary;
import ch.systemsx.cisd.imagereaders.ij.ImageJReaderLibrary;
import ch.systemsx.cisd.imagereaders.imageio.ImageIOReaderLibrary;
import ch.systemsx.cisd.imagereaders.jai.JAIReaderLibrary;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class ImageReadersTestHelper {
    private static final String SERVICES_FILE_TEMPLATE = "./resource/manifest/%s/META-INF/services/" + IImageReaderLibrary.class.getName();
    private static final Map<String, String> librariesByName = new HashMap<String, String>();

    static {
        librariesByName.put("ImageIO", "ch.systemsx.cisd.imagereaders.imageio.ImageIOReaderLibrary");
        librariesByName.put("IJ", "ch.systemsx.cisd.imagereaders.ij.ImageJReaderLibrary");
        librariesByName.put("JAI", "ch.systemsx.cisd.imagereaders.jai.JAIReaderLibrary");
        librariesByName.put("BioFormats", "ch.systemsx.cisd.imagereaders.bioformats.BioFormatsReaderLibrary");
    }

    public static void setUpLibraries(String ... libraryNames) throws Exception {
        ArrayList<IImageReaderLibrary> libs = new ArrayList<IImageReaderLibrary>();
        String[] stringArray = libraryNames;
        int n = libraryNames.length;
        int n2 = 0;
        while (n2 < n) {
            String libName = stringArray[n2];
            IImageReaderLibrary library = ImageReadersTestHelper.getLibraryFromMap(libName);
            libs.add(library);
            ++n2;
        }
        ImageReaderFactory.setLibraries(libs);
    }

    public static void setUpLibrariesFromManifest(String ... libraryNames) throws Exception {
        ArrayList<IImageReaderLibrary> libs = new ArrayList<IImageReaderLibrary>();
        String[] stringArray = libraryNames;
        int n = libraryNames.length;
        int n2 = 0;
        while (n2 < n) {
            String libName = stringArray[n2];
            IImageReaderLibrary library = ImageReadersTestHelper.getLibraryFromManifest(libName);
            libs.add(library);
            ++n2;
        }
        ImageReaderFactory.setLibraries(libs);
    }

    private static IImageReaderLibrary getLibraryFromMap(String library) throws Exception {
        String libClassName = librariesByName.get(library);
        if (libClassName == null) {
            throw new IllegalArgumentException("Unknown library name :" + library);
        }
        return (IImageReaderLibrary)Class.forName(libClassName).newInstance();
    }

    private static IImageReaderLibrary getLibraryFromManifest(String library) throws Exception {
        String libClassName = ImageReadersTestHelper.readLibraryClassName(library);
        return (IImageReaderLibrary)Class.forName(libClassName).newInstance();
    }

    private static String readLibraryClassName(String library) throws IOException {
        String servicesFileName = String.format(SERVICES_FILE_TEMPLATE, library);
        File servicesFile = new File(servicesFileName);
        if (!servicesFile.exists()) {
            throw new IllegalArgumentException("No service loader file definition for library " + library);
        }
        String fileContent = FileUtils.readFileToString((File)servicesFile, (String)"UTF-8");
        if (StringUtils.isBlank((String)fileContent)) {
            String error = String.format("Cannot read class name for library '%s' from '%s'", library, servicesFileName);
            throw new IllegalArgumentException(error);
        }
        String className = fileContent.trim();
        return className;
    }

    public static void main(String[] args) {
        ImageReadersTestHelper.printReaders(new ImageJReaderLibrary());
        ImageReadersTestHelper.printReaders((IImageReaderLibrary)new ImageIOReaderLibrary());
        ImageReadersTestHelper.printReaders((IImageReaderLibrary)new JAIReaderLibrary());
        ImageReadersTestHelper.printReaders((IImageReaderLibrary)new BioFormatsReaderLibrary());
    }

    private static void printReaders(IImageReaderLibrary library) {
        System.out.println(String.valueOf(library.getName()) + ": " + library.getReaderNames());
    }
}

