/*
 * Decompiled with CFR 0.152.
 */
package com.ziclix.python.sql.pipe.csv;

import com.ziclix.python.sql.pipe.Sink;
import com.ziclix.python.sql.pipe.csv.CSVString;
import java.io.PrintWriter;
import org.python27.core.Py;
import org.python27.core.PyObject;

public class CSVSink
implements Sink {
    protected boolean header = false;
    protected String delimiter;
    protected PrintWriter writer;
    protected PyObject converters;

    public CSVSink(PrintWriter writer) {
        this(writer, Py.None);
    }

    public CSVSink(PrintWriter writer, PyObject converters) {
        this.writer = writer;
        this.converters = converters;
        this.delimiter = ",";
    }

    @Override
    public void row(PyObject row) {
        String[] values = new String[row.__len__()];
        if (this.header) {
            for (int i = 0; i < row.__len__(); ++i) {
                values[i] = this.convert(Py.newInteger(i), row.__getitem__(i));
            }
        } else {
            for (int i = 0; i < row.__len__(); ++i) {
                values[i] = row.__getitem__(i).__getitem__(0).toString();
            }
            this.header = true;
        }
        this.println(values);
    }

    protected String convert(PyObject index, PyObject object) {
        PyObject converter;
        if (this.converters != Py.None && (converter = this.converters.__finditem__(index)) != Py.None) {
            object = converter.__call__(object);
        }
        if (object == Py.None || object == null) {
            return "";
        }
        return CSVString.toCSV(object.toString());
    }

    protected void println(String[] row) {
        for (int i = 0; i < row.length - 1; ++i) {
            this.writer.print(row[i]);
            this.writer.print(this.delimiter);
        }
        this.writer.println(row[row.length - 1]);
    }

    @Override
    public void start() {
    }

    @Override
    public void end() {
    }
}

