/*
 * Decompiled with CFR 0.152.
 */
package org.python27.apache.xerces.impl.dv.xs;

import javax.xml.datatype.XMLGregorianCalendar;
import org.python27.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.python27.apache.xerces.impl.dv.ValidationContext;
import org.python27.apache.xerces.impl.dv.xs.AbstractDateTimeDV;
import org.python27.apache.xerces.impl.dv.xs.SchemaDateTimeException;

public class YearDV
extends AbstractDateTimeDV {
    public Object getActualValue(String string2, ValidationContext validationContext) throws InvalidDatatypeValueException {
        try {
            return this.parse(string2);
        }
        catch (Exception exception) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{string2, "gYear"});
        }
    }

    protected AbstractDateTimeDV.DateTimeData parse(String string2) throws SchemaDateTimeException {
        int n;
        int n2;
        AbstractDateTimeDV.DateTimeData dateTimeData = new AbstractDateTimeDV.DateTimeData(string2, this);
        int n3 = string2.length();
        int n4 = 0;
        if (string2.charAt(0) == '-') {
            n4 = 1;
        }
        if ((n2 = ((n = this.findUTCSign(string2, n4, n3)) == -1 ? n3 : n) - n4) < 4) {
            throw new RuntimeException("Year must have 'CCYY' format");
        }
        if (n2 > 4 && string2.charAt(n4) == '0') {
            throw new RuntimeException("Leading zeros are required if the year value would otherwise have fewer than four digits; otherwise they are forbidden");
        }
        if (n == -1) {
            dateTimeData.year = this.parseIntYear(string2, n3);
        } else {
            dateTimeData.year = this.parseIntYear(string2, n);
            this.getTimeZone(string2, dateTimeData, n, n3);
        }
        dateTimeData.month = 1;
        dateTimeData.day = 1;
        this.validateDateTime(dateTimeData);
        this.saveUnnormalized(dateTimeData);
        if (dateTimeData.utc != 0 && dateTimeData.utc != 90) {
            this.normalize(dateTimeData);
        }
        dateTimeData.position = 0;
        return dateTimeData;
    }

    protected String dateToString(AbstractDateTimeDV.DateTimeData dateTimeData) {
        StringBuffer stringBuffer = new StringBuffer(5);
        this.append(stringBuffer, dateTimeData.year, 4);
        this.append(stringBuffer, (char)dateTimeData.utc, 0);
        return stringBuffer.toString();
    }

    protected XMLGregorianCalendar getXMLGregorianCalendar(AbstractDateTimeDV.DateTimeData dateTimeData) {
        return AbstractDateTimeDV.datatypeFactory.newXMLGregorianCalendar(dateTimeData.unNormYear, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, dateTimeData.hasTimeZone() ? dateTimeData.timezoneHr * 60 + dateTimeData.timezoneMin : Integer.MIN_VALUE);
    }
}

