/*
 * Decompiled with CFR 0.152.
 */
package org.python27.apache.xerces.util;

import java.io.IOException;
import javax.xml.parsers.SAXParserFactory;
import org.python27.apache.xerces.dom.DOMInputImpl;
import org.python27.apache.xerces.jaxp.SAXParserFactoryImpl;
import org.python27.apache.xerces.util.URI;
import org.python27.apache.xerces.xni.XMLResourceIdentifier;
import org.python27.apache.xerces.xni.XNIException;
import org.python27.apache.xerces.xni.parser.XMLEntityResolver;
import org.python27.apache.xerces.xni.parser.XMLInputSource;
import org.python27.apache.xml.resolver.Catalog;
import org.python27.apache.xml.resolver.CatalogManager;
import org.python27.apache.xml.resolver.readers.CatalogReader;
import org.python27.apache.xml.resolver.readers.SAXCatalogReader;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;

public class XMLCatalogResolver
implements XMLEntityResolver,
EntityResolver2,
LSResourceResolver {
    private CatalogManager fResolverCatalogManager = null;
    private Catalog fCatalog = null;
    private String[] fCatalogsList = null;
    private boolean fCatalogsChanged = true;
    private boolean fPreferPublic = true;
    private boolean fUseLiteralSystemId = true;

    public XMLCatalogResolver() {
        this(null, true);
    }

    public XMLCatalogResolver(String[] stringArray) {
        this(stringArray, true);
    }

    public XMLCatalogResolver(String[] stringArray, boolean bl) {
        this.init(stringArray, bl);
    }

    public final synchronized String[] getCatalogList() {
        return this.fCatalogsList != null ? (String[])this.fCatalogsList.clone() : null;
    }

    public final synchronized void setCatalogList(String[] stringArray) {
        this.fCatalogsChanged = true;
        this.fCatalogsList = stringArray != null ? (String[])stringArray.clone() : null;
    }

    public final synchronized void clear() {
        this.fCatalog = null;
    }

    public final boolean getPreferPublic() {
        return this.fPreferPublic;
    }

    public final void setPreferPublic(boolean bl) {
        this.fPreferPublic = bl;
        this.fResolverCatalogManager.setPreferPublic(bl);
    }

    public final boolean getUseLiteralSystemId() {
        return this.fUseLiteralSystemId;
    }

    public final void setUseLiteralSystemId(boolean bl) {
        this.fUseLiteralSystemId = bl;
    }

    public InputSource resolveEntity(String string2, String string3) throws SAXException, IOException {
        String string4 = null;
        if (string2 != null && string3 != null) {
            string4 = this.resolvePublic(string2, string3);
        } else if (string3 != null) {
            string4 = this.resolveSystem(string3);
        }
        if (string4 != null) {
            InputSource inputSource = new InputSource(string4);
            inputSource.setPublicId(string2);
            return inputSource;
        }
        return null;
    }

    public InputSource resolveEntity(String string2, String string3, String string4, String string5) throws SAXException, IOException {
        Object object;
        String string6 = null;
        if (!this.getUseLiteralSystemId() && string4 != null) {
            try {
                object = new URI(new URI(string4), string5);
                string5 = ((URI)object).toString();
            }
            catch (URI.MalformedURIException malformedURIException) {
                // empty catch block
            }
        }
        if (string3 != null && string5 != null) {
            string6 = this.resolvePublic(string3, string5);
        } else if (string5 != null) {
            string6 = this.resolveSystem(string5);
        }
        if (string6 != null) {
            object = new InputSource(string6);
            ((InputSource)object).setPublicId(string3);
            return object;
        }
        return null;
    }

    public InputSource getExternalSubset(String string2, String string3) throws SAXException, IOException {
        return null;
    }

    public LSInput resolveResource(String string2, String string3, String string4, String string5, String string6) {
        String string7 = null;
        try {
            if (string3 != null) {
                string7 = this.resolveURI(string3);
            }
            if (!this.getUseLiteralSystemId() && string6 != null) {
                try {
                    URI uRI = new URI(new URI(string6), string5);
                    string5 = uRI.toString();
                }
                catch (URI.MalformedURIException malformedURIException) {
                    // empty catch block
                }
            }
            if (string7 == null) {
                if (string4 != null && string5 != null) {
                    string7 = this.resolvePublic(string4, string5);
                } else if (string5 != null) {
                    string7 = this.resolveSystem(string5);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (string7 != null) {
            return new DOMInputImpl(string4, string7, string6);
        }
        return null;
    }

    public XMLInputSource resolveEntity(XMLResourceIdentifier xMLResourceIdentifier) throws XNIException, IOException {
        String string2 = this.resolveIdentifier(xMLResourceIdentifier);
        if (string2 != null) {
            return new XMLInputSource(xMLResourceIdentifier.getPublicId(), string2, xMLResourceIdentifier.getBaseSystemId());
        }
        return null;
    }

    public String resolveIdentifier(XMLResourceIdentifier xMLResourceIdentifier) throws IOException, XNIException {
        String string2 = null;
        String string3 = xMLResourceIdentifier.getNamespace();
        if (string3 != null) {
            string2 = this.resolveURI(string3);
        }
        if (string2 == null) {
            String string4;
            String string5 = xMLResourceIdentifier.getPublicId();
            String string6 = string4 = this.getUseLiteralSystemId() ? xMLResourceIdentifier.getLiteralSystemId() : xMLResourceIdentifier.getExpandedSystemId();
            if (string5 != null && string4 != null) {
                string2 = this.resolvePublic(string5, string4);
            } else if (string4 != null) {
                string2 = this.resolveSystem(string4);
            }
        }
        return string2;
    }

    public final synchronized String resolveSystem(String string2) throws IOException {
        if (this.fCatalogsChanged) {
            this.parseCatalogs();
            this.fCatalogsChanged = false;
        }
        return this.fCatalog != null ? this.fCatalog.resolveSystem(string2) : null;
    }

    public final synchronized String resolvePublic(String string2, String string3) throws IOException {
        if (this.fCatalogsChanged) {
            this.parseCatalogs();
            this.fCatalogsChanged = false;
        }
        return this.fCatalog != null ? this.fCatalog.resolvePublic(string2, string3) : null;
    }

    public final synchronized String resolveURI(String string2) throws IOException {
        if (this.fCatalogsChanged) {
            this.parseCatalogs();
            this.fCatalogsChanged = false;
        }
        return this.fCatalog != null ? this.fCatalog.resolveURI(string2) : null;
    }

    private void init(String[] stringArray, boolean bl) {
        this.fCatalogsList = stringArray != null ? (String[])stringArray.clone() : null;
        this.fPreferPublic = bl;
        this.fResolverCatalogManager = new CatalogManager();
        this.fResolverCatalogManager.setAllowOasisXMLCatalogPI(false);
        this.fResolverCatalogManager.setCatalogClassName("org.python27.apache.xml.resolver.Catalog");
        this.fResolverCatalogManager.setCatalogFiles("");
        this.fResolverCatalogManager.setIgnoreMissingProperties(true);
        this.fResolverCatalogManager.setPreferPublic(this.fPreferPublic);
        this.fResolverCatalogManager.setRelativeCatalogs(false);
        this.fResolverCatalogManager.setUseStaticCatalog(false);
        this.fResolverCatalogManager.setVerbosity(0);
    }

    private void parseCatalogs() throws IOException {
        if (this.fCatalogsList != null) {
            this.fCatalog = new Catalog(this.fResolverCatalogManager);
            this.attachReaderToCatalog(this.fCatalog);
            int n = 0;
            while (n < this.fCatalogsList.length) {
                String string2 = this.fCatalogsList[n];
                if (string2 != null && string2.length() > 0) {
                    this.fCatalog.parseCatalog(string2);
                }
                ++n;
            }
        } else {
            this.fCatalog = null;
        }
    }

    private void attachReaderToCatalog(Catalog catalog) {
        SAXParserFactoryImpl sAXParserFactoryImpl = new SAXParserFactoryImpl();
        sAXParserFactoryImpl.setNamespaceAware(true);
        sAXParserFactoryImpl.setValidating(false);
        SAXCatalogReader sAXCatalogReader = new SAXCatalogReader((SAXParserFactory)sAXParserFactoryImpl);
        sAXCatalogReader.setCatalogParser("urn:oasis:names:tc:entity:xmlns:xml:catalog", "catalog", "org.python27.apache.xml.resolver.readers.OASISXMLCatalogReader");
        catalog.addReader("application/xml", (CatalogReader)sAXCatalogReader);
    }
}

