/*
 * Decompiled with CFR 0.152.
 */
package org.python27.bouncycastle.cert;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import org.python27.bouncycastle.asn1.ASN1OctetString;
import org.python27.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.python27.bouncycastle.asn1.x509.Extension;
import org.python27.bouncycastle.asn1.x509.GeneralName;
import org.python27.bouncycastle.asn1.x509.GeneralNames;
import org.python27.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.python27.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.python27.bouncycastle.cert.CertRuntimeException;
import org.python27.bouncycastle.cert.X509CertificateHolder;
import org.python27.bouncycastle.operator.DigestCalculator;

public class X509ExtensionUtils {
    private DigestCalculator calculator;

    public X509ExtensionUtils(DigestCalculator digestCalculator) {
        this.calculator = digestCalculator;
    }

    public AuthorityKeyIdentifier createAuthorityKeyIdentifier(X509CertificateHolder x509CertificateHolder) {
        GeneralName generalName = new GeneralName(x509CertificateHolder.getIssuer());
        return new AuthorityKeyIdentifier(this.getSubjectKeyIdentifier(x509CertificateHolder), new GeneralNames(generalName), x509CertificateHolder.getSerialNumber());
    }

    public AuthorityKeyIdentifier createAuthorityKeyIdentifier(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        return new AuthorityKeyIdentifier(this.calculateIdentifier(subjectPublicKeyInfo));
    }

    public AuthorityKeyIdentifier createAuthorityKeyIdentifier(SubjectPublicKeyInfo subjectPublicKeyInfo, GeneralNames generalNames, BigInteger bigInteger) {
        return new AuthorityKeyIdentifier(this.calculateIdentifier(subjectPublicKeyInfo), generalNames, bigInteger);
    }

    public SubjectKeyIdentifier createSubjectKeyIdentifier(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        return new SubjectKeyIdentifier(this.calculateIdentifier(subjectPublicKeyInfo));
    }

    public SubjectKeyIdentifier createTruncatedSubjectKeyIdentifier(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        byte[] byArray = this.calculateIdentifier(subjectPublicKeyInfo);
        byte[] byArray2 = new byte[8];
        System.arraycopy(byArray, byArray.length - 8, byArray2, 0, byArray2.length);
        byArray2[0] = (byte)(byArray2[0] & 0xF);
        byArray2[0] = (byte)(byArray2[0] | 0x40);
        return new SubjectKeyIdentifier(byArray2);
    }

    private byte[] getSubjectKeyIdentifier(X509CertificateHolder x509CertificateHolder) {
        if (x509CertificateHolder.getVersionNumber() != 3) {
            return this.calculateIdentifier(x509CertificateHolder.getSubjectPublicKeyInfo());
        }
        Extension extension2 = x509CertificateHolder.getExtension(Extension.subjectKeyIdentifier);
        if (extension2 != null) {
            return ASN1OctetString.getInstance(extension2.getParsedValue()).getOctets();
        }
        return this.calculateIdentifier(x509CertificateHolder.getSubjectPublicKeyInfo());
    }

    private byte[] calculateIdentifier(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        byte[] byArray = subjectPublicKeyInfo.getPublicKeyData().getBytes();
        OutputStream outputStream = this.calculator.getOutputStream();
        try {
            outputStream.write(byArray);
            outputStream.close();
        }
        catch (IOException iOException) {
            throw new CertRuntimeException("unable to calculate identifier: " + iOException.getMessage(), iOException);
        }
        return this.calculator.getDigest();
    }
}

