/*
 * Decompiled with CFR 0.152.
 */
package org.python27.bouncycastle.cert.crmf.jcajce;

import java.io.InputStream;
import java.security.Key;
import java.security.PrivateKey;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.python27.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.python27.bouncycastle.cert.crmf.CRMFException;
import org.python27.bouncycastle.cert.crmf.ValueDecryptorGenerator;
import org.python27.bouncycastle.cert.crmf.jcajce.CRMFHelper;
import org.python27.bouncycastle.jcajce.io.CipherInputStream;
import org.python27.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.python27.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.python27.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.python27.bouncycastle.operator.InputDecryptor;
import org.python27.bouncycastle.operator.OperatorException;
import org.python27.bouncycastle.operator.jcajce.JceAsymmetricKeyUnwrapper;

public class JceAsymmetricValueDecryptorGenerator
implements ValueDecryptorGenerator {
    private PrivateKey recipientKey;
    private CRMFHelper helper = new CRMFHelper(new DefaultJcaJceHelper());
    private Provider provider = null;
    private String providerName = null;

    public JceAsymmetricValueDecryptorGenerator(PrivateKey privateKey) {
        this.recipientKey = privateKey;
    }

    public JceAsymmetricValueDecryptorGenerator setProvider(Provider provider2) {
        this.helper = new CRMFHelper(new ProviderJcaJceHelper(provider2));
        this.provider = provider2;
        this.providerName = null;
        return this;
    }

    public JceAsymmetricValueDecryptorGenerator setProvider(String string2) {
        this.helper = new CRMFHelper(new NamedJcaJceHelper(string2));
        this.provider = null;
        this.providerName = string2;
        return this;
    }

    private Key extractSecretKey(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, byte[] byArray) throws CRMFException {
        try {
            JceAsymmetricKeyUnwrapper jceAsymmetricKeyUnwrapper = new JceAsymmetricKeyUnwrapper(algorithmIdentifier, this.recipientKey);
            if (this.provider != null) {
                jceAsymmetricKeyUnwrapper.setProvider(this.provider);
            }
            if (this.providerName != null) {
                jceAsymmetricKeyUnwrapper.setProvider(this.providerName);
            }
            return new SecretKeySpec((byte[])jceAsymmetricKeyUnwrapper.generateUnwrappedKey(algorithmIdentifier2, byArray).getRepresentation(), algorithmIdentifier2.getAlgorithm().getId());
        }
        catch (OperatorException operatorException) {
            throw new CRMFException("key invalid in message: " + operatorException.getMessage(), operatorException);
        }
    }

    public InputDecryptor getValueDecryptor(AlgorithmIdentifier algorithmIdentifier, final AlgorithmIdentifier algorithmIdentifier2, byte[] byArray) throws CRMFException {
        Key key = this.extractSecretKey(algorithmIdentifier, algorithmIdentifier2, byArray);
        final Cipher cipher = this.helper.createContentCipher(key, algorithmIdentifier2);
        return new InputDecryptor(){

            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return algorithmIdentifier2;
            }

            public InputStream getInputStream(InputStream inputStream) {
                return new CipherInputStream(inputStream, cipher);
            }
        };
    }
}

