/*
 * Decompiled with CFR 0.152.
 */
package org.python27.bouncycastle.cert.dane;

import java.io.IOException;
import java.io.OutputStream;
import org.python27.bouncycastle.cert.dane.DANEEntrySelector;
import org.python27.bouncycastle.cert.dane.DANEException;
import org.python27.bouncycastle.operator.DigestCalculator;
import org.python27.bouncycastle.util.Strings;
import org.python27.bouncycastle.util.encoders.Hex;

public class DANEEntrySelectorFactory {
    private final DigestCalculator digestCalculator;

    public DANEEntrySelectorFactory(DigestCalculator digestCalculator) {
        this.digestCalculator = digestCalculator;
    }

    public DANEEntrySelector createSelector(String string2) throws DANEException {
        Object object;
        byte[] byArray = Strings.toUTF8ByteArray(string2.substring(0, string2.indexOf(64)));
        try {
            object = this.digestCalculator.getOutputStream();
            ((OutputStream)object).write(byArray);
            ((OutputStream)object).close();
        }
        catch (IOException iOException) {
            throw new DANEException("Unable to calculate digest string: " + iOException.getMessage(), iOException);
        }
        object = this.digestCalculator.getDigest();
        String string3 = Strings.fromByteArray(Hex.encode((byte[])object)) + "._smimecert." + string2.substring(string2.indexOf(64) + 1);
        return new DANEEntrySelector(string3);
    }
}

