/*
 * Decompiled with CFR 0.152.
 */
package org.python27.bouncycastle.cms;

import java.io.IOException;
import org.python27.bouncycastle.asn1.cms.KEKIdentifier;
import org.python27.bouncycastle.asn1.cms.KEKRecipientInfo;
import org.python27.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.python27.bouncycastle.cms.AuthAttributesProvider;
import org.python27.bouncycastle.cms.CMSException;
import org.python27.bouncycastle.cms.CMSSecureReadable;
import org.python27.bouncycastle.cms.KEKRecipient;
import org.python27.bouncycastle.cms.KEKRecipientId;
import org.python27.bouncycastle.cms.Recipient;
import org.python27.bouncycastle.cms.RecipientInformation;
import org.python27.bouncycastle.cms.RecipientOperator;

public class KEKRecipientInformation
extends RecipientInformation {
    private KEKRecipientInfo info;

    KEKRecipientInformation(KEKRecipientInfo kEKRecipientInfo, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable, AuthAttributesProvider authAttributesProvider) {
        super(kEKRecipientInfo.getKeyEncryptionAlgorithm(), algorithmIdentifier, cMSSecureReadable, authAttributesProvider);
        this.info = kEKRecipientInfo;
        KEKIdentifier kEKIdentifier = kEKRecipientInfo.getKekid();
        this.rid = new KEKRecipientId(kEKIdentifier.getKeyIdentifier().getOctets());
    }

    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        return ((KEKRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

